package com.payu.upiboltcore.network

import com.payu.commonmodelssdk.constants.ApiConstant
import com.payu.commonmodelssdk.constants.PayUUpiConstant
import com.payu.commonmodelssdk.listeners.PayUAsyncTaskResponse
import com.payu.upiboltcore.constants.URLConstants

class UpiCoreApiService {

    fun getUPIToken(headerMap: HashMap<String, String>, request: String, callback: PayUAsyncTaskResponse) {
        val networkData = postRequestNetworkData(headerMap, request, URLConstants.GET_NPCI_TOKEN_URL)
        HttpApiCall().makePostAPICall(PayUUpiConstant.PAYU_POST, networkData, callback)
    }

    fun checkDeviceStatus(headerMap: HashMap<String, String>, request: String, callback: PayUAsyncTaskResponse) {
        val networkData = postRequestNetworkData(headerMap, request, URLConstants.CHECK_DEVICE_STATUS_URL)
        HttpApiCall().makePostAPICall(PayUUpiConstant.PAYU_POST, networkData, callback)
    }

    fun getListKeys(headerMap: HashMap<String, String>, request: String, callback: PayUAsyncTaskResponse) {
        val networkData = postRequestNetworkData(headerMap, request, URLConstants.GET_LIST_KEYS_URL)
        HttpApiCall().makePostAPICall(PayUUpiConstant.PAYU_POST, networkData, callback)
    }

    fun initiateMPinSetup(headerMap: HashMap<String, String>, request: String, callback: PayUAsyncTaskResponse) {
        val networkData = postRequestNetworkData(headerMap, request, URLConstants.INITIATE_MPIN_SETUP_URL)
        HttpApiCall().makePostAPICall(PayUUpiConstant.PAYU_POST, networkData, callback)
    }

    fun setMPin(headerMap: HashMap<String, String>, request: String, callback: PayUAsyncTaskResponse) {
        val networkData = postRequestNetworkData(headerMap, request, URLConstants.CONFIRM_MPIN_URL)
        HttpApiCall().makePostAPICall(PayUUpiConstant.PAYU_POST, networkData, callback)
    }

    fun addAccount(headerMap: HashMap<String, String>, request: String, callback: PayUAsyncTaskResponse) {
        val networkData = postRequestNetworkData(headerMap, request, URLConstants.ADD_ACCOUNT_URL)
        HttpApiCall().makePostAPICall(PayUUpiConstant.PAYU_POST, networkData, callback)
    }

    fun checkVPA(headerMap: HashMap<String, String>, request: String, callback: PayUAsyncTaskResponse) {
        val networkData = postRequestNetworkData(headerMap, request, URLConstants.CHECK_VPA_URL)
        HttpApiCall().makePostAPICall(PayUUpiConstant.PAYU_POST, networkData, callback)
    }

    fun registerVPA(headerMap: HashMap<String, String>, request: String, callback: PayUAsyncTaskResponse) {
        val networkData = postRequestNetworkData(headerMap, request, URLConstants.REGISTER_VPA_URL)
        HttpApiCall().makePostAPICall(PayUUpiConstant.PAYU_POST, networkData, callback)
    }

    fun changeMPin(headerMap: HashMap<String, String>, request: String, callback: PayUAsyncTaskResponse) {
        val networkData = postRequestNetworkData(headerMap, request, URLConstants.CHANGE_MPIN_URL)
        HttpApiCall().makePostAPICall(PayUUpiConstant.PAYU_PATCH, networkData, callback)
    }

    fun balanceEnquiry(headerMap: HashMap<String, String>, request: String, callback: PayUAsyncTaskResponse) {
        val networkData = postRequestNetworkData(headerMap, request, URLConstants.BALANCE_ENQUIRY_URL)
        HttpApiCall().makePostAPICall(PayUUpiConstant.PAYU_POST, networkData, callback)
    }

    fun makePayment(headerMap: HashMap<String, String>, request: String, callback: PayUAsyncTaskResponse) {
        val networkData = postRequestNetworkData(headerMap, request, URLConstants.MAKE_PAYMENT_URL)
        HttpApiCall().makePostAPICall(PayUUpiConstant.PAYU_POST, networkData, callback)
    }

    fun getBanksList(headerMap: HashMap<String, String>,request: String, callback: PayUAsyncTaskResponse) {
        val networkData = postRequestNetworkData(headerMap,request, URLConstants.BANKS_LIST_URL)
        HttpApiCall().makePostAPICall(PayUUpiConstant.PAYU_POST, networkData, callback)
    }

    fun getAccountsList(headerMap: HashMap<String, String>, request: String, callback: PayUAsyncTaskResponse) {
        val networkData = postRequestNetworkData(headerMap, request, URLConstants.ACCOUNTS_LIST_URL)
        HttpApiCall().makePostAPICall(PayUUpiConstant.PAYU_POST, networkData, callback)
    }

    fun checkTransactionStatus(headerMap: HashMap<String, String>, request: String, callback: PayUAsyncTaskResponse) {
        val networkData = postRequestNetworkData(headerMap, request, URLConstants.TRANSACTION_STATUS_URL)
        HttpApiCall().makePostAPICall(PayUUpiConstant.PAYU_POST, networkData, callback)
    }

    fun deRegisterVPA(headerMap: HashMap<String, String>, request: String, callback: PayUAsyncTaskResponse) {
        val networkData = postRequestNetworkData(headerMap, request, URLConstants.DEREGISTER_VPA_URL)
        HttpApiCall().makePostAPICall(PayUUpiConstant.PAYU_DELETE, networkData, callback)
    }

    fun raiseDispute(headerMap: HashMap<String, String>, request: String, callback: PayUAsyncTaskResponse) {
        val networkData = postRequestNetworkData(headerMap, request, URLConstants.RAISE_DISPUTE_URL)
        HttpApiCall().makePostAPICall(PayUUpiConstant.PAYU_POST, networkData, callback)
    }

    private fun getRequestNetworkData(
        headerMap: HashMap<String, String>,
        requestMap: HashMap<String, Any>,
        url: String
    ) = com.payu.commonmodelssdk.model.PayUNetworkData(
        url,
        getRequest = requestMap,
        headerMap = headerMap
    )

    private fun postRequestNetworkData(
        headerMap: HashMap<String, String>,
        request: String,
        url: String
    ) = com.payu.commonmodelssdk.model.PayUNetworkData(
        url,
        postRequest = request,
        headerMap = headerMap,
        contentType = ApiConstant.PAYU_APPLICATION_JSON
    )

    fun getProfile(headerMap: HashMap<String, String>, request: String, callback: PayUAsyncTaskResponse) {
        val networkData = postRequestNetworkData(headerMap, request, URLConstants.GET_PROFILE_URL)
        HttpApiCall().makePostAPICall(PayUUpiConstant.PAYU_POST, networkData, callback)
    }
    fun removeAccount(headerMap: HashMap<String, String>, request: String, callback: PayUAsyncTaskResponse) {
        val networkData = postRequestNetworkData(headerMap, request, URLConstants.REMOVE_ACCOUNT_URL)
        HttpApiCall().makePostAPICall(PayUUpiConstant.PAYU_POST, networkData, callback)
    }
    fun getDisputeList(headerMap: HashMap<String, String>, request: String, callback: PayUAsyncTaskResponse) {
        val networkData = postRequestNetworkData(headerMap, request, URLConstants.DISPUTE_LIST_URL)
        HttpApiCall().makePostAPICall(PayUUpiConstant.PAYU_POST, networkData, callback)
    }

    fun verifyServerGenId(headerMap: HashMap<String, String>, request: String, callback: PayUAsyncTaskResponse) {
        val networkData = postRequestNetworkData(headerMap, request, URLConstants.VERIFY_SERVER_GEN_ID_URL)
        HttpApiCall().makePostAPICall(PayUUpiConstant.PAYU_POST, networkData, callback)
    }

    fun getTransactionHistoryList(headerMap: HashMap<String, String>, request: String, callback: PayUAsyncTaskResponse) {
        val networkData = postRequestNetworkData(headerMap, request, URLConstants.TRANSACTION_HISTORY_URL )
        HttpApiCall().makePostAPICall(PayUUpiConstant.PAYU_POST, networkData, callback)
    }

    fun getDisputeTypeList(headerMap: HashMap<String, String>, request: String, callback: PayUAsyncTaskResponse) {
        val networkData = postRequestNetworkData(headerMap, request, URLConstants.DISPUTE_TYPE_LIST_URL)
        HttpApiCall().makePostAPICall(PayUUpiConstant.PAYU_POST, networkData, callback)
    }

    fun validateOTP(headerMap: HashMap<String, String>, request: String, callback: PayUAsyncTaskResponse) {
        val networkData = postRequestNetworkData(headerMap, request, URLConstants.VALIDATE_OTP_URL)
        HttpApiCall().makePostAPICall(PayUUpiConstant.PAYU_POST, networkData, callback)
    }
}