package com.payu.upiboltcore.utils

import android.Manifest
import android.annotation.SuppressLint
import android.content.Context
import android.content.pm.PackageManager
import android.os.Build
import android.provider.Settings
import android.telephony.SubscriptionInfo
import android.telephony.SubscriptionManager
import androidx.core.app.ActivityCompat
import androidx.core.content.ContextCompat
import com.payu.commonmodelssdk.constants.PayUUpiConstant
import java.util.Locale

internal object PayUAndroidUtils {

    fun isSimStateActive(context: Context, mobile: String): Boolean {
        return getActivePhoneNumberList(context)?.find {
            it?.contains(mobile) == true
        }.isNullOrEmpty().not()
    }

    @SuppressLint("MissingPermission")
    private fun getActivePhoneNumberList(context: Context): List<String?>? {
        if (Build.VERSION.SDK_INT > Build.VERSION_CODES.LOLLIPOP_MR1) {
            val sm: SubscriptionManager? =
                ContextCompat.getSystemService(context, SubscriptionManager::class.java)
            if (ActivityCompat.checkSelfPermission(context, Manifest.permission.READ_PHONE_STATE)
                == PackageManager.PERMISSION_GRANTED
            ) {
                val subscriptionInfoList = sm?.activeSubscriptionInfoList
                return subscriptionInfoList?.map {
                    if (it.carrierName.toString().uppercase(Locale.ROOT)
                        != PayUUpiConstant.PAYU_CARRIER_NO_SERVICE) {
                        getPhoneNoFromSubscriptionInfo(context, sm, it)
                    } else null
                }
            }
        }
        return null
    }

    @SuppressLint("MissingPermission")
    private fun getPhoneNoFromSubscriptionInfo(context: Context, sm: SubscriptionManager, sim: SubscriptionInfo): String? {
        var phone: String? = null
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP_MR1) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
                if (ActivityCompat.checkSelfPermission(
                        context, Manifest.permission.READ_PHONE_NUMBERS)
                    == PackageManager.PERMISSION_GRANTED) {
                    phone = sm.getPhoneNumber(sim.subscriptionId)
                }
            } else {
                val permission = if (Build.VERSION.SDK_INT <= Build.VERSION_CODES.Q)
                    Manifest.permission.READ_PHONE_STATE
                else Manifest.permission.READ_PHONE_NUMBERS
                if (ActivityCompat.checkSelfPermission(context, permission)
                    == PackageManager.PERMISSION_GRANTED
                ) {
                    phone = sim.number
                }
            }
            phone = phone?.let { Utils.formatMobileNumber(it) }
        }
        return phone
    }

    fun isAirplaneModeOn(context: Context): Boolean {
        return Settings.Global.getInt(
            context.contentResolver,
            Settings.Global.AIRPLANE_MODE_ON,
            0
        ) != 0
    }
}