package com.payu.upiboltcore.utils

import android.content.Context
import com.payu.upiboltcore.constants.UPIConstants.Companion.SP_FILE_NAME

internal object PayUSPUtils {

    fun saveStringInSP(context: Context, key: String, value: String) {
        val preferences = context.getSharedPreferences(SP_FILE_NAME, Context.MODE_PRIVATE)
        preferences.edit().putString(key, value).apply()
    }

    fun getStringFromSP(context: Context, key: String): String? {
        val preferences = context.getSharedPreferences(SP_FILE_NAME, Context.MODE_PRIVATE)
        return preferences.getString(key, null)
    }

    fun clearSharedPreferences(context: Context) {
        context.getSharedPreferences(SP_FILE_NAME, Context.MODE_PRIVATE).edit().run {
            clear()
            apply()
        }
    }
}