package com.payu.upiboltcore.utils

import com.payu.upiboltcore.constants.UPIConstants

internal object PayUValidationUtils {

    fun validateTxnHistoryRequestParams(startDate: String, endDate: String): String {
        return if (startDate.isEmpty())
            UPIConstants.PARAM_START_DATE
        else if (endDate.isEmpty())
            UPIConstants.PARAM_END_DATE
        else ""
    }

    fun validateAccountListRequestParams(bankCode: String, requestType: String): String {
        return if (bankCode.isEmpty())
            UPIConstants.PARAM_BANK_CODE
        else if (requestType.isEmpty())
            UPIConstants.PARAM_REQUEST_TYPE
        else ""
    }

    fun validateRaiseDisputeRequestParams(
        txnId: String, query: String
    ):String {
        return if (txnId.isEmpty())
            UPIConstants.PARAM_TXN_ID
        else if (query.isEmpty())
            UPIConstants.PARAM_QUERY
        else ""
    }

    fun validateActivateAccountParams(cardNo: String, exp: String): String {
        return if (cardNo.isEmpty())
            UPIConstants.PARAM_CARD_NO
        else if (exp.isEmpty())
            UPIConstants.PARAM_EXPIRY
        else ""
    }

    fun validateRegisterVPAParams(vpa: String): String {
        return if (vpa.isEmpty())
            UPIConstants.PARAM_VPA
        else ""
    }

    fun validatePaymentParams(
        amount: String, payeeName: String, payeeVpa: String,
        txnId: String, initMode: String, purpose: String
    ): String {
        return if (txnId.isEmpty())
            UPIConstants.PARAM_TXN_ID
        else if (amount.isEmpty())
            UPIConstants.PARAM_AMOUNT
        else if (payeeName.isEmpty())
            UPIConstants.PARAM_PAYEE_NAME
        else if (payeeVpa.isEmpty())
            UPIConstants.PARAM_PAYEE_VPA
        else if (initMode.isEmpty())
            UPIConstants.PARAM_INIT_MODE
        else if (purpose.isEmpty())
            UPIConstants.PARAM_PURPOSE
        else ""
    }

    fun validateDisputeTypeListParams(upiTxnRefNo: String): String {
        return if (upiTxnRefNo.isEmpty())
            UPIConstants.PARAM_TXN_REF_NO
        else ""
    }

    fun validateDisputeStatusParams(txnId: String): String {
        return if (txnId.isEmpty())
            UPIConstants.PARAM_TXN_ID
        else ""
    }
}