package com.payu.upiboltcore.utils

import com.payu.upiboltcore.models.AccountInfo
import com.payu.upiboltcore.models.Credential

internal object TransformerUtils {

    fun getCredentialFromAccount(accountInfo: AccountInfo): Credential {
        return Credential(
            credentialDataType = accountInfo.credentialType,
            credentialDataLength = accountInfo.credentialLength,
            atmCredentialLength = accountInfo.atmPinLength,
            atmCredentialType = accountInfo.atmDataType,
            atmFormatType = accountInfo.formatType,
            otpCredentialLength = accountInfo.otpLength,
            otpCredentialType = accountInfo.otpCredentialType ?: accountInfo.otpDataType
        )
    }
}