package com.payu.upibolt.network

import android.content.Context
import com.payu.commonmodelssdk.constants.CLConstant
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_API
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_API_ERROR
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_SDK_RESPONSE
import com.payu.commonmodelssdk.listeners.ApiCallbacks
import com.payu.upibolt.utils.AnalyticsUtils
import com.payu.upibolt.utils.InternalConfig

abstract class BaseApiTask(private val context: Context, private val apiName: String): ApiCallbacks {

    protected var startTime: Long = 0

    protected fun logApiSuccessResponseData(response: String) {
        AnalyticsUtils.logEventNameForKibana(
            context,
            "$PAYU_API$apiName",
            response,
            InternalConfig.paymentTxnId ?: InternalConfig.handshakeId,
            refType = PAYU_SDK_RESPONSE,
            status = CLConstant.PAYU_EVENT_SUCCESS,
            timeDiff = System.currentTimeMillis()-startTime,
            eventType = AnalyticsUtils.EventType.Info
        )
    }

    protected fun logApiFailureResponseData(errorCode: Int, errorMessage: String) {
        AnalyticsUtils.logEventNameForKibana(
            context,
            "$PAYU_API$apiName",
            errorMessage,
            InternalConfig.paymentTxnId ?: InternalConfig.handshakeId,
            refType = PAYU_API_ERROR,
            code = errorCode.toString(),
            status = CLConstant.PAYU_EVENT_FAILURE,
            timeDiff = System.currentTimeMillis()-startTime,
            eventType = AnalyticsUtils.EventType.Error,
            eventSeverity = AnalyticsUtils.EventSeverity.High
        )
    }
}