package com.payu.upibolt.network

import android.content.Context
import android.os.Handler
import android.os.Looper
import com.payu.commonmodelssdk.constants.ApiConstant.PAYU_POST
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_VERIFY_PAYMENT
import com.payu.commonmodelssdk.constants.PayUUpiConstant
import com.payu.commonmodelssdk.listeners.ApiBaseCallback
import com.payu.commonmodelssdk.listeners.ApiCallbacks
import com.payu.commonmodelssdk.listeners.PayUAsyncTaskResponse
import com.payu.commonmodelssdk.model.PayUNetworkData
import com.payu.commonmodelssdk.model.request.VerifyApiRequest
import com.payu.upibolt.utils.UpiAuthHeaderHelper
import com.payu.upibolt.utils.Utils
import org.json.JSONObject

/**
 * class to call  Verify api
 * */

internal class VerifyPaymentTask(private val context: Context) : ApiCallbacks {

    override fun callApi(
        params: Any,
        isProd: Boolean,
        callback: ApiBaseCallback
    ) {

        val verifyApiRequest = params as VerifyApiRequest
        if (verifyApiRequest.verifyPaymentHash.isNullOrEmpty().not()) {
            val url = if (isProd)
                PayUUpiConstant.PAYU_VERIFY_PAYMENT_URL
            else
                PayUUpiConstant.PAYU_VERIFY_UAT_PAYMENT_URL
            val headerMap =
                UpiAuthHeaderHelper.getAuthHeader(
                    verifyApiRequest.verifyPaymentHash!!, verifyApiRequest.merchantKey!!
                )
            headerMap["content-type"] = PayUUpiConstant.APPLICATION_JSON
            val networkData = PayUNetworkData(
                url,
                postRequest = Utils.generateVerifyPaymentPostData(verifyApiRequest.txnId),
                headerMap = headerMap,
                contentType = PayUUpiConstant.APPLICATION_JSON
            )
            HttpApiCall(context).makePostAPICall(
                PAYU_VERIFY_PAYMENT,
                PAYU_POST,
                networkData,
                object : PayUAsyncTaskResponse {
                    override fun onSuccess(response: Any) {
                        val handler = Handler(Looper.getMainLooper())
                            val runnable = Runnable {
                                val jsonObject = JSONObject(response as String)
                                val txnDetail =  jsonObject.optJSONArray("result")
                                txnDetail?.let {
                                    val result = it.getJSONObject(0)
                                    callback.onApiSuccess(result.toString())
                                }
                            }
                            handler.post(runnable)
                    }

                    override fun onFailure(errorCode: Int, errorMessage: String) {
                        val handler = Handler(Looper.getMainLooper())
                        val runnable = Runnable {
                            callback.onApiError(errorCode, errorMessage)
                        }
                        handler.post(runnable)
                    }

                }, PayUUpiConstant.VERIFY_STATUS_API_TIMEOUT
            )
        }

    }

}