package com.payu.upibolt.payUHDFCImpl

import androidx.fragment.app.FragmentActivity
import com.payu.commonmodelssdk.listeners.PayUUPIBoltCallBack
import android.os.Build
import com.payu.commonmodelssdk.constants.PayUResponseCodes
import com.payu.commonmodelssdk.constants.PayUResponseMessages
import com.payu.commonmodelssdk.constants.PayUResponseTypes
import com.payu.commonmodelssdk.constants.PayUResponseTypes.CHECK_DEVICE_BINDING_STATUS
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_ACCOUNT_MOBILE_REG
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_GET_ACCOUNT_REMOVE_V3
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_GET_CHANGE_MPIN
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_GET_CUSTOMER_deregister_V3
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_GET_RAISE_QUERY_V3
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_GET_TRANSACTION_HISTORY_V3
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_LIST_BANKS
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_LIST_QUERIES_V3
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_QUERY_TYPE_LIST
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_SAVE_ACCOUNT_V3
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_SDK_HANDSHAKE
import com.payu.commonmodelssdk.constants.PayUUpiConstant
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_CHECK_BALANCE
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_CHECK_DEVICE_STATUS
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_DEREGISTER_ACCOUNTS
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_FETCH_ACCOUNTS_IIN
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_LINKED_ACCOUNTS
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_REMOVE_ACCOUNT
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_REQUEST_GET_CHANGE_MPIN
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_REQUEST_LIST_BANKS
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_REQUEST_QUERY_LIST
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_REQUEST_RAISE_QUERY
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_REQUEST_SET_VPA
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_REQUEST_TXN_HISTORY
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_SET_MPIN
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_VPA
import com.payu.commonmodelssdk.listeners.OTPVerificationInterface
import com.payu.commonmodelssdk.model.request.PayUUPIBoltPaymentParams
import com.payu.commonmodelssdk.model.response.PayUAccountDetail
import com.payu.commonmodelssdk.model.response.PayUUPIBoltResponse
import com.payu.upibolt.listeners.PluginInterface
import com.payu.upibolt.listeners.UpiInitiateCallback
import com.payu.upibolt.utils.InternalConfig
import com.payu.upibolt.utils.Utils
import com.payu.upiboltcore.PayUUPIPlugin
import org.json.JSONObject

internal class HDFCPluginImpl(
    activity: FragmentActivity
): PluginInterface, PayUHDFCPluginManager(activity) {

    override fun checkDeviceBinding(
        mobileNo: String,
        subscriptionId: String,
        callback: PayUUPIBoltCallBack
    ) {
        logPayUFunctionsRequest(
            CHECK_DEVICE_BINDING_STATUS,
            prepareCheckDeviceRequestJson(subscriptionId, mobileNo).toString()
        )
        val startTime = System.currentTimeMillis()
        val payUUPIResponse = super.checkDeviceStatus(mobileNo, subscriptionId)
        val timeDiff = Utils.getTimeDifferenceInMilliSeconds(startTime)
        if (payUUPIResponse.code == PayUResponseCodes.PAYU_SUCCESS_STATUS) {
            logSuccessResponse(
                PayUUpiConstant.PAYU_CHECK_DEVICE_BINDING_STATUS,
                payUUPIResponse.message ?: PayUUpiConstant.PAYU_EVENT_SUCCESS,
                timeDiff,
                referenceId = referenceId
            )
            callback.onPayUSuccess(payUUPIResponse)
        } else {
            logFailureResponse(
                PayUUpiConstant.PAYU_CHECK_DEVICE_BINDING_STATUS,
                payUUPIResponse.code,
                payUUPIResponse.message ?: PayUUpiConstant.PAYU_EVENT_FAILURE,
                timeDiff,
                referenceId = referenceId
            )
            callback.onPayUFailure(payUUPIResponse)
        }
    }

    override fun checkDeviceStatus(
        subscriptionId: String,
        phone: String,
        otpVerificationInterface: OTPVerificationInterface?,
        callback: PayUUPIBoltCallBack
    ) {
        ifPluginCoreDependencyExist(PayUResponseTypes.REQUEST_SDK_HANDSHAKE, callback) {
            val startTime = System.currentTimeMillis()
            logPayUFunctionsRequest(
                REQUEST_SDK_HANDSHAKE,
                prepareSdkInitParamJson().toString(),
                referenceId = referenceId
            )
            payuStartTimeMap[PAYU_CHECK_DEVICE_STATUS] = startTime
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                InternalConfig.mobile = phone
                InternalConfig.subscriptionId = subscriptionId
                initiateWrapperSDK(object : UpiInitiateCallback {
                    override fun onSDKSuccess() {
                        val finalResponse = PayUUPIBoltResponse(
                            PayUResponseTypes.REQUEST_SDK_HANDSHAKE,
                            PayUResponseCodes.PAYU_SUCCESS_STATUS,
                            null
                        )
                        callback.onPayUSuccess(finalResponse)
                    }

                    override fun onSdKError(errorCode: Int, errorMessage: String?) {
                        val finalResponse = PayUUPIBoltResponse(
                            PayUResponseTypes.REQUEST_SDK_HANDSHAKE,
                            errorCode, errorMessage
                        )
                        callback.onPayUFailure(finalResponse)
                    }
                }, otpVerificationInterface, InternalConfig.config?.apiFailureCallback)
            } else {
                val finalResponse = PayUUPIBoltResponse(
                    PayUResponseTypes.REQUEST_SDK_HANDSHAKE,
                    PayUResponseCodes.PAYU_HANDSHAKE_FAILED,
                    PayUResponseMessages.PAYU_HANDSHAKE_FAILED_MESSAGE
                )
                val timeDiff = Utils.getTimeDifferenceInMilliSeconds(startTime)
                logFailureResponse(
                    PAYU_CHECK_DEVICE_STATUS,
                    finalResponse.code,
                    finalResponse.message ?: "",
                    timeDiff,
                    referenceId = referenceId
                )
                callback.onPayUFailure(finalResponse)
            }
        }
    }

    override fun fetchBankList(callback: PayUUPIBoltCallBack) {
        ifPluginCoreDependencyExist(PayUResponseTypes.REQUEST_LIST_BANKS, callback) {
            logPayUFunctionsRequest(REQUEST_LIST_BANKS,"", referenceId = referenceId)
            val startTime = System.currentTimeMillis()
            payuStartTimeMap[PAYU_REQUEST_LIST_BANKS] = startTime
            validateSDKSession(PayUResponseTypes.REQUEST_LIST_BANKS, object : UpiInitiateCallback{
                override fun onSDKSuccess() {
                    callBack[PayUResponseTypes.REQUEST_LIST_BANKS] = callback
                    PayUUPIPlugin.getBankList(this@HDFCPluginImpl)
                }

                override fun onSdKError(errorCode: Int, errorMessage: String?) {
                    val timeDiff = Utils.getTimeDifferenceInMilliSeconds(startTime)
                    val response = PayUUPIBoltResponse(
                        REQUEST_LIST_BANKS,
                        errorCode, errorMessage
                    )
                    logFailureResponse(
                        PAYU_REQUEST_LIST_BANKS,
                        errorCode,
                        errorMessage ?: "",
                        timeDiff,
                        referenceId = referenceId
                    )
                    callback.onPayUFailure(response)
                }
            })
        }
    }

    override fun fetchAccountsWithIin(
        iin: String?,
        bankName: String?,
        bankCode: String?,
        vpa: String?,
        requestType: String?,
        isCCTxnEnabled: Boolean,
        bankId: String?,
        callback: PayUUPIBoltCallBack
    ) {
        ifPluginCoreDependencyExist(PayUResponseTypes.REQUEST_FETCH_ACCOUNT_V3, callback) {
            val startTime = System.currentTimeMillis()
            payuStartTimeMap[PAYU_FETCH_ACCOUNTS_IIN] = startTime
            validateSDKSession(PayUResponseTypes.REQUEST_FETCH_ACCOUNT_V3, object: UpiInitiateCallback{
                override fun onSDKSuccess() {
                    val request = prepareJsonFromAccountsInn(
                        bankName, bankCode, iin, vpa, isCCTxnEnabled, requestType
                    )
                    logPayUFunctionsRequest(
                        PayUResponseTypes.REQUEST_FETCH_ACCOUNT_V3,
                        request.toString(),
                        referenceId = referenceId
                    )
                    InternalConfig.bankName = bankName
                    callBack[PayUResponseTypes.REQUEST_FETCH_ACCOUNT_V3] = callback
                    PayUUPIPlugin.getAccountsList(
                        bankCode, requestType, iin, bankId,
                        if (isCCTxnEnabled)
                            PayUUpiConstant.PAYU_ACCOUNT_TYPE_CREDIT
                        else
                            PayUUpiConstant.PAYU_ACCOUNT_TYPE_SAVINGS,
                        this@HDFCPluginImpl
                    )
                }

                override fun onSdKError(errorCode: Int, errorMessage: String?) {
                    val response = PayUUPIBoltResponse(
                        PayUResponseTypes.REQUEST_FETCH_ACCOUNT_V3,
                        errorCode, errorMessage
                    )
                    logFailureResponse(
                        PAYU_FETCH_ACCOUNTS_IIN,
                        errorCode,
                        errorMessage ?: "",
                        Utils.getTimeDifferenceInMilliSeconds(startTime),
                        referenceId = referenceId
                    )
                    callback.onPayUFailure(response)
                }
            })
        }
    }

    override fun fetchLinkedAccounts(callback: PayUUPIBoltCallBack) {
        ifPluginCoreDependencyExist(PayUResponseTypes.REQUEST_ALL_ACCOUNTS_V3, callback) {
            val startTime = System.currentTimeMillis()
            validateSDKSession(
                PayUResponseTypes.REQUEST_ALL_ACCOUNTS_V3,
                object : UpiInitiateCallback {
                    override fun onSDKSuccess() {
                        logPayUFunctionsRequest(
                            PayUResponseTypes.REQUEST_ALL_ACCOUNTS_V3,
                            "",
                            referenceId = referenceId
                        )
                        callBack[PayUResponseTypes.REQUEST_ALL_ACCOUNTS_V3] = callback
                        PayUUPIPlugin.getProfile(this@HDFCPluginImpl)
                    }

                    override fun onSdKError(errorCode: Int, errorMessage: String?) {
                        val response = PayUUPIBoltResponse(
                            PayUResponseTypes.REQUEST_ALL_ACCOUNTS_V3,
                            errorCode, errorMessage
                        )
                        logFailureResponse(
                            PAYU_LINKED_ACCOUNTS,
                            errorCode,
                            errorMessage ?: "",
                            Utils.getTimeDifferenceInMilliSeconds(startTime),
                            referenceId = referenceId
                        )
                        callback.onPayUFailure(response)
                    }
                })
        }
    }

    override fun checkBalance(accountDetail: PayUAccountDetail, callback: PayUUPIBoltCallBack) {
        ifPluginCoreDependencyExist(PayUResponseTypes.REQUEST_GET_BALANCE, callback) {
            validateSDKSession(PayUResponseTypes.REQUEST_GET_BALANCE, object: UpiInitiateCallback {
                override fun onSDKSuccess() {
                    logPayUFunctionsRequest(
                        PayUResponseTypes.REQUEST_GET_BALANCE,
                        prepareJsonFromAccount(accountDetail).toString(),
                        referenceId = referenceId
                    )
                    callBack[PayUResponseTypes.REQUEST_GET_BALANCE] = callback
                    val account = HDFCTransformerUtils.getAccount(accountDetail)
                    if (account.mbeba == PayUUpiConstant.PAYU_VALUE_Y
                        && account.vpa.isNullOrEmpty().not()) {
                        PayUUPIPlugin.checkBalance(account, this@HDFCPluginImpl)
                    } else {
                        val response = PayUUPIBoltResponse(
                            PayUResponseTypes.REQUEST_GET_BALANCE,
                            PayUResponseCodes.PAYU_FAILED_STATUS,
                            if (account.vpa.isNullOrEmpty())
                                PayUResponseMessages.PAYU_UPI_ID_NOT_SET
                            else
                                PayUResponseMessages.PAYU_PIN_NOT_SET
                        )
                        logFailureResponse(
                            PAYU_CHECK_BALANCE,
                            response.code,
                            response.message ?: "",
                            Utils.getTimeDifferenceInMilliSeconds(startTime),
                            referenceId = referenceId
                        )
                        callback.onPayUFailure(response)
                    }
                }

                override fun onSdKError(errorCode: Int, errorMessage: String?) {
                    logFailureResponse(
                        PAYU_CHECK_BALANCE,
                        errorCode,
                        errorMessage ?: "",
                        Utils.getTimeDifferenceInMilliSeconds(startTime),
                        referenceId = referenceId
                    )
                    callback.onPayUFailure(
                        PayUUPIBoltResponse(
                            PayUResponseTypes.REQUEST_GET_BALANCE,
                            errorCode,
                            errorMessage
                        )
                    )
                }
            })
        }
    }

    override fun setMPIN(
        accountDetail: PayUAccountDetail,
        cardNo: String,
        exp: String,
        callback: PayUUPIBoltCallBack
    ) {
        ifPluginCoreDependencyExist(PayUResponseTypes.REQUEST_ACCOUNT_MOBILE_REG, callback) {
            val fnCalledTime = System.currentTimeMillis()
            payuStartTimeMap[PAYU_SET_MPIN] = fnCalledTime
            validateSDKSession(
                PayUResponseTypes.REQUEST_ACCOUNT_MOBILE_REG,
                object : UpiInitiateCallback {
                    override fun onSDKSuccess() {
                        logPayUFunctionsRequest(
                            REQUEST_ACCOUNT_MOBILE_REG,
                            prepareActivatePayuAccountJson(accountDetail, cardNo, exp).toString(),
                            referenceId = referenceId
                        )
                        callBack[PayUResponseTypes.REQUEST_ACCOUNT_MOBILE_REG] = callback
                        PayUUPIPlugin.setMpin(
                            HDFCTransformerUtils.getAccount(accountDetail), cardNo, exp,
                            this@HDFCPluginImpl
                        )
                    }

                    override fun onSdKError(errorCode: Int, errorMessage: String?) {
                        val response = PayUUPIBoltResponse(
                            REQUEST_ACCOUNT_MOBILE_REG, errorCode, errorMessage
                        )
                        logFailureResponse(
                            PAYU_SET_MPIN,
                            errorCode,
                            errorMessage ?: "",
                            Utils.getTimeDifferenceInMilliSeconds(fnCalledTime),
                            referenceId = referenceId
                        )
                        callback.onPayUFailure(response)
                    }
                }
            )
        }
    }

    override fun removeAccount(
        accountDetail: PayUAccountDetail,
        callback: PayUUPIBoltCallBack
    ) {
        ifPluginCoreDependencyExist(PayUResponseTypes.REQUEST_GET_ACCOUNT_REMOVE_V3, callback) {
            val fnCalledTime = System.currentTimeMillis()
            validateSDKSession(PayUResponseTypes.REQUEST_GET_ACCOUNT_REMOVE_V3,
                object : UpiInitiateCallback {
                    override fun onSDKSuccess() {
                        logPayUFunctionsRequest(
                            REQUEST_GET_ACCOUNT_REMOVE_V3,
                            prepareJsonFromAccount(accountDetail).toString(),
                            referenceId = referenceId
                        )
                        callBack[PayUResponseTypes.REQUEST_GET_ACCOUNT_REMOVE_V3] = callback
                        PayUUPIPlugin.removeAccount(
                            HDFCTransformerUtils.getAccount(accountDetail),
                            this@HDFCPluginImpl
                        )
                    }

                    override fun onSdKError(errorCode: Int, errorMessage: String?) {
                        val response = PayUUPIBoltResponse(
                            REQUEST_GET_ACCOUNT_REMOVE_V3, errorCode, errorMessage
                        )
                        logFailureResponse(
                            PAYU_REMOVE_ACCOUNT,
                            errorCode,
                            errorMessage ?: "",
                            Utils.getTimeDifferenceInMilliSeconds(fnCalledTime),
                            referenceId = referenceId
                        )
                        callback.onPayUFailure(response)
                    }
                }
            )
        }
    }

    override fun deregister(callback: PayUUPIBoltCallBack) {
        ifPluginCoreDependencyExist(PayUResponseTypes.REQUEST_GET_CUSTOMER_deregister_V3, callback) {
            val fnCalledTime = System.currentTimeMillis()
            validateSDKSession(PayUResponseTypes.REQUEST_GET_CUSTOMER_deregister_V3,
                object : UpiInitiateCallback {
                    override fun onSDKSuccess() {
                        logPayUFunctionsRequest(
                            REQUEST_GET_CUSTOMER_deregister_V3, "",
                            referenceId = referenceId
                        )
                        callBack[PayUResponseTypes.REQUEST_GET_CUSTOMER_deregister_V3] = callback
                        PayUUPIPlugin.deregisterVpa(this@HDFCPluginImpl)
                    }

                    override fun onSdKError(errorCode: Int, errorMessage: String?) {
                        val response = PayUUPIBoltResponse(
                            REQUEST_GET_CUSTOMER_deregister_V3, errorCode, errorMessage
                        )
                        logFailureResponse(
                            PAYU_DEREGISTER_ACCOUNTS,
                            errorCode,
                            errorMessage ?: "",
                            Utils.getTimeDifferenceInMilliSeconds(fnCalledTime),
                            referenceId = referenceId
                        )
                        callback.onPayUFailure(response)
                    }
                })
        }
    }

    override fun changeMPIN(
        accountDetail: PayUAccountDetail,
        callback: PayUUPIBoltCallBack
    ) {
        ifPluginCoreDependencyExist(PayUResponseTypes.REQUEST_GET_CHANGE_MPIN, callback) {
            val fnCalledTime = System.currentTimeMillis()
            validateSDKSession(
                PayUResponseTypes.REQUEST_GET_CHANGE_MPIN, object : UpiInitiateCallback {
                    override fun onSDKSuccess() {
                        if (accountDetail.mbeba == PayUUpiConstant.PAYU_VALUE_Y
                            && accountDetail.vpa.isNullOrEmpty().not()
                        ) {
                            logPayUFunctionsRequest(
                                REQUEST_GET_CHANGE_MPIN,
                                prepareJsonFromAccount(accountDetail).toString(),
                                referenceId = referenceId
                            )
                            callBack[PayUResponseTypes.REQUEST_GET_CHANGE_MPIN] = callback
                            PayUUPIPlugin.changeMpin(
                                HDFCTransformerUtils.getAccount(accountDetail),
                                callback
                            )
                        } else {
                            val response = PayUUPIBoltResponse(
                                REQUEST_GET_CHANGE_MPIN,
                                PayUResponseCodes.PAYU_FAILED_STATUS,
                                if (accountDetail.vpa.isNullOrEmpty())
                                    PayUResponseMessages.PAYU_UPI_ID_NOT_SET
                                else
                                    PayUResponseMessages.PAYU_PIN_NOT_SET
                            )
                            logFailureResponse(
                                PAYU_REQUEST_GET_CHANGE_MPIN,
                                response.code,
                                response.message ?: "",
                                Utils.getTimeDifferenceInMilliSeconds(fnCalledTime),
                                referenceId = referenceId
                            )
                            callback.onPayUFailure(response)
                        }
                    }

                    override fun onSdKError(errorCode: Int, errorMessage: String?) {
                        val response = PayUUPIBoltResponse(
                            REQUEST_GET_CHANGE_MPIN,
                            errorCode, errorMessage
                        )
                        logFailureResponse(
                            PAYU_REQUEST_GET_CHANGE_MPIN,
                            response.code,
                            response.message ?: "",
                            Utils.getTimeDifferenceInMilliSeconds(fnCalledTime),
                            referenceId = referenceId
                        )
                        callback.onPayUFailure(response)
                    }
                }
            )
        }
    }

    override fun setVPA(
        vpa: String,
        accountDetail: PayUAccountDetail,
        callback: PayUUPIBoltCallBack
    ) {
        ifPluginCoreDependencyExist(PayUResponseTypes.REQUEST_SAVE_ACCOUNT_V3, callback) {
            val fnCalledTime = System.currentTimeMillis()
            validateSDKSession(
                PayUResponseTypes.REQUEST_SAVE_ACCOUNT_V3, object : UpiInitiateCallback {
                    override fun onSDKSuccess() {
                        val jsonObject = prepareJsonFromAccount(accountDetail)
                        jsonObject.put(PAYU_VPA, Utils.getMaskedString(vpa))
                        logPayUFunctionsRequest(
                            PayUResponseTypes.REQUEST_SAVE_ACCOUNT_V3,
                            jsonObject.toString(),
                            referenceId = referenceId
                        )
                        val account = HDFCTransformerUtils.getAccount(accountDetail)
                        callBack[PayUResponseTypes.REQUEST_SAVE_ACCOUNT_V3] = callback
                        PayUUPIPlugin.registerVPA(vpa, account, this@HDFCPluginImpl)
                    }

                    override fun onSdKError(errorCode: Int, errorMessage: String?) {
                        val response = PayUUPIBoltResponse(
                            REQUEST_SAVE_ACCOUNT_V3,
                            errorCode, errorMessage
                        )
                        logFailureResponse(
                            PAYU_REQUEST_SET_VPA,
                            response.code,
                            response.message ?: "",
                            Utils.getTimeDifferenceInMilliSeconds(fnCalledTime),
                            referenceId = referenceId
                        )
                        callback.onPayUFailure(response)
                    }
                }
            )
        }
    }

    override fun fetchVPAProfile(vpa: String, callback: PayUUPIBoltCallBack) {
        callback.onPayUFailure(
            PayUUPIBoltResponse(
                PayUResponseTypes.REQUEST_GET_PROFilE_VPA_V3,
                PayUResponseCodes.PAYU_FAILED_STATUS, PayUResponseMessages.PAYU_METHOD_NOT_SUPPORTED
            )
        )
    }

    override fun saveVPA(
        vpa: String,
        name: String,
        nickName: String,
        callback: PayUUPIBoltCallBack
    ) {
        callback.onPayUFailure(
            PayUUPIBoltResponse(
                PayUResponseTypes.REQUEST_SAVE_VPA_V3,
                PayUResponseCodes.PAYU_FAILED_STATUS, PayUResponseMessages.PAYU_METHOD_NOT_SUPPORTED
            )
        )
    }

    override fun deleteVPA(vpa: String, callback: PayUUPIBoltCallBack) {
        callback.onPayUFailure(
            PayUUPIBoltResponse(
                PayUResponseTypes.REQUEST_GET_VPA_REMOVE_V3,
                PayUResponseCodes.PAYU_FAILED_STATUS, PayUResponseMessages.PAYU_METHOD_NOT_SUPPORTED
            )
        )
    }

    override fun fetchRegisteredVPAList(callback: PayUUPIBoltCallBack) {
        callback.onPayUFailure(
            PayUUPIBoltResponse(
                PayUResponseTypes.REQUEST_GET_VPA_V3,
                PayUResponseCodes.PAYU_FAILED_STATUS, PayUResponseMessages.PAYU_METHOD_NOT_SUPPORTED
            )
        )
    }

    override fun pay(
        paymentParams: PayUUPIBoltPaymentParams,
        callback: PayUUPIBoltCallBack
    ) {
        ifPluginCoreDependencyExist(PayUResponseTypes.REQUEST_PAY, callback) {
            val fnCalledTime = System.currentTimeMillis()
            validateSDKSession(PayUResponseTypes.REQUEST_PAY, object : UpiInitiateCallback {
                override fun onSDKSuccess() {
                    callBack[PayUResponseTypes.REQUEST_PAY] = callback
                    initPayment(paymentParams, this@HDFCPluginImpl, fnCalledTime)
                }

                override fun onSdKError(errorCode: Int, errorMessage: String?) {
                    val response = PayUUPIBoltResponse(
                        PayUResponseTypes.REQUEST_PAY,
                        errorCode, errorMessage
                    )
                    logFailureResponse(
                        PayUUpiConstant.PAYU_REQUEST_PAY,
                        response.code,
                        response.message ?: "",
                        Utils.getTimeDifferenceInMilliSeconds(fnCalledTime),
                        paymentParams.txnId,
                        referenceId = referenceId,
                        amount = paymentParams.amount
                    )
                    callback.onPayUFailure(response)
                }
            })
        }
    }


    override fun raiseQuery(
        txnId: String,
        txnRefId: String?,
        amount: Double,
        query: String,
        queryType: String?,
        callback: PayUUPIBoltCallBack
    ) {
        ifPluginCoreDependencyExist(PayUResponseTypes.REQUEST_GET_RAISE_QUERY_V3, callback) {
            val fnCalledTime = System.currentTimeMillis()
            validateSDKSession(
                PayUResponseTypes.REQUEST_GET_RAISE_QUERY_V3,
                object : UpiInitiateCallback {
                    override fun onSDKSuccess() {
                        logPayUFunctionsRequest(
                            REQUEST_GET_RAISE_QUERY_V3,
                            prepareQueryRequestJson(
                                txnId, txnRefId ?: "", amount, query
                            ).toString(),
                            referenceId = referenceId
                        )
                        callBack[PayUResponseTypes.REQUEST_GET_RAISE_QUERY_V3] = callback
                        PayUUPIPlugin.raiseDispute(
                            txnId, txnRefId, query, queryType, this@HDFCPluginImpl
                        )
                    }

                    override fun onSdKError(errorCode: Int, errorMessage: String?) {
                        val response = PayUUPIBoltResponse(
                            REQUEST_GET_RAISE_QUERY_V3, errorCode, errorMessage
                        )
                        logFailureResponse(
                            PAYU_REQUEST_RAISE_QUERY,
                            response.code,
                            response.message ?: "",
                            Utils.getTimeDifferenceInMilliSeconds(fnCalledTime),
                            referenceId = referenceId,
                        )
                        callback.onPayUFailure(response)
                    }
                }
            )
        }
    }

    override fun fetchQueryList(callback: PayUUPIBoltCallBack) {
        ifPluginCoreDependencyExist(
            PayUResponseTypes.REQUEST_LIST_QUERIES_V3, callback) {
            val fnCalledTime = System.currentTimeMillis()
            validateSDKSession(
                PayUResponseTypes.REQUEST_LIST_QUERIES_V3, object : UpiInitiateCallback {
                    override fun onSDKSuccess() {
                        logPayUFunctionsRequest(
                            REQUEST_LIST_QUERIES_V3, "", referenceId = referenceId
                        )
                        callBack[PayUResponseTypes.REQUEST_LIST_QUERIES_V3] = callback
                        PayUUPIPlugin.getDisputeList(this@HDFCPluginImpl)
                    }

                    override fun onSdKError(errorCode: Int, errorMessage: String?) {
                        val response = PayUUPIBoltResponse(
                            REQUEST_LIST_QUERIES_V3,
                            errorCode, errorMessage
                        )
                        logFailureResponse(
                            PAYU_REQUEST_QUERY_LIST,
                            response.code,
                            response.message ?: "",
                            Utils.getTimeDifferenceInMilliSeconds(fnCalledTime),
                            referenceId = referenceId
                        )
                        callback.onPayUFailure(response)
                    }
                }
            )
        }
    }

    override fun fetchQueryTypeList(txnRefId: String?, callback: PayUUPIBoltCallBack) {
        ifPluginCoreDependencyExist(PayUResponseTypes.REQUEST_QUERY_TYPE_LIST, callback) {
            val fnCalledTime = System.currentTimeMillis()
            validateSDKSession(
                PayUResponseTypes.REQUEST_QUERY_TYPE_LIST,
                object : UpiInitiateCallback {
                    override fun onSDKSuccess() {
                        txnRefId?.let {
                            val jsonObject = JSONObject()
                            jsonObject.put(PayUUpiConstant.PAYU_TXN_REF_ID, it)
                            logPayUFunctionsRequest(
                                REQUEST_QUERY_TYPE_LIST,
                                jsonObject.toString(),
                                referenceId = referenceId
                            )
                            callBack[PayUResponseTypes.REQUEST_QUERY_TYPE_LIST] = callback
                            PayUUPIPlugin.getDisputeTypeList(txnRefId, this@HDFCPluginImpl)
                        } ?: run {
                            callback.onPayUSuccess(
                                PayUUPIBoltResponse(
                                    PayUResponseTypes.REQUEST_QUERY_TYPE_LIST,
                                    PayUResponseCodes.PAYU_SUCCESS_STATUS,
                                    null, null
                                )
                            )
                        }
                    }

                    override fun onSdKError(errorCode: Int, errorMessage: String?) {
                        val response = PayUUPIBoltResponse(
                            PayUResponseTypes.REQUEST_QUERY_TYPE_LIST,
                            errorCode, errorMessage
                    )
                    logFailureResponse(
                        PayUUpiConstant.PAYU_REQUEST_QUERY_TYPE_LIST,
                        response.code,
                        response.message ?: "",
                        Utils.getTimeDifferenceInMilliSeconds(fnCalledTime),
                        referenceId = referenceId
                    )
                    callback.onPayUFailure(response)
                }
            })
        }
    }

    override fun fetchTransactionHistory(
        fromDate: String,
        toDate: String,
        callback: PayUUPIBoltCallBack
    ) {
        ifPluginCoreDependencyExist(
            PayUResponseTypes.REQUEST_GET_TRANSACTION_HISTORY_V3, callback) {
            val fnCalledTime = System.currentTimeMillis()
            validateSDKSession(
                PayUResponseTypes.REQUEST_GET_TRANSACTION_HISTORY_V3,
                object : UpiInitiateCallback {
                    override fun onSDKSuccess() {
                        logPayUFunctionsRequest(
                            REQUEST_GET_TRANSACTION_HISTORY_V3,
                            txnHistoryRequestJson(fromDate, toDate).toString(),
                            referenceId = referenceId
                        )
                        callBack[PayUResponseTypes.REQUEST_GET_TRANSACTION_HISTORY_V3] = callback
                        PayUUPIPlugin.getTransactionHistoryList(
                            fromDate, toDate, this@HDFCPluginImpl
                        )
                    }

                    override fun onSdKError(errorCode: Int, errorMessage: String?) {
                        val response = PayUUPIBoltResponse(
                            REQUEST_GET_TRANSACTION_HISTORY_V3,
                            errorCode, errorMessage
                        )
                        logFailureResponse(
                            PAYU_REQUEST_TXN_HISTORY,
                            response.code,
                            response.message ?: "",
                            Utils.getTimeDifferenceInMilliSeconds(fnCalledTime),
                            referenceId = referenceId
                        )
                        callback.onPayUFailure(response)
                    }
                }
            )
        }
    }

    override fun addAccount(accountDetail: PayUAccountDetail, callback: PayUUPIBoltCallBack) {
        ifPluginCoreDependencyExist(
            PayUResponseTypes.REQUEST_ADD_ACCOUNT, callback) {
            val fnCalledTime = System.currentTimeMillis()
            validateSDKSession(PayUResponseTypes.REQUEST_ADD_ACCOUNT, object : UpiInitiateCallback {
                override fun onSDKSuccess() {
                    val jsonObject = prepareJsonFromAccount(accountDetail)
                    logPayUFunctionsRequest(
                        PayUResponseTypes.REQUEST_ADD_ACCOUNT,
                        jsonObject.toString(),
                        referenceId = referenceId
                    )
                    callBack[PayUResponseTypes.REQUEST_ADD_ACCOUNT] = callback
                    val account = HDFCTransformerUtils.getAccount(accountDetail)
                    PayUUPIPlugin.addAccount(account, this@HDFCPluginImpl)
                }

                override fun onSdKError(errorCode: Int, errorMessage: String?) {
                    val response = PayUUPIBoltResponse(
                        PayUResponseTypes.REQUEST_ADD_ACCOUNT,
                        errorCode, errorMessage
                    )
                    logFailureResponse(
                        PayUUpiConstant.PAYU_REQUEST_ADD_ACCOUNT,
                        response.code,
                        response.message ?: "",
                        Utils.getTimeDifferenceInMilliSeconds(fnCalledTime),
                        referenceId = referenceId
                    )
                    callback.onPayUFailure(response)
                }
            })
        }
    }

    override fun hasPermissions() = hasSmsAndPhonePermissions()

    override fun clearCache() {
        callBack.clear()
        upiInitiateCallback = null
        InternalConfig.activeApiCalls.forEach {
            if(it?.request()?.tag() != PayUUpiConstant.PAYU_CANCEL_TXN) {
                it?.cancel()
            }
        }
        PayUUPIPlugin.clearCache()
    }

    override fun clearData() {
        clearCache()
        clearSDKData()
    }

    override fun checkDisputeStatus(txnId: String, callback: PayUUPIBoltCallBack) {
        ifPluginCoreDependencyExist(
            PayUResponseTypes.REQUEST_CHECK_DISPUTE_STATUS, callback) {
            val fnCalledTime = System.currentTimeMillis()
            validateSDKSession(
                PayUResponseTypes.REQUEST_CHECK_DISPUTE_STATUS,
                object : UpiInitiateCallback {
                    override fun onSDKSuccess() {
                        val jsonObject = JSONObject()
                        jsonObject.put(PayUUpiConstant.PAYU_TXN_ID, txnId)
                        logPayUFunctionsRequest(
                            PayUResponseTypes.REQUEST_CHECK_DISPUTE_STATUS,
                            jsonObject.toString(),
                            referenceId = referenceId
                        )
                        callBack[PayUResponseTypes.REQUEST_CHECK_DISPUTE_STATUS] = callback
                        PayUUPIPlugin.checkDisputeStatus(txnId, this@HDFCPluginImpl)
                    }

                    override fun onSdKError(errorCode: Int, errorMessage: String?) {
                        val response = PayUUPIBoltResponse(
                            PayUResponseTypes.REQUEST_CHECK_DISPUTE_STATUS,
                            errorCode, errorMessage
                        )
                        logFailureResponse(
                            PayUUpiConstant.PAYU_REQUEST_CHECK_STATUS,
                            response.code,
                            response.message ?: "",
                            Utils.getTimeDifferenceInMilliSeconds(fnCalledTime),
                            referenceId = referenceId
                        )
                        callback.onPayUFailure(response)
                    }
                }
            )
        }
    }
}