package com.payu.upibolt.utils

import com.payu.commonmodelssdk.PostDataManager
import com.payu.commonmodelssdk.constants.PayUUpiConstant
import com.payu.commonmodelssdk.enums.UpiHashCommand
import com.payu.commonmodelssdk.model.request.PayUUPIParams


class ApiServicesUtils {

    /**
     * class to generatePostData for _payment
     * */
    fun generatePostData(
        hash: String,
        hashCommand: UpiHashCommand,
        request: PayUUPIParams
        ): com.payu.commonmodelssdk.model.PostData? {
        request.hash = hash
        return when (hashCommand) {
            UpiHashCommand.PaymentHash ->
                PostDataManager.getPaymentPOstParams(request, PayUUpiConstant.PG_DETAIL_TYPE_IN_APP)
            else -> {
                null
            }
        }
    }

}