package com.payu.upibolt.payUHDFCImpl

import com.payu.commonmodelssdk.model.response.PayUAccountDetail
import com.payu.commonmodelssdk.model.response.PayUCustomerBankAccounts
import com.payu.upibolt.utils.InternalConfig
import com.payu.upiboltcore.models.AccountInfo
import java.util.*

internal object HDFCTransformerUtils {


    internal fun prepareAccountData(accountDataList: ArrayList<AccountInfo>): ArrayList<PayUCustomerBankAccounts> {
        val accountList = ArrayList<PayUCustomerBankAccounts>()
        for (accountData: AccountInfo in accountDataList) {
            val payuAccountData = getPayUAccountData(accountData)
            val customerBankAccounts = PayUCustomerBankAccounts(
                accountData.bankName ?: "", accountData.bankCode ?: "", payuAccountData
            )
            accountList.add(customerBankAccounts)
        }
        return accountList
    }

    private fun getPayUAccountData(accountData: AccountInfo): PayUAccountDetail {
        return PayUAccountDetail(
            accountData.accountName,
            accountData.accountId,
            accountData.ifscCode,
            accountData.accountNumber,
            accountData.accountType,
            accountData.vpa,
            accountData.iin,
            "",
            accountData.aeba,
            accountData.mbeba,
            accountData.credentialLength,
            accountData.credentialType,
            accountData.accountBalance,
            "",
            "",
            formatType = accountData.formatType,
            atmdLength = accountData.atmPinLength,
            bankName = accountData.bankName,
            otpdLength = accountData.otpLength,
            otpdType = accountData.otpDataType,
            aepsFlag = accountData.aepsFlag,
            bankCode = accountData.bankCode,
            bankId = accountData.bankId,
            refUrl = accountData.refUrl
        )
    }

    fun getAccount(accountData: PayUAccountDetail): AccountInfo {
        return AccountInfo(
            accountData.accRefNumber,
            accountData.name,
            accountData.maskedAccnumber,
            accountData.type,
            accountData.aeba,
            accountData.aepsFlag,
            accountData.atmdLength ?: "0",
            accountData.bankCode,
            accountData.bankId,
            if(accountData.bankName.isNullOrEmpty()) InternalConfig.bankName else accountData.bankName,
            accountData.dLength.toString(),
            accountData.dType,
            accountData.formatType,
            accountData.ifsc,
            mbeba = accountData.mbeba,
            otpDataType = accountData.otpdType,
            otpLength = accountData.otpdLength ?: "0",
            iin = accountData.iin,
            vpa = accountData.vpa,
            refUrl = accountData.refUrl
        )
    }

}