package com.payu.upibolt.utils

import com.payu.commonmodelssdk.constants.PayUUpiConstant
import com.payu.commonmodelssdk.constants.PayUUpiConstant.AUTHORIZATION
import com.payu.commonmodelssdk.constants.PayUUpiConstant.AUTH_HEADER_PARAM_1
import com.payu.commonmodelssdk.constants.PayUUpiConstant.AUTH_HEADER_PARAM_2
import com.payu.commonmodelssdk.constants.PayUUpiConstant.DATE
import com.payu.commonmodelssdk.constants.PayUUpiConstant.V2_API_TIME_FORMATE
import com.payu.commonmodelssdk.enums.UpiHashCommand
import com.payu.commonmodelssdk.model.request.PayUUPIBoltPaymentParams
import java.text.SimpleDateFormat
import java.util.*
import kotlin.collections.HashMap

object UpiAuthHeaderHelper : PayUUPIBoltHashStringHelper() {
    private var date: String? = null

    fun getUPIHashString(
        command: UpiHashCommand?,
        paymentParams: PayUUPIBoltPaymentParams? = null,
        merchantKey: String,
        email: String? = null,
        requestJson: String? = null,
        txnId: String? = null
    ): HashMap<String, String> {
        val hashStringMap = HashMap<String, String>()
        return when (command) {
            UpiHashCommand.PaymentHash -> {
                super.getHashString(UpiHashCommand.PaymentHash, paymentParams, merchantKey, email).apply {
                    this[PayUUpiConstant.PAYU_HASH_TYPE] = PayUUpiConstant.PAYU_HASH_TYPE_SHA_512
                }
            }

            UpiHashCommand.PgDetails,UpiHashCommand.HDFCAuthToken, UpiHashCommand.VerifyPayment ->{
                val hashString = generateSigningString(requestJson ?: "")
                hashStringMap[PayUUpiConstant.HASH_STRING] = hashString
                hashStringMap[PayUUpiConstant.HASH_NAME] = command.hashName
                hashStringMap[PayUUpiConstant.PAYU_HASH_TYPE] = PayUUpiConstant.PAYU_HASH_TYPE_SHA_512
                hashStringMap
            }

            else -> hashStringMap
        }
    }

    private fun generateSigningString(jsonString: String): String {
        val myDate = Date()

        val calendar = Calendar.getInstance()
        calendar.timeZone = TimeZone.getTimeZone("UTC")
        calendar.time = myDate
        calendar.add(Calendar.MINUTE, -330)
        val time = calendar.time
        val outputFmt = SimpleDateFormat(V2_API_TIME_FORMATE, Locale.getDefault())

        date = outputFmt.format(time)

        val dateString = date!!.subSequence(1,date!!.length-1).toString()
        return StringBuilder()
            .append(jsonString).append("|")
            .append(dateString).append("|")
            .toString()
    }

    fun getAuthHeader(signature: String, key: String): HashMap<String, String> {
        val headerMap = HashMap<String, String>()
        headerMap[DATE] = date!!.subSequence(1,date!!.length-1).toString()
        val authHeader = java.lang.StringBuilder()
            .append(AUTH_HEADER_PARAM_1)
            .append(key)
            .append(AUTH_HEADER_PARAM_2)
            .append(signature)
            .append("\"").toString()
        headerMap[AUTHORIZATION] = authHeader
        return headerMap
    }
}

