package com.payu.upibolt.listeners

import com.payu.commonmodelssdk.listeners.OTPVerificationInterface
import com.payu.commonmodelssdk.listeners.PayUUPIBoltCallBack
import com.payu.commonmodelssdk.model.request.PayUUPIBoltPaymentParams
import com.payu.commonmodelssdk.model.response.PayUAccountDetail

/**
 * PluginInterface class which is open to merchant for method calling
 * */

interface PluginInterface {

    fun isUpiBoltEnabled(callback: PayUUPIBoltCallBack)
    fun getSubscriberInfo(mobile: String, callback: PayUUPIBoltCallBack)
    fun checkDeviceBinding(mobileNo: String, subscriptionId: String, callback: PayUUPIBoltCallBack)
    fun checkDeviceStatus(
        subscriptionId: String, phone: String,
        otpVerificationInterface: OTPVerificationInterface? = null, callback: PayUUPIBoltCallBack
    )

    fun fetchBankList(callback: PayUUPIBoltCallBack)
    fun getRegisteredMobile(): String?

    fun fetchAccountsWithIin(
        iin: String?, bankName: String?, bankCode: String? = null,
        vpa: String? = null, requestType: String? = null, isCCTxnEnabled: Boolean = false,
        bankId: String?, callback: PayUUPIBoltCallBack
    )

    fun fetchLinkedAccounts(callback: PayUUPIBoltCallBack)
    fun checkBalance(accountDetail: PayUAccountDetail, callback: PayUUPIBoltCallBack)
    fun setMPIN(accountDetail: PayUAccountDetail, cardNo: String, exp: String, callback: PayUUPIBoltCallBack)
    fun removeAccount(accountDetail: PayUAccountDetail, callback: PayUUPIBoltCallBack)
    fun deregister(callback: PayUUPIBoltCallBack)
    fun changeMPIN(accountDetail: PayUAccountDetail, callback: PayUUPIBoltCallBack)
    fun setVPA(vpa: String, accountDetail: PayUAccountDetail, callback: PayUUPIBoltCallBack)
    fun fetchVPAProfile(vpa: String, callback: PayUUPIBoltCallBack)
    fun saveVPA(vpa: String, name: String, nickName: String, callback: PayUUPIBoltCallBack)
    fun deleteVPA(vpa: String, callback: PayUUPIBoltCallBack)
    fun fetchRegisteredVPAList(callback: PayUUPIBoltCallBack)
    fun pay(paymentParams: PayUUPIBoltPaymentParams, callback: PayUUPIBoltCallBack)
    fun verifyTransactionStatus(txnId: String, callback: PayUUPIBoltCallBack)
    fun raiseQuery(txnId: String, txnRefId: String?, amount: Double, query: String, queryType: String? = null, callback: PayUUPIBoltCallBack)
    fun fetchQueryList(callback: PayUUPIBoltCallBack)
    fun fetchQueryTypeList(txnRefId: String?, callback: PayUUPIBoltCallBack)
    fun fetchTransactionHistory(fromDate: String, toDate: String, callback: PayUUPIBoltCallBack)
    fun addAccount(accountDetail: PayUAccountDetail, callback: PayUUPIBoltCallBack)
    fun hasPermissions(): Boolean
    fun clearCache()
    fun clearData()
    fun cancelTransaction(callback: PayUUPIBoltCallBack)
    fun checkDisputeStatus(txnId: String, callback: PayUUPIBoltCallBack)
}