package com.payu.upibolt.network

import android.os.Handler
import android.os.Looper
import android.content.Context
import com.payu.commonmodelssdk.constants.ApiConstant.PAYU_POST
import com.payu.commonmodelssdk.constants.PayUUpiConstant
import com.payu.commonmodelssdk.listeners.ApiBaseCallback
import com.payu.commonmodelssdk.listeners.PayUAsyncTaskResponse
import com.payu.commonmodelssdk.model.PayUNetworkData
import com.payu.commonmodelssdk.model.request.CancelApiRequest
import com.payu.upibolt.utils.Utils.generatePostDataForCancelApi


class CancelApiTask(private val context: Context): BaseApiTask(context, PayUUpiConstant.PAYU_CANCEL_TXN) {

    override fun callApi(params: Any, isProd: Boolean, callback: ApiBaseCallback) {
        val cancelApiRequest = params as CancelApiRequest
        val requestData =   PayUNetworkData(
            url = cancelApiRequest.url,
            postRequest = generatePostDataForCancelApi(cancelApiRequest.token),
            contentType = PayUUpiConstant.APPLICATION_FORM_URL_ENCODED
        )

        startTime = System.currentTimeMillis()
        HttpApiCall(context).makePostAPICall(PayUUpiConstant.PAYU_CANCEL_TXN, PAYU_POST, requestData, object :
            PayUAsyncTaskResponse {
            override fun onSuccess(response: Any) {
                logApiSuccessResponseData(response.toString())
                val handler = Handler(Looper.getMainLooper())
                val runnable = Runnable {
                    callback.onApiSuccess(response)
                }
                handler.post(runnable)
            }

            override fun onFailure(errorCode: Int, errorMessage: String) {
                logApiFailureResponseData(errorCode, errorMessage)
                val handler = Handler(Looper.getMainLooper())
                val runnable = Runnable {
                    callback.onApiError(errorCode, errorMessage)
                }
                handler.post(runnable)
            }
        })
    }
}