package com.payu.upibolt.network

import android.os.Handler
import android.os.Looper
import com.payu.commonmodelssdk.constants.ApiConstant
import android.content.Context
import com.payu.commonmodelssdk.constants.ApiConstant.PAYU_POST
import com.payu.commonmodelssdk.constants.PayUResponseCodes
import com.payu.commonmodelssdk.constants.PayUResponseMessages
import com.payu.commonmodelssdk.constants.PayUUpiConstant
import com.payu.commonmodelssdk.listeners.ApiBaseCallback
import com.payu.commonmodelssdk.enums.UpiHashCommand
import com.payu.commonmodelssdk.model.PostData
import com.payu.commonmodelssdk.model.request.PayUUPIParams
import com.payu.upibolt.utils.ApiServicesUtils
import org.json.JSONObject

/**
 * _payment api call task
 * */
internal class InitiatePaymentTask(private val context: Context) : BaseApiTask(context, PayUUpiConstant.PAYU_REQUEST_PAY) {
    override fun callApi(
        params: Any,
        isProd: Boolean,
        callback: ApiBaseCallback
    ) {
        val paymentParams = params as PayUUPIParams
        if (paymentParams.hash.isNullOrEmpty())
            return callback.onApiError(
                PayUResponseCodes.HASH_NOT_RECEIVED_CODE,
                PayUResponseMessages.HASH_NOT_RECEIVED
            )
        val postData =
            ApiServicesUtils().generatePostData(
                paymentParams.hash ?: "",
                UpiHashCommand.PaymentHash,
                params
            )
        if ((postData as PostData).status.equals(
                ApiConstant.PAYMENT_POST_DATA_ERROR,
                ignoreCase = true
            )
        ) {
            return callback.onApiError(postData.code, postData.result ?: "")
        } else {
            val url = if (isProd)
                ApiConstant.PAYU_PROD_PAYMENT_URL
            else
                ApiConstant.PAYU_TEST_PAYMENT_URL
            val postRequest =
                "${postData.result}&${ApiConstant.TXN_S2S_FLOW}=${ApiConstant.TXN_S2S_FLOW_VALUE}"
            val networkData = com.payu.commonmodelssdk.model.PayUNetworkData(url, postRequest)
            HttpApiCall(context).makePostAPICall(PayUUpiConstant.PAYU_REQUEST_PAY, PAYU_POST, networkData, object :
                com.payu.commonmodelssdk.listeners.PayUAsyncTaskResponse {
                override fun onSuccess(response: Any) {
                    try {
                        val json = JSONObject(response as String)
                        val status = json.opt(PayUUpiConstant.RES_PARAM_STATUS)
                        if (status?.toString() == "1") {
                            successCallBack(response)
                        } else {
                            var message = "";
                            message = if (json.has(PayUUpiConstant.RES_PARAM_MESSAGE)) {
                                json.optString(PayUUpiConstant.RES_PARAM_MESSAGE)
                            } else {
                                json.optString(PayUUpiConstant.RES_PARAM_MSG)
                            }

                            errorCallBack(PayUResponseCodes.PAYU_FAILED_STATUS, message)
                        }
                    } catch (ex: Exception) {
                        errorCallBack(PayUResponseCodes.PAYU_FAILED_STATUS, response.toString())
                    }
                }

                override fun onFailure(errorCode: Int, errorMessage: String) {
                    errorCallBack(errorCode, errorMessage)
                }

                private fun errorCallBack(errorCode: Int, errorMessage: String) {
                    logApiFailureResponseData(errorCode, errorMessage)
                    val handler = Handler(Looper.getMainLooper())
                    val runnable = Runnable {
                        callback.onApiError(errorCode, errorMessage)
                    }
                    handler.post(runnable)
                }

                private fun successCallBack(response: String) {
                    logApiSuccessResponseData(response)
                    val handler = Handler(Looper.getMainLooper())
                    val runnable = Runnable {
                        callback.onApiSuccess(response)
                    }
                    handler.post(runnable)
                }

            })
        }
    }

}