package com.payu.upibolt.parser

import com.payu.commonmodelssdk.constants.PayUUpiConstant
import com.payu.commonmodelssdk.enums.PluginType
import com.payu.commonmodelssdk.listeners.ApiFailedCallback
import com.payu.commonmodelssdk.model.request.PayUUPIBoltPaymentParams
import com.payu.commonmodelssdk.model.response.FetchAccountsIInResponse
import com.payu.commonmodelssdk.model.response.PayUAccountDetail
import com.payu.commonmodelssdk.model.response.PayUCustomerBankAccounts
import com.payu.upibolt.models.PayUUPIBoltConfig
import org.json.JSONArray
import org.json.JSONObject

object HybridParamParser {


    fun returnNullErrorOrValue(
        key: String,
        value: String?
    ): String {
        return if (value == null || value == "null") {
            throw Exception("$key cannot be null")
        } else {
            value
        }
    }

    fun parseMapToConfig(map: Map<String, Any>): Pair<String?, PayUUPIBoltConfig?> {
        try {
            val list = ArrayList<PluginType>()
            val pluginTypesValues : ArrayList<String>? = map[HybridConfigKeys.PLUGIN_TYPES] as? ArrayList<String>
            pluginTypesValues?.forEach {
                list.add(PluginType.valueOf(it))
            }
            return Pair(
                null, PayUUPIBoltConfig(
                    merchantKey = returnNullErrorOrValue(HybridConfigKeys.MERCHANT_KEY, map[HybridConfigKeys.MERCHANT_KEY] as? String),
                    email = returnNullErrorOrValue(
                        HybridConfigKeys.EMAIL,
                        map[HybridConfigKeys.EMAIL] as? String
                    ),
                    isProduction = map[HybridConfigKeys.IS_PRODUCTION] as? Boolean ?: true,
                    pluginTypes = list,
                    refId = returnNullErrorOrValue(
                        HybridConfigKeys.REQUEST_ID,
                        map[HybridConfigKeys.REQUEST_ID] as? String
                    ),
                    issuingBanks = map[HybridConfigKeys.ISSUING_BANKS] as? List<String>,
                    apiFailureCallback = map[HybridConfigKeys.API_FAILURE_CALLBACK] as? ApiFailedCallback,
                )
            )
        } catch (e: Exception) {
            return Pair(e.message, null)
        }
    }

    fun getAccountDetail(map: Map<String, Any>): PayUAccountDetail {
        val name = map[PayUUpiConstant.PAYU_NAME] as String
        var accRefNumber = map[PayUUpiConstant.PAYU_ACC_REF_NUMBER] as String
        var ifsc = map[PayUUpiConstant.PAYU_IFSC] as String
        var maskedAccnumber = map[PayUUpiConstant.PAYU_MASKED_ACCNUMBER] as String
        var type = map[PayUUpiConstant.PAYU_TYPE] as String
        var vpa = map[PayUUpiConstant.PAYU_VPA] as String
        var iin = map[PayUUpiConstant.PAYU_IIN] as String
        var mmid = map[PayUUpiConstant.PAYU_MMID] as String
        var aeba = map[PayUUpiConstant.PAYU_AEBA] as String
        var mbeba = map[PayUUpiConstant.PAYU_MBEBA] as String
        var dLength = map[PayUUpiConstant.PAYU_D_LENGTH] as? String
        var dType = map[PayUUpiConstant.PAYU_D_TYPE] as? String
        var balance = map[PayUUpiConstant.PAYU_BALANCE] as? String
        var balTime = map[PayUUpiConstant.PAYU_BAL_TIME] as? String
        var status = map[PayUUpiConstant.PAYU_STATUS] as? String
        var bankCode = map[PayUUpiConstant.PAYU_BANK_CODE] as? String
        var formatType = map[PayUUpiConstant.PAYU_FORMAT_TYPE] as String
        var atmdLength = map[PayUUpiConstant.PAYU_ATM_D_LENGTH] as? String
        var bankName = map[PayUUpiConstant.PAYU_BANK_NAME] as? String
        var otpdType = map[PayUUpiConstant.PAYU_OTP_D_TYPE] as? String
        var otpdLength = map[PayUUpiConstant.PAYU_OTP_D_LENGTH] as? String
        var bankId = map[PayUUpiConstant.PAYU_BANK_ID] as? String
        var aepsFlag = map[PayUUpiConstant.PAYU_AEPS_FLAG] as? String
        var refUrl = map[PayUUpiConstant.PAYU_REF_URL] as? String
        return PayUAccountDetail(name, accRefNumber, ifsc, maskedAccnumber, type, vpa, iin, mmid,
            aeba, mbeba, dLength, dType, balance, balTime, status, bankCode, formatType, atmdLength,
            bankName, otpdType, otpdLength, bankId, aepsFlag, refUrl
        )
    }

    fun getPaymentParams(
        paymentParams: Map<String, Any>,
        accDetailsMap: Map<String, Any>?
    ): PayUUPIBoltPaymentParams {
        val amount = paymentParams[HybridParamsKeys.AMOUNT] as? String
        val tranType = paymentParams[HybridParamsKeys.TRAN_TYPE] as? String
        val refUrl = paymentParams[HybridParamsKeys.REF_URL] as? String
        val txnId = paymentParams[HybridParamsKeys.TRANSACTION_ID] as? String
        val refCategory = paymentParams[HybridParamsKeys.REF_CATEGORY] as? String
        val initMode = paymentParams[HybridParamsKeys.INIT_MODE] as? String
        val purpose = paymentParams[HybridParamsKeys.PURPOSE] as? String
        val productInfo = paymentParams[HybridParamsKeys.PRODUCT_INFO] as? String
        val firstName = paymentParams[HybridParamsKeys.FIRST_NAME] as? String
        val surl = paymentParams[HybridParamsKeys.SURL] as? String
        val furl = paymentParams[HybridParamsKeys.FURL] as? String
        val udf1 = paymentParams[HybridParamsKeys.UDF1] as? String
        val udf2 = paymentParams[HybridParamsKeys.UDF2] as? String
        val udf3 = paymentParams[HybridParamsKeys.UDF3] as? String
        val udf4 = paymentParams[HybridParamsKeys.UDF4] as? String
        val udf5 = paymentParams[HybridParamsKeys.UDF5] as? String
        val userCredentials = paymentParams[HybridParamsKeys.USER_CREDENTIALS] as? String
        val isCCTxnEnabled = paymentParams[HybridParamsKeys.IS_CC_TXN_ENABLED] as? Boolean
        val mcc = paymentParams[HybridParamsKeys.MCC] as? String
        val accountDetail = accDetailsMap?.let {
            getAccountDetail(accDetailsMap)
        }
        return PayUUPIBoltPaymentParams.Builder(
            amount, tranType, refUrl, txnId, refCategory,
            initMode, purpose, productInfo, firstName,
            surl, furl, udf1, udf2, udf3, udf4, udf5,
            userCredentials ?: "", isCCTxnEnabled ?: false,
            accountDetail, mcc
        ).build()
    }
}