package com.payu.upibolt.network

import android.content.Context
import android.os.Handler
import android.os.Looper
import com.payu.commonmodelssdk.constants.ApiConstant.PAYU_APPLICATION_JSON
import com.payu.commonmodelssdk.constants.PayUResponseCodes
import com.payu.commonmodelssdk.constants.PayUResponseMessages
import com.payu.commonmodelssdk.constants.KibanaEvents
import com.payu.commonmodelssdk.constants.PayUUpiConstant
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_UPI
import com.payu.commonmodelssdk.listeners.ApiBaseCallback
import com.payu.commonmodelssdk.listeners.ApiCallbacks
import com.payu.commonmodelssdk.listeners.PayUAsyncTaskResponse
import com.payu.commonmodelssdk.model.PayUNetworkData
import com.payu.commonmodelssdk.model.PgDetails
import com.payu.commonmodelssdk.model.PgDetailsRequest
import com.payu.commonmodelssdk.model.PgDetailsResponseParser.Companion.getPgDetailsResponseFromJSON
import com.payu.upibolt.utils.UpiAuthHeaderHelper
import org.json.JSONObject
import kotlin.collections.HashMap

/**
 * PgDetailsTask class to call pgDetails api to fetch pg details
* */
internal class PgDetailsTask(private val context: Context) :
    BaseApiTask(context, PayUUpiConstant.PAYU_IS_UPI_BOLT_AVAILABLE) {

    override fun callApi(
        params: Any,
        isProd: Boolean,
        callback: ApiBaseCallback
    ) {

        val pgDetailsReq = params as PgDetailsRequest

        pgDetailsReq.hash?.let { hash ->
            val url = if(isProd)
                PayUUpiConstant.PAYU_PG_DETAILS_PROD_URL
            else
                PayUUpiConstant.PAYU_PG_DETAILS_UAT_URL
            val headerMap =
                UpiAuthHeaderHelper.getAuthHeader(
                    hash, pgDetailsReq.merchantKey
                )
            val requestMap = HashMap<String, Any>()
            requestMap[PayUUpiConstant.PAYU_MODE] = PAYU_UPI
            requestMap[PayUUpiConstant.PAYU_PG] = pgDetailsReq.pg.uppercase()
            val networkData = PayUNetworkData(
                url,
                getRequest = requestMap,
                headerMap = headerMap,
                contentType = PAYU_APPLICATION_JSON
            )
            pgDetailsApiCalls(networkData, pgDetailsReq, callback)

        } ?: kotlin.run {
            callback.onApiError(
                PayUResponseCodes.HASH_NOT_RECEIVED_CODE,
                PayUResponseMessages.HASH_NOT_RECEIVED
            )
        }
    }

    private fun pgDetailsApiCalls(
        networkData: PayUNetworkData,
        pgDetailsReq: PgDetailsRequest,
        callback: ApiBaseCallback
    ) {
        HttpApiCall(context).makePostAPICall(
            PayUUpiConstant.PAYU_IS_UPI_BOLT_AVAILABLE,
            PayUUpiConstant.PAYU_GET,
            networkData,
            object :
                PayUAsyncTaskResponse {
                override fun onSuccess(response: Any) {
                    val jsonResponse = JSONObject(response.toString())
                    val pgDetailsResponse = getPgDetailsResponseFromJSON(pgDetailsReq.merchantKey, jsonResponse)
                    val keys = pgDetailsResponse.result.keys
                    if(keys.contains(pgDetailsReq.pg.uppercase())) {
                        val result = pgDetailsResponse.result[pgDetailsReq.pg.uppercase()]
                        result?.pgDetails?.let { resultMap ->
                            val pgDetails = getPgDetails(resultMap)
//                            val pgDetails = PgDetails(
//                                "AXIS", "157", "PAYUCOLLECT", "0823",
//                                "PAYUCOLLECT", pgDetailsReq.merchantKey, BuildConfig.AXIS_SECRET_KEY_UAT,
//                                "axisbank"
//                            )
                            pgDetails?.let {
                                val handler = Handler(Looper.getMainLooper())
                                val runnable = Runnable {
                                    callback.onApiSuccess(it)
                                }
                                handler.post(runnable)
                            } ?: kotlin.run {
                                errorCallBack(
                                    PayUResponseCodes.PAYU_UPI_BOLT_NOT_SUPPORTED_CODE,
                                    PayUResponseMessages.PAYU_UPI_BOLT_NOT_SUPPORTED
                                )
                            }
                        } ?: kotlin.run {
                            errorCallBack(
                                PayUResponseCodes.PAYU_UPI_BOLT_NOT_SUPPORTED_CODE,
                                PayUResponseMessages.PAYU_UPI_BOLT_NOT_SUPPORTED
                            )
                        }
                    }
                }

                override fun onFailure(errorCode: Int, errorMessage: String) {
//                    val res = PgDetails(
//                        "AXIS", "157", "PAYUCOLLECT", "0823",
//                        "PAYUCOLLECT", pgDetailsReq.merchantKey, BuildConfig.AXIS_SECRET_KEY_UAT,
//                        "axisbank"
//                    )
//                    val handler = Handler(Looper.getMainLooper())
//                    val runnable = Runnable {
//                        callback.onApiSuccess(res)
//                    }
//                    handler.post(runnable)
                    errorCallBack(errorCode, errorMessage)
                }

                private fun errorCallBack(errorCode: Int, errorMessage: String) {
                    val handler = Handler(Looper.getMainLooper())
                    val runnable = Runnable {
                        callback.onApiError(errorCode, errorMessage)
                    }
                    handler.post(runnable)
                }
            }
        )
    }

    private fun getPgDetails(resultMap: HashMap<String, PgDetails>): PgDetails? {
        val keys = resultMap.keys
        return if (keys.contains(PayUUpiConstant.PG_DETAIL_TYPE_IN_APP)) {
            resultMap[PayUUpiConstant.PG_DETAIL_TYPE_IN_APP]
        } else if (keys.contains(PayUUpiConstant.PG_DETAIL_TYPE_UPI)) {
            resultMap[PayUUpiConstant.PG_DETAIL_TYPE_UPI]
        } else if (keys.contains(PayUUpiConstant.PG_DETAIL_TYPE_INTENT)) {
            resultMap[PayUUpiConstant.PG_DETAIL_TYPE_INTENT]
        } else {
            resultMap[PayUUpiConstant.PG_DETAIL_TYPE_DEFAULT]
        }
    }

}