package com.payu.upibolt.parser

import com.payu.commonmodelssdk.model.request.PayUUPIBoltPaymentParams
import com.payu.commonmodelssdk.model.response.PayUAccountDetail
import com.payu.upibolt.parser.HybridParamsKeys.ACCOUNT_DETAIL
import com.payu.upibolt.parser.HybridParamsKeys.AMOUNT
import com.payu.upibolt.parser.HybridParamsKeys.FIRST_NAME
import com.payu.upibolt.parser.HybridParamsKeys.FURL
import com.payu.upibolt.parser.HybridParamsKeys.INIT_MODE
import com.payu.upibolt.parser.HybridParamsKeys.IS_CC_TXN_ENABLED
import com.payu.upibolt.parser.HybridParamsKeys.MCC
import com.payu.upibolt.parser.HybridParamsKeys.PRODUCT_INFO
import com.payu.upibolt.parser.HybridParamsKeys.PURPOSE
import com.payu.upibolt.parser.HybridParamsKeys.REF_CATEGORY
import com.payu.upibolt.parser.HybridParamsKeys.REF_URL
import com.payu.upibolt.parser.HybridParamsKeys.SURL
import com.payu.upibolt.parser.HybridParamsKeys.TRANSACTION_ID
import com.payu.upibolt.parser.HybridParamsKeys.TRAN_TYPE
import com.payu.upibolt.parser.HybridParamsKeys.UDF1
import com.payu.upibolt.parser.HybridParamsKeys.UDF2
import com.payu.upibolt.parser.HybridParamsKeys.UDF3
import com.payu.upibolt.parser.HybridParamsKeys.UDF4
import com.payu.upibolt.parser.HybridParamsKeys.UDF5
import com.payu.upibolt.parser.HybridParamsKeys.USER_CREDENTIALS

object HybridParamParser {


    fun returnNullErrorOrValue(
        key: String,
        value: String?
    ): String {
        return if (value == null || value == "null") {
            throw Exception("$key cannot be null")
        } else {
            value
        }
    }

    fun parsePayUUPIBoltPaymentParams(map: Map<String, Any>): Pair<String?, PayUUPIBoltPaymentParams?> {
        try {
            return Pair(
                null, PayUUPIBoltPaymentParams.Builder(
                    amount = returnNullErrorOrValue(AMOUNT, map[AMOUNT] as? String),
                    tranType = map[TRAN_TYPE] as? String,
                    refUrl = map[REF_URL] as? String,
                    txnId = returnNullErrorOrValue(
                        TRANSACTION_ID, map[TRANSACTION_ID] as? String
                    ),
                    refCategory = map[REF_CATEGORY] as? String,
                    initMode = map[INIT_MODE] as? String,
                    purpose = map[PURPOSE] as? String,
                    productInfo = returnNullErrorOrValue(
                        PRODUCT_INFO, map[PRODUCT_INFO] as? String
                    ),
                    firstName = returnNullErrorOrValue(
                        FIRST_NAME, map[FIRST_NAME] as? String
                    ),
                    surl = map[SURL] as? String,
                    furl = map[FURL] as? String,
                    udf1 = returnNullErrorOrValue(
                        UDF1, map[UDF1] as? String
                    ),
                    udf2 = map[UDF2] as? String,
                    udf3 = map[UDF3] as? String,
                    udf4 = map[UDF4] as? String,
                    udf5 = map[UDF5] as? String,
                    userCredentials =
                    map[USER_CREDENTIALS] as? String ?: ""
                    ,
                    isCCTxnEnabled = map[IS_CC_TXN_ENABLED] as? Boolean ?: false,
                    accountDetail = map[ACCOUNT_DETAIL] as? PayUAccountDetail,
                    mcc = map[MCC] as? String ?: ""
                ).build()
            )
        } catch (e: Exception) {
            return Pair(e.message, null)
        }


    }
}