package com.payu.upibolt.payUAxisImpl

import com.olive.upi.transport.model.Account
import com.payu.commonmodelssdk.model.response.PayUCustomerBankAccounts
import com.payu.commonmodelssdk.model.response.PayUAccountDetail
import java.util.ArrayList

internal object AxisTransformerUtils {

    internal fun prepareAccountData(accountDataList: ArrayList<Account>): ArrayList<PayUCustomerBankAccounts> {
        val accountList = ArrayList<PayUCustomerBankAccounts>()
        for (accountData in accountDataList) {
            val payuAccountData = getPayUAccountData(accountData)
            val customerBankAccounts = PayUCustomerBankAccounts(
                accountData.bankName ?: "", accountData.bankName ?: "", payuAccountData
            )
            accountList.add(customerBankAccounts)
        }
        return accountList
    }

    internal fun prepareCustomerAccountList(
        customerBankAccounts: com.olive.upi.transport.model.CustomerBankAccounts,
        custBankList: ArrayList<PayUCustomerBankAccounts>
    ) {
        for (customerBankAccount in customerBankAccounts.accounts) {
            val account = getPayUAccountData(customerBankAccount)
            val customerPayUBankAccount = PayUCustomerBankAccounts(
                customerBankAccounts.bankName, customerBankAccounts.bankCode, account
            )
            custBankList.add(customerPayUBankAccount)
        }
    }

    private fun getPayUAccountData(accountData: Account): PayUAccountDetail {
        return PayUAccountDetail(
            accountData.name,
            accountData.accRefNumber,
            accountData.ifsc,
            accountData.maskedAccnumber,
            accountData.type,
            accountData.vpa,
            accountData.iin,
            accountData.mmid,
            accountData.aeba,
            accountData.mbeba,
            accountData.getdLength().toString(),
            accountData.getdType(),
            accountData.balance,
            accountData.balTime,
            accountData.status,
            formatType = accountData.atmpinFormat,
            atmdLength = accountData.atmpinlength.toString(),
            otpdLength = accountData.otpLength.toString(),
            otpdType = accountData.otpFormat
        )
    }

    fun getAccount(accountData: PayUAccountDetail): Account {
        return Account().apply {
            name = accountData.name
            accRefNumber = accountData.accRefNumber
            ifsc = accountData.ifsc
            maskedAccnumber = accountData.maskedAccnumber
            type = accountData.type
            vpa = accountData.vpa
            iin = accountData.iin
            mmid = accountData.mmid
            aeba = accountData.aeba
            mbeba = accountData.mbeba
            setdLength(accountData.dLength?.toIntOrNull() ?: 0)
            setdType(accountData.dType)
            balance = accountData.balance
            balTime = accountData.balTime
            status = accountData.status
            atmpinFormat = accountData.formatType
            atmpinlength = accountData.atmdLength?.toIntOrNull() ?: 0
            otpLength = accountData.otpdLength?.toIntOrNull() ?: 0
            otpFormat = accountData.otpdType
        }
    }
}