package com.payu.upibolt.parser

import com.payu.commonmodelssdk.enums.PluginType
import com.payu.commonmodelssdk.listeners.ApiFailedCallback
import com.payu.commonmodelssdk.model.request.PayUUPIBoltPaymentParams
import com.payu.commonmodelssdk.model.response.FetchAccountsIInResponse
import com.payu.commonmodelssdk.model.response.PayUAccountDetail
import com.payu.commonmodelssdk.model.response.PayUCustomerBankAccounts
import com.payu.upibolt.models.PayUUPIBoltConfig
import org.json.JSONArray
import org.json.JSONObject

object HybridParamParser {


    fun returnNullErrorOrValue(
        key: String,
        value: String?
    ): String {
        return if (value == null || value == "null") {
            throw Exception("$key cannot be null")
        } else {
            value
        }
    }

    fun parseMapToConfig(map: Map<String, Any>): Pair<String?, PayUUPIBoltConfig?> {
        try {
            val list = ArrayList<PluginType>()
            val pluginTypesValues : ArrayList<String>? = map[HybridConfigKeys.PLUGIN_TYPES] as? ArrayList<String>
            pluginTypesValues?.forEach {
                list.add(PluginType.valueOf(it))
            }
            return Pair(
                null, PayUUPIBoltConfig(
                    merchantKey = returnNullErrorOrValue(HybridConfigKeys.MERCHANT_KEY, map[HybridConfigKeys.MERCHANT_KEY] as? String),
                    email = returnNullErrorOrValue(
                        HybridConfigKeys.EMAIL,
                        map[HybridConfigKeys.EMAIL] as? String
                    ),
                    isProduction = map[HybridConfigKeys.IS_PRODUCTION] as? Boolean ?: true,
                    pluginTypes = list,
                    refId = returnNullErrorOrValue(
                        HybridConfigKeys.REQUEST_ID,
                        map[HybridConfigKeys.REQUEST_ID] as? String
                    ),
                    issuingBanks = map[HybridConfigKeys.ISSUING_BANKS] as? List<String>,
                    apiFailureCallback = map[HybridConfigKeys.API_FAILURE_CALLBACK] as? ApiFailedCallback,
                )
            )
        } catch (e: Exception) {
            return Pair(e.message, null)
        }
    }

    fun parseListToJsonString(list: List<Any>): String {
        return JSONArray().apply {
            list.forEach { item ->
                put(
                    JSONObject().apply {
                        item.javaClass.fields.forEach { field ->
                            put(field.name, field.get(field))
                        }
                    }
                )
            }
        }.toString()
    }

    fun parseToJsonString(data: Any): String {
        return JSONObject().apply {
            data.javaClass.fields.forEach { field ->
                put(field.name, field.get(field))
            }
        }.toString()
    }

    fun getAccountDetail(map: Map<String, Any>): PayUAccountDetail {
        val name = map["name"] as String
        var accRefNumber = map["accRefNumber"] as String
        var ifsc = map["ifsc"] as String
        var maskedAccnumber = map["maskedAccnumber"] as String
        var type = map["type"] as String
        var vpa = map["vpa"] as String
        var iin = map["iin"] as String
        var mmid = map["mmid"] as String
        var aeba = map["aeba"] as String
        var mbeba = map["mbeba"] as String
        var dLength = map["dLength"] as String
        var dType = map["dType"] as String
        var balance = map["balance"] as String
        var balTime = map["balTime"] as String
        var status = map["status"] as String
        var bankCode = map["bankCode"] as String
        var formatType = map["formatType"] as String
        var atmdLength = map["atmdLength"] as String
        var bankName = map["bankName"] as String
        var otpdType = map["otpdType"] as String
        var otpdLength = map["otpdLength"] as String
        var bankId = map["bankId"] as String
        var aepsFlag = map["aepsFlag"] as String
        var refUrl = map["refUrl"] as String
        return PayUAccountDetail(name, accRefNumber, ifsc, maskedAccnumber, type, vpa, iin, mmid,
            aeba, mbeba, dLength, dType, balance, balTime, status, bankCode, formatType, atmdLength,
            bankName, otpdType, otpdLength, bankId, aepsFlag, refUrl
        )
    }

    fun parseCustomerBankAccounts(accounts: List<PayUCustomerBankAccounts>): String {
        return JSONArray().apply {
            accounts.forEach { account ->
                val accDetailJson = JSONObject().apply {
                    account.bankAccounts.javaClass.fields.forEach { field ->
                        put(field.name, field.get(field))
                    }
                }
                put(JSONObject().apply {
                    put("bankName", account.bankName)
                    put("bankCode", account.bankCode)
                    put("bankAccounts", accDetailJson)
                })
            }
        }.toString()
    }

    fun parseFetchAccountsIin(response: Any): String {
        return (response as? FetchAccountsIInResponse)?.let { iinResponse ->
            JSONObject().apply {
                iinResponse.accounts?.let {
                    put("accounts", JSONArray(parseCustomerBankAccounts(it)))
                    put("accountsAddedToVpa", iinResponse.accountsAddedToVpa)
                }
            }.toString()
        } ?: ""
    }

    fun getPaymentParams(
        paymentParams: Map<String, Any>,
        accDetailsMap: Map<String, Any>?
    ): PayUUPIBoltPaymentParams {
        val amount = paymentParams["amount"] as String
        val tranType = paymentParams["tranType"] as String
        val refUrl = paymentParams["refUrl"] as String
        val txnId = paymentParams["txnId"] as String
        val refCategory = paymentParams["refCategory"] as String
        val initMode = paymentParams["initMode"] as String
        val purpose = paymentParams["purpose"] as String
        val productInfo = paymentParams["productInfo"] as String
        val firstName = paymentParams["firstName"] as String
        val surl = paymentParams["surl"] as String
        val furl = paymentParams["furl"] as String
        val udf1 = paymentParams["udf1"] as String
        val udf2 = paymentParams["udf2"] as String
        val udf3 = paymentParams["udf3"] as String
        val udf4 = paymentParams["udf4"] as String
        val udf5 = paymentParams["udf5"] as String
        val userCredentials = paymentParams["userCredentials"] as String
        val isCCTxnEnabled = paymentParams["isCCTxnEnabled"] as Boolean
        val mcc = paymentParams["mcc"] as String
        val accountDetail = accDetailsMap?.let {
            getAccountDetail(accDetailsMap)
        } ?: run {
            paymentParams["accountDetail"] as PayUAccountDetail
        }
        return PayUUPIBoltPaymentParams.Builder()
            .amount(amount).tranType(tranType).refUrl(refUrl).txnId(txnId).refCategory(refCategory)
            .initMode(initMode).purpose(purpose).productInfo(productInfo).firstName(firstName)
            .surl(surl).furl(furl).udf1(udf1).udf2(udf2).udf3(udf3).udf4(udf4).udf5(udf5)
            .userCredentials(userCredentials).isCCTxnEnabled(isCCTxnEnabled)
            .setAccountDetail(accountDetail).setMcc(mcc)
            .build()
    }
}