package com.payu.upibolt.payUAxisImpl

import android.util.Log
import androidx.fragment.app.FragmentActivity
import com.olive.upi.OliveUpiManager
import com.olive.upi.transport.OliveUpiEventListener
import com.olive.upi.transport.api.UpiService
import com.olive.upi.transport.model.Account
import com.olive.upi.transport.model.Bank
import com.olive.upi.transport.model.BeneVpa
import com.payu.commonmodelssdk.constants.KibanaEvents
import com.payu.commonmodelssdk.constants.KibanaEvents.PAYU_INIT_PAYMENT_RESPONSE
import com.payu.commonmodelssdk.constants.PayUResponseCodes
import com.payu.commonmodelssdk.constants.PayUResponseMessages
import com.payu.commonmodelssdk.constants.PayUResponseMessages.PAYU_INVALID_RESPONSE_MESSAGE
import com.payu.commonmodelssdk.constants.PayUResponseMessages.PAYU_SUCCESS_MESSAGE
import com.payu.commonmodelssdk.constants.PayUResponseTypes
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_ALL_ACCOUNTS_V3
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_FETCH_ACCOUNT_V3
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_GET_BALANCE
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_LIST_BANKS
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_PAY
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_SAVE_ACCOUNT_V3
import com.payu.commonmodelssdk.constants.PayUUpiConstant
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_CHECK_DEVICE_STATUS
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_QUERY_LIST_SIZE
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_REQUEST_UNKNOWN
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_TXN_LIST_SIZE
import com.payu.commonmodelssdk.constants.payuResponseTypeMap
import com.payu.commonmodelssdk.listeners.OTPVerificationInterface
import com.payu.commonmodelssdk.listeners.PayUUPIBoltCallBack
import com.payu.commonmodelssdk.listeners.ApiFailedCallback
import com.payu.commonmodelssdk.model.request.PayUUPIParams
import com.payu.commonmodelssdk.model.response.FetchAccountsIInResponse
import com.payu.commonmodelssdk.model.response.PayUBankData
import com.payu.commonmodelssdk.model.response.PayUCustomerBankAccounts
import com.payu.commonmodelssdk.model.response.PayUUPIBoltResponse
import com.payu.commonmodelssdk.model.response.PayUTransactionHistory
import com.payu.upibolt.listeners.UpiInitiateCallback
import com.payu.upibolt.utils.AnalyticsUtils
import com.payu.upibolt.utils.CommonPluginImpl
import com.payu.upibolt.utils.InternalConfig
import com.payu.upibolt.utils.Utils
import com.payu.upibolt.utils.payUAxisResponseTypeMap
import org.json.JSONObject
import java.util.concurrent.TimeUnit


/**
 * PayUPluginUtils class used as helper class for AxisImpl class
 * */
open class PayUAxisPluginManager(
    activity: FragmentActivity
) : CommonPluginImpl(activity), OliveUpiEventListener {

    private val TAG = javaClass.simpleName

    protected var oliveUpiManager: OliveUpiManager? = null
    protected var currentRequestType: Int? = null
    private var fetchAccountRetryCount = -1

    protected fun ifAxisDependencyExist(
        responseType: Int? = null,
        callBack: PayUUPIBoltCallBack? = null,
        ifExists: () -> Unit
    ) {
        if (Utils.isAxisDependencyAvailable()) {
            referenceId = Utils.generateUUID()
            initOliveManager()
            ifExists.invoke()
        } else {
            responseType?.let {
                callBack?.onPayUFailure(
                    PayUUPIBoltResponse(
                        responseType,
                        PayUResponseCodes.PAYU_FAILED_STATUS,
                        PayUResponseMessages.PAYU_MANDATORY_PARAM_MISSING_MESSAGE
                                + PayUUpiConstant.PAYU_RUNTIME_DEPENDENCY
                    )
                )
            }
        }
    }

    private fun initOliveManager() {
        if(oliveUpiManager == null) {
            oliveUpiManager = OliveUpiManager.getInstance(activity)
            oliveUpiManager?.setListener(this)
        }
    }

    override fun getRegisteredMobile(): String? {
        var number: String? = null
        ifAxisDependencyExist {
            number = oliveUpiManager?.registeredNumber
            if(number.isNullOrEmpty().not()) {
                number = Utils.formatMobileNumber(number ?: "")
            }
        }
        return number
    }

    override fun initiateWrapperSDK(
        callback: UpiInitiateCallback,
        otpVerificationInterface: OTPVerificationInterface?,
        apiFailureCallback: ApiFailedCallback?
    ) {
        this.upiInitiateCallback = callback
        if (hasSmsAndPhonePermissions()) {
            val pairValue = Utils.isValidInitSDKParams()
            if (pairValue.first) {
                InternalConfig.pgDetails?.let { pgDetails ->
                    InternalConfig.config?.let { params ->
                        val tokenStartTime = System.currentTimeMillis()
                        AxisAuthTokenManager(activity, params, pgDetails,
                            onSuccess = { sdkHandshake ->
                                startTime = System.currentTimeMillis()
                                Log.d(TAG, " storedMobileNumber:" + getRegisteredMobile())
                                Log.d("axis_response", "txnID - ${sdkHandshake.unqTxnId} token - ${sdkHandshake.merchanttoken}")
                                axisStartTimeMap[PAYU_CHECK_DEVICE_STATUS] = startTime
                                logFunctionRequestEvent(
                                    PayUResponseTypes.REQUEST_SDK_HANDSHAKE,
                                    prepareSdkInitParamJson().toString(),
                                    sdkHandshake.unqTxnId,
                                    referenceId = referenceId
                                )
                                oliveUpiManager?.initiateSDK(sdkHandshake)
                            }, onFailure = { errorCode, errorMessage ->
                                logFailureResponse(
                                    PayUUpiConstant.PAYU_AXIS_AUTH_TOKEN, errorCode, errorMessage,
                                    Utils.getTimeDifferenceInMilliSeconds(tokenStartTime)
                                )
                                callback.onSdKError(errorCode, errorMessage)
                            }
                        )
                        return
                    }
                }
            }
            callback.onSdKError(
                PayUResponseCodes.PAYU_FAILED_STATUS,
                "${PayUResponseMessages.PAYU_MANDATORY_PARAM_MISSING_MESSAGE} - ${pairValue.second ?: ""}"
            )
        } else {
            callback.onSdKError(PayUResponseCodes.PERMISSION_MISSING_ERROR_CODE,
                PayUResponseMessages.PAYU_PERMISSION_ERROR_MESSAGE)
        }
    }

    override fun onSuccessResponse(reqType: Int, response: Any?) {
        fetchAccountRetryCount = -1
        val responseType = payUAxisResponseTypeMap[reqType]?:PayUResponseCodes.PAYU_FAILED_STATUS
        val responseTypeString = payuResponseTypeMap[responseType]?: PAYU_REQUEST_UNKNOWN
        if(axisStartTimeMap.containsKey(responseTypeString).not() && responseTypeString != PAYU_REQUEST_UNKNOWN){
            AnalyticsUtils.logEventNameForKibana(
                context = activity,
                eventName = "AXIS_API_SUCCESS",
                eventData = "req type - $reqType there is no handler hence ignoring",
                eventType = AnalyticsUtils.EventType.Info
            )
            return
        }
        (response as? com.olive.upi.transport.api.Result<*>)?.let {
            Log.d("axis_response", responseTypeString + " ${response.code} ${response.data} ${response.result}")
        }
        when (reqType) {
            UpiService.REQUEST_SDK_HANDSHAKE -> {
                if (response is com.olive.upi.transport.api.Result<*>){
                    val registeredMobile = getRegisteredMobile()
                    if (response.code == PayUUpiConstant.AXIS_SUCCESS_STATUS && registeredMobile != null) {
                        InternalConfig.subscriptionId?.let {
                            storeSimInfoInSharedPref(it, registeredMobile, getCarrierNameFromPhone(registeredMobile))
                        }
                        logSuccessEvent(
                            reqType,
                            "mobileNo = ${Utils.getMaskedMobileNumber(registeredMobile.toString())}"
                        )
                        upiInitiateCallback?.onSDKSuccess()
                    } else {
                        logFailureEvent(
                            reqType,
                            PayUResponseCodes.PAYU_HANDSHAKE_FAILED,
                            response.result ?: response.data?.toString()
                        )
                        upiInitiateCallback?.onSdKError(
                            PayUResponseCodes.PAYU_HANDSHAKE_FAILED,
                            "${PayUUpiConstant.AXIS_SDK_RESPONSE} : ${response.result}"
                        )
                    }
                } else {
                    logFailureEvent(
                        reqType,
                        PayUResponseCodes.PAYU_HANDSHAKE_FAILED,
                        response.toString()
                    )
                    upiInitiateCallback?.onSdKError(
                        PayUResponseCodes.PAYU_HANDSHAKE_FAILED,
                        PayUResponseMessages.PAYU_HANDSHAKE_FAILED_MESSAGE
                    )
                }
            }

            UpiService.REQUEST_LIST_BANKS -> {
                getBankListSuccessResponse(response)
            }

            UpiService.REQUEST_FETCH_ACCOUNT_V3 -> {
                 getAccountListSuccessResponse(response)
            }

            UpiService.REQUEST_SAVE_ACCOUNT_V3 -> {
                if (response is com.olive.upi.transport.api.Result<*> && response.data is ArrayList<*>) {
                    val customerbankaccountDataList =
                        response.data as ArrayList<com.olive.upi.transport.model.CustomerBankAccounts>
                    logSuccessEvent(
                        reqType,
                        prepareAxisCustomerAccountJson(customerbankaccountDataList).toString()
                    )
                    val custBankList = ArrayList<PayUCustomerBankAccounts>()
                    for (banks in customerbankaccountDataList) {
                        AxisTransformerUtils.prepareCustomerAccountList(banks, custBankList)
                    }
                    val payUUPIBoltResponse =
                        PayUUPIBoltResponse(
                            REQUEST_SAVE_ACCOUNT_V3,
                            PayUResponseCodes.PAYU_SUCCESS_STATUS,
                            null, custBankList
                        )
                    postSuccessCallBack(payUUPIBoltResponse)
                } else {
                    logFailureEvent(reqType, errorMessage = response.toString())
                    val payUUPIBoltResponse = PayUUPIBoltResponse(
                        REQUEST_SAVE_ACCOUNT_V3,
                        PayUResponseCodes.PAYU_FAILED_STATUS,
                        PAYU_INVALID_RESPONSE_MESSAGE
                    )
                    postFailureCallBack(payUUPIBoltResponse)
                }
            }

            UpiService.REQUEST_ACCOUNT_MOBILE_REG -> {
                if (response is com.olive.upi.transport.api.Result<*>) {
                    logSuccessEvent(
                        reqType, response.data?.toString() ?: PAYU_SUCCESS_MESSAGE
                    )

                    val payUUPIBoltResponse =
                        PayUUPIBoltResponse(
                            PayUResponseTypes.REQUEST_ACCOUNT_MOBILE_REG,
                            PayUResponseCodes.PAYU_SUCCESS_STATUS,
                            null, response.data
                        )
                    postSuccessCallBack(payUUPIBoltResponse)
                } else {
                    logFailureEvent(reqType, errorMessage = response.toString())
                    val payUUPIBoltResponse = PayUUPIBoltResponse(
                        PayUResponseTypes.REQUEST_ACCOUNT_MOBILE_REG,
                        PayUResponseCodes.PAYU_FAILED_STATUS,
                        PAYU_INVALID_RESPONSE_MESSAGE
                    )
                    postFailureCallBack(payUUPIBoltResponse)
                }
            }

            UpiService.REQUEST_ALL_ACCOUNTS_V3 -> {
                 getAddedAccountsList(response)
            }

            UpiService.REQUEST_GET_BALANCE -> {
                getBalanceInfoSuccessResponse(response)
            }

            UpiService.REQUEST_PAY -> {
                if (response is com.olive.upi.transport.api.Result<*>) {
                    logSuccessEvent(
                        reqType, response.data?.toString() ?: PAYU_SUCCESS_MESSAGE,
                        InternalConfig.paymentTxnId
                    )
                    val payUUPIBoltResponse =
                        PayUUPIBoltResponse(
                            PayUResponseTypes.REQUEST_PAY,
                            PayUResponseCodes.PAYU_SUCCESS_STATUS,
                            null, response.data
                        )
                    postSuccessCallBack(payUUPIBoltResponse)
                } else {
                    logFailureEvent(
                        requestType = reqType,
                        errorMessage = response.toString(),
                        txnId = InternalConfig.paymentTxnId
                    )
                    val payUUPIBoltResponse = PayUUPIBoltResponse(
                        PayUResponseTypes.REQUEST_PAY,
                        PayUResponseCodes.PAYU_FAILED_STATUS,
                        PAYU_INVALID_RESPONSE_MESSAGE,
                        null
                    )
                    postFailureCallBack(payUUPIBoltResponse)
                }
            }

            UpiService.REQUEST_GET_CHANGE_MPIN -> {
                if (response is com.olive.upi.transport.api.Result<*>) {
                    logSuccessEvent(
                        reqType, response.data?.toString() ?: PAYU_SUCCESS_MESSAGE
                    )
                    val payUUPIBoltResponse =
                        PayUUPIBoltResponse(
                            PayUResponseTypes.REQUEST_GET_CHANGE_MPIN,
                            PayUResponseCodes.PAYU_SUCCESS_STATUS,
                            null, response.data
                        )
                    postSuccessCallBack(payUUPIBoltResponse)
                } else {
                    logFailureEvent(reqType, errorMessage = response.toString())
                    val payUUPIBoltResponse = PayUUPIBoltResponse(
                        PayUResponseTypes.REQUEST_GET_CHANGE_MPIN,
                        PayUResponseCodes.PAYU_FAILED_STATUS,
                        PAYU_INVALID_RESPONSE_MESSAGE
                    )
                    postFailureCallBack(payUUPIBoltResponse)
                }
            }

            UpiService.REQUEST_GET_RAISE_QUERY_V3 -> {
                if (response is com.olive.upi.transport.api.Result<*>) {
                    logSuccessEvent(reqType, "Dispute ID: ${response.data}")
                    val payUUPIBoltResponse =
                        PayUUPIBoltResponse(
                            PayUResponseTypes.REQUEST_GET_RAISE_QUERY_V3,
                            PayUResponseCodes.PAYU_SUCCESS_STATUS,
                            null, response.data
                        )
                    postSuccessCallBack(payUUPIBoltResponse)
                } else {
                    logFailureEvent(reqType, errorMessage = response.toString())
                    val payUUPIBoltResponse =
                        PayUUPIBoltResponse(
                            PayUResponseTypes.REQUEST_GET_RAISE_QUERY_V3,
                            PayUResponseCodes.PAYU_FAILED_STATUS,
                            PAYU_INVALID_RESPONSE_MESSAGE
                        )
                    postFailureCallBack(payUUPIBoltResponse)
                }
            }

            UpiService.REQUEST_LIST_QUERIES_V3 -> {
                if (response is com.olive.upi.transport.api.Result<*>) {
                    if (response.data is ArrayList<*>) {
                        val list =
                            response.data as? ArrayList<com.olive.upi.transport.model.TranHistory>
                        logSuccessEvent(reqType, PAYU_QUERY_LIST_SIZE + (list?.size.toString()))
                        val txnList = ArrayList<PayUTransactionHistory>()
                        if (list != null) {
                            for (txn in list) {
                                val transaction = PayUTransactionHistory(
                                    txn.check_status_flow1,
                                    txn.check_complain_flow2,
                                    txn.check_DRC_102,
                                    txn.check_DRC_104,
                                    txn.check_DRC_UTU,
                                    txn.tcC_102,
                                    txn.tcC_102,
                                    txn.tcC_RET,
                                    txn.p2M_CHARGEBACK_1061,
                                    txn.p2M_CHARGEBACK_1064,
                                    txn.p2M_CHARGEBACK_1065,
                                    txn.p2M_CHARGEBACK_1084,
                                    txn.type,
                                    txn.tranid,
                                    txn.refid,
                                    txn.dateTime,
                                    txn.amount.toString(),
                                    txn.debitAccount,
                                    txn.debitVpa,
                                    txn.debitBankName,
                                    txn.creditAccount,
                                    txn.creditVpa,
                                    txn.creditBankName,
                                    txn.status,
                                    txn.remarks,
                                    txn.query,
                                    txn.queryStatus,
                                    txn.queryid,
                                    txn.querydate,
                                    txn.expirydateTime,
                                    txn.queryCloserComment,
                                    txn.description,
                                    txn.direction,
                                    txn.creditdebittype,
                                    txn.remitterName,
                                    txn.beneficiaryName,
                                    txn.refurl,
                                    txn.mobilenumber,
                                    txn.beneReversalRespCode,
                                    txn.remitterReversalRespCode,
                                    txn.disputeRc,
                                    txn.disputeStatus,
                                    txn.merchantflag,
                                    txn.initiatedby,
                                    txn.subtype,
                                    txn.input,
                                    txn.initMode,
                                    txn.purposeCode,
                                    txn.umn,
                                    txn.refCategory,
                                    txn.mcc,
                                    txn.refUrl
                                )
                                txnList.add(transaction)
                            }
                        }
                        val payUUPIBoltResponse =
                            PayUUPIBoltResponse(
                                PayUResponseTypes.REQUEST_LIST_QUERIES_V3,
                                PayUResponseCodes.PAYU_SUCCESS_STATUS,
                                null, txnList
                            )
                        postSuccessCallBack(payUUPIBoltResponse)
                        return
                    }
                }
                logFailureEvent(reqType, errorMessage = response.toString())
                val payUUPIBoltResponse = PayUUPIBoltResponse(
                    PayUResponseTypes.REQUEST_LIST_QUERIES_V3,
                    PayUResponseCodes.PAYU_FAILED_STATUS,
                    PAYU_INVALID_RESPONSE_MESSAGE
                )
                postFailureCallBack(payUUPIBoltResponse)
            }

            UpiService.REQUEST_GET_ACCOUNT_REMOVE_V3 -> {
                if (response is com.olive.upi.transport.api.Result<*>) {
                    logSuccessEvent(
                        reqType, response.data?.toString() ?: PAYU_SUCCESS_MESSAGE
                    )
                    val payUUPIBoltResponse =
                        PayUUPIBoltResponse(
                            PayUResponseTypes.REQUEST_GET_ACCOUNT_REMOVE_V3,
                            PayUResponseCodes.PAYU_SUCCESS_STATUS,
                            null, response.data
                        )
                    postSuccessCallBack(payUUPIBoltResponse)
                } else {
                    logFailureEvent(reqType, errorMessage = response.toString())
                    val payUUPIBoltResponse = PayUUPIBoltResponse(
                        PayUResponseTypes.REQUEST_GET_ACCOUNT_REMOVE_V3,
                        PayUResponseCodes.PAYU_FAILED_STATUS,
                        PAYU_INVALID_RESPONSE_MESSAGE
                    )
                    postFailureCallBack(payUUPIBoltResponse)
                }
            }

            UpiService.REQUEST_GET_VPA_REMOVE_V3 -> {
                if (response is com.olive.upi.transport.api.Result<*>) {
                    logSuccessEvent(
                        reqType, response.data?.toString() ?: PAYU_SUCCESS_MESSAGE
                    )
                    val payUUPIBoltResponse = PayUUPIBoltResponse(
                        PayUResponseTypes.REQUEST_GET_VPA_REMOVE_V3,
                        PayUResponseCodes.PAYU_SUCCESS_STATUS,
                        null
                    )
                    postSuccessCallBack(payUUPIBoltResponse)
                } else {
                    logFailureEvent(reqType, errorMessage = response.toString())
                    val payUUPIBoltResponse = PayUUPIBoltResponse(
                        PayUResponseTypes.REQUEST_GET_VPA_REMOVE_V3,
                        PayUResponseCodes.PAYU_FAILED_STATUS,
                        PAYU_INVALID_RESPONSE_MESSAGE
                    )
                    postFailureCallBack(payUUPIBoltResponse)
                }
            }

            UpiService.REQUEST_GET_VPA_V3 -> {
                if (response is com.olive.upi.transport.api.Result<*>) {
                    logSuccessEvent(
                        reqType, response.data?.toString() ?: PAYU_SUCCESS_MESSAGE
                    )
                    val payUUPIBoltResponse =
                        PayUUPIBoltResponse(
                            PayUResponseTypes.REQUEST_GET_VPA_V3,
                            PayUResponseCodes.PAYU_FAILED_STATUS,
                            null, response.data
                        )
                    postSuccessCallBack(payUUPIBoltResponse)
                } else {
                    logFailureEvent(reqType, errorMessage = response.toString())
                    val payUUPIBoltResponse = PayUUPIBoltResponse(
                        PayUResponseTypes.REQUEST_GET_VPA_V3,
                        PayUResponseCodes.PAYU_FAILED_STATUS,
                        PAYU_INVALID_RESPONSE_MESSAGE
                    )
                    postFailureCallBack(payUUPIBoltResponse)
                }
            }

            UpiService.REQUEST_GET_CUSTOMER_deregister_V3 -> {
                if (response is com.olive.upi.transport.api.Result<*>) {
                    logSuccessEvent(
                        reqType, response.data?.toString() ?: PAYU_SUCCESS_MESSAGE
                    )
                    val payUUPIBoltResponse =
                        PayUUPIBoltResponse(
                            PayUResponseTypes.REQUEST_GET_CUSTOMER_deregister_V3,
                            PayUResponseCodes.PAYU_SUCCESS_STATUS,
                            null, response.data
                        )
                    postSuccessCallBack(payUUPIBoltResponse)
                    clearSDKData()
                } else {
                    logFailureEvent(reqType, errorMessage = response.toString())
                    val payUUPIBoltResponse = PayUUPIBoltResponse(
                        PayUResponseTypes.REQUEST_GET_CUSTOMER_deregister_V3,
                        PayUResponseCodes.PAYU_FAILED_STATUS,
                        PAYU_INVALID_RESPONSE_MESSAGE
                    )
                    postFailureCallBack(payUUPIBoltResponse)
                }
            }

            UpiService.REQUEST_GET_PROFilE_VPA_V3 -> {
                if (response is com.olive.upi.transport.api.Result<*>) {
                    logSuccessEvent(
                        reqType, response.data?.toString() ?: PAYU_SUCCESS_MESSAGE
                    )
                    val payUUPIBoltResponse = PayUUPIBoltResponse(
                        PayUResponseTypes.REQUEST_GET_PROFilE_VPA_V3,
                        PayUResponseCodes.PAYU_SUCCESS_STATUS,
                        null, response.data
                    )

                    postSuccessCallBack(payUUPIBoltResponse)
                } else {
                    logFailureEvent(reqType, errorMessage = response.toString())
                    val payUUPIBoltResponse = PayUUPIBoltResponse(
                        PayUResponseTypes.REQUEST_GET_PROFilE_VPA_V3,
                        PayUResponseCodes.PAYU_FAILED_STATUS,
                        PAYU_INVALID_RESPONSE_MESSAGE
                    )
                    postFailureCallBack(payUUPIBoltResponse)
                }
            }

            UpiService.REQUEST_SAVE_VPA_V3 -> {
                if (response is com.olive.upi.transport.api.Result<*>) {
                    logSuccessEvent(
                        reqType, response.data?.toString() ?: PAYU_SUCCESS_MESSAGE
                    )
                    val payUUPIBoltResponse =
                        PayUUPIBoltResponse(
                            PayUResponseTypes.REQUEST_SAVE_VPA_V3,
                            PayUResponseCodes.PAYU_SUCCESS_STATUS,
                            null, response.data
                        )
                    postSuccessCallBack(payUUPIBoltResponse)
                } else {
                    logFailureEvent(reqType, errorMessage = response.toString())
                    val payUUPIBoltResponse = PayUUPIBoltResponse(
                        PayUResponseTypes.REQUEST_SAVE_VPA_V3,
                        PayUResponseCodes.PAYU_FAILED_STATUS,
                        PAYU_INVALID_RESPONSE_MESSAGE
                    )
                    postFailureCallBack(payUUPIBoltResponse)
                }
            }

            UpiService.REQUEST_GET_TRANSACTION_HISTORY_V3 -> {
                if (response is com.olive.upi.transport.api.Result<*>) {
                    if (response.data is ArrayList<*>) {
                        val list = response.data as? ArrayList<com.olive.upi.transport.model.TranHistory>
                        logSuccessEvent(reqType, PAYU_TXN_LIST_SIZE + list?.size.toString())
                        val txnList = ArrayList<PayUTransactionHistory>()
                        if (list != null) {
                            for (txn in list) {
                                val transaction = PayUTransactionHistory(
                                    txn.check_status_flow1, txn.check_complain_flow2, txn.check_DRC_102,
                                    txn.check_DRC_104, txn.check_DRC_UTU, txn.tcC_102, txn.tcC_UTU,
                                    txn.tcC_RET, txn.p2M_CHARGEBACK_1061, txn.p2M_CHARGEBACK_1064,
                                    txn.p2M_CHARGEBACK_1065, txn.p2M_CHARGEBACK_1084, txn.type,
                                    txn.tranid, txn.refid, txn.dateTime, txn.amount.toString(), txn.debitAccount,
                                    txn.debitVpa, txn.debitBankName, txn.creditAccount,
                                    txn.creditVpa, txn.creditBankName, txn.status, txn.remarks,
                                    txn.query, txn.queryStatus, txn.queryid, txn.querydate,
                                    txn.expirydateTime, txn.queryCloserComment, txn.description,
                                    txn.direction, txn.creditdebittype, txn.remitterName,
                                    txn.beneficiaryName, txn.refurl, txn.mobilenumber,
                                    txn.beneReversalRespCode, txn.remitterReversalRespCode,
                                    txn.disputeRc, txn.disputeStatus, txn.merchantflag, txn.initiatedby,
                                    txn.subtype, txn.input, txn.initMode, txn.purposeCode,
                                    txn.umn, txn.refCategory, txn.mcc, txn.refUrl
                                )
                                txnList.add(transaction)
                            }
                        }
                        val payUUPIBoltResponse = PayUUPIBoltResponse(
                            PayUResponseTypes.REQUEST_GET_TRANSACTION_HISTORY_V3,
                            PayUResponseCodes.PAYU_SUCCESS_STATUS,
                            null, txnList
                        )
                        postSuccessCallBack(payUUPIBoltResponse)
                        return
                    }
                }
                logFailureEvent(reqType, errorMessage = response.toString())
                val payUUPIBoltResponse = PayUUPIBoltResponse(
                    PayUResponseTypes.REQUEST_GET_TRANSACTION_HISTORY_V3,
                    PayUResponseCodes.PAYU_FAILED_STATUS,
                    PAYU_INVALID_RESPONSE_MESSAGE
                )
                postFailureCallBack(payUUPIBoltResponse)
            }
        }
        if(axisStartTimeMap.containsKey(responseTypeString)){
            axisStartTimeMap.remove(responseTypeString)
        }
    }

    override fun onFailureResponse(reqType: Int, response: Any?) {
        Log.d("axis_response",  response.toString())
        payUAxisResponseTypeMap[reqType]?.let { responseType ->
            val responseTypeString = payuResponseTypeMap[responseType]?: PAYU_REQUEST_UNKNOWN
            if(axisStartTimeMap.containsKey(responseTypeString).not() && responseTypeString != PAYU_REQUEST_UNKNOWN){
                AnalyticsUtils.logEventNameForKibana(
                    context = activity,
                    eventName = "AXIS_API_FAILURE",
                    eventData = "req type - $reqType there is no handler hence ignoring",
                    eventType = AnalyticsUtils.EventType.Info
                )
                return
            }
            if (response is com.olive.upi.transport.api.Result<*>) {
//            Log.d("axis_response", responseTypeString + " ${response.code} ${response.data} ${response.result}")
                logFailureEvent(
                    reqType, errorMessage = JSONObject().apply {
                        put("data", response.data)
                        put("result", response.result)
                    }.toString(),
                    txnId = if (reqType == UpiService.REQUEST_PAY) InternalConfig.paymentTxnId else null,
                    eventType = if (response.code == PayUUpiConstant.AXIS_USER_ABORTED_CODE)
                        AnalyticsUtils.EventType.Info
                    else
                        AnalyticsUtils.EventType.Error,
                    eventSeverity = if (response.code == PayUUpiConstant.AXIS_USER_ABORTED_CODE)
                        AnalyticsUtils.EventSeverity.Low
                    else
                        AnalyticsUtils.EventSeverity.High,
                    axisErrorCode = response.code
                )
                if (response.code == PayUUpiConstant.AXIS_SESSION_EXPIRE
                    || response.code == PayUUpiConstant.AXIS_TOKEN_EXPIRE) {
                    startTime = 0
                }

                val message = response.result
                if (message.isNullOrEmpty().not() && message.length <= 4) {
                    AnalyticsUtils.logEventNameForKibana(
                        activity,
                        "${PayUUpiConstant.PAYU_AXIS_API}${KibanaEvents.PAYU_EVENT_UNKNOWN}",
                        JSONObject().apply {
                            put("message", message)
                            put("methodName", responseTypeString)
                        }.toString(),
                        eventType = AnalyticsUtils.EventType.Error,
                        eventSeverity = AnalyticsUtils.EventSeverity.High,
                        refType = PayUUpiConstant.AXIS_SDK_RESPONSE
                    )
                }
                if (reqType == UpiService.REQUEST_SDK_HANDSHAKE) {
                    val errorCode = if (message?.contains(PayUResponseMessages.PAYU_LIMIT_EXHAUSTED_MESSAGE) == true)
                        PayUResponseCodes.PAYU_FAILED_STATUS
                    else
                        PayUResponseCodes.PAYU_HANDSHAKE_FAILED
                    upiInitiateCallback?.onSdKError(errorCode, message)
                } else {
                    val responseCode = if (reqType == UpiService.REQUEST_GET_RAISE_QUERY_V3) {
                        if (response.code == PayUUpiConstant.AXIS_QUERY_EXISTS_CODE) {
                            PayUResponseCodes.PAYU_QUERY_ALREADY_EXISTS_CODE
                        } else {
                            PayUResponseCodes.PAYU_FAILED_STATUS
                        }
                    } else {
                        if (response.code == PayUUpiConstant.AXIS_USER_ABORTED_CODE) {
                            PayUResponseCodes.PAYU_USER_CANCELLED_CODE
                        } else {
                            PayUResponseCodes.PAYU_FAILED_STATUS
                        }
                    }

                    val payUUPIBoltResponse = PayUUPIBoltResponse(
                        responseType, responseCode, message
                    )
                    postFailureCallBack(payUUPIBoltResponse)
                }
            } else {
//            Log.d("axis_response", responseTypeString + " ${response.toString()}")
                logFailureEvent(
                    reqType,
                    errorCode = PayUResponseCodes.PAYU_FAILED_STATUS,
                    errorMessage = "requestType - $reqType, message - ${response.toString()}",
                    txnId = if (reqType == UpiService.REQUEST_PAY) InternalConfig.paymentTxnId else null
                )
                if(reqType == UpiService.REQUEST_ALL_ACCOUNTS_V3 && fetchAccountRetryCount < 2) {
                    fetchAccountRetryCount++
                    logPayUFunctionsRequest(
                        PayUResponseTypes.REQUEST_ALL_ACCOUNTS_V3,
                        "retry count: $fetchAccountRetryCount",
                        referenceId = referenceId
                    )
                    oliveUpiManager?.fetchMyAccounts()
                    return
                }
                if (reqType == UpiService.REQUEST_SDK_HANDSHAKE) {
                    upiInitiateCallback?.onSdKError(
                        PayUResponseCodes.PAYU_FAILED_STATUS,
                        response.toString()
                    )
                } else {
                    val payUUPIBoltResponse =
                        PayUUPIBoltResponse(
                            responseType,
                            PayUResponseCodes.PAYU_FAILED_STATUS,
                            response.toString()
                        )
                    postFailureCallBack(payUUPIBoltResponse)
                }
            }
            if(axisStartTimeMap.containsKey(responseTypeString)){
                axisStartTimeMap.remove(responseTypeString)
            }
        }
    }

    private fun getBankListSuccessResponse(response: Any?) {
        if (response is com.olive.upi.transport.api.Result<*>) {
            if (response.data is ArrayList<*>) {
                val bankList = response.data as? ArrayList<Bank>
                val bankDataList = ArrayList<PayUBankData>()
                if (bankList != null) {
                    for (bank in bankList) {
                        val bankData = PayUBankData(bank.name, bank.iin, bank.ifsc, bank.logo)
                        bankDataList.add(bankData)
                    }
                }
                logSuccessEvent(
                    UpiService.REQUEST_LIST_BANKS, "count: ${bankDataList.size}",
                )
                val payUUPIBoltResponse = PayUUPIBoltResponse(
                    PayUResponseTypes.REQUEST_LIST_BANKS,
                    PayUResponseCodes.PAYU_SUCCESS_STATUS,
                    null, bankDataList
                )
                postSuccessCallBack(payUUPIBoltResponse)
                return
            }
        }
        logFailureEvent(
            REQUEST_LIST_BANKS, PayUResponseCodes.PAYU_FAILED_STATUS, response.toString()
        )
        val payUUPIBoltResponse = PayUUPIBoltResponse(
            REQUEST_LIST_BANKS,
            PayUResponseCodes.PAYU_FAILED_STATUS,
            PAYU_INVALID_RESPONSE_MESSAGE,
            response
        )
        postFailureCallBack(payUUPIBoltResponse)
    }

    private fun getAccountListSuccessResponse(response: Any?) {
        if (response is com.olive.upi.transport.api.Result<*>) {
            if (response.data is ArrayList<*>) {
                val accountDataList =
                    response.data as? ArrayList<Account>
                logSuccessEvent(
                    UpiService.REQUEST_FETCH_ACCOUNT_V3, "count: ${accountDataList?.size ?: 0}",
                )
                val accountList = accountDataList?.let { AxisTransformerUtils.prepareAccountData(it) }
                val payUUPIBoltResponse =
                    PayUUPIBoltResponse(
                        REQUEST_FETCH_ACCOUNT_V3,
                        PayUResponseCodes.PAYU_SUCCESS_STATUS,
                        response.result,
                        FetchAccountsIInResponse(accountList, true)
                    )
                postSuccessCallBack(payUUPIBoltResponse)
                return
            }
            logFailureEvent(
                UpiService.REQUEST_FETCH_ACCOUNT_V3, errorMessage = response.toString()
            )
            val payUUPIBoltResponse = PayUUPIBoltResponse(
                REQUEST_FETCH_ACCOUNT_V3,
                PayUResponseCodes.PAYU_FAILED_STATUS,
                PAYU_INVALID_RESPONSE_MESSAGE
            )
            postFailureCallBack(payUUPIBoltResponse)
            return
        }
        logFailureEvent(
            UpiService.REQUEST_FETCH_ACCOUNT_V3, errorMessage = response.toString()
        )
        val payUUPIBoltResponse = PayUUPIBoltResponse(
            REQUEST_FETCH_ACCOUNT_V3,
            PayUResponseCodes.PAYU_FAILED_STATUS,
            PAYU_INVALID_RESPONSE_MESSAGE
        )
        postFailureCallBack(payUUPIBoltResponse)
    }


    private fun getAddedAccountsList(response: Any?) {
            if (response is ArrayList<*>) {
                val customerBankAccountList =
                    response as? ArrayList<com.olive.upi.transport.model.CustomerBankAccounts>
                logSuccessEvent(
                    UpiService.REQUEST_ALL_ACCOUNTS_V3, "count: ${customerBankAccountList?.size ?: 0}",
                )
                val custBankList = ArrayList<PayUCustomerBankAccounts>()
                if (customerBankAccountList != null) {
                    for (banks in customerBankAccountList) {
                        AxisTransformerUtils.prepareCustomerAccountList(banks, custBankList)
                    }
                }
                val payUUPIBoltResponse = PayUUPIBoltResponse(
                    REQUEST_ALL_ACCOUNTS_V3,
                    PayUResponseCodes.PAYU_SUCCESS_STATUS,
                    null, custBankList
                )
                postSuccessCallBack(payUUPIBoltResponse)
            } else {
                logFailureEvent(
                    UpiService.REQUEST_ALL_ACCOUNTS_V3,
                    errorMessage = response.toString()
                )
                val payUUPIBoltResponse = PayUUPIBoltResponse(
                    REQUEST_ALL_ACCOUNTS_V3,
                    PayUResponseCodes.PAYU_FAILED_STATUS,
                    PAYU_INVALID_RESPONSE_MESSAGE
                )
                postFailureCallBack(payUUPIBoltResponse)
            }
    }

    private fun getBalanceInfoSuccessResponse(response: Any?) {
        if (response is com.olive.upi.transport.api.Result<*>) {
            val jsonObject = prepareJsonFromCheckBalanceResponse(response.result, response.code)
            logAxisSuccessResponse(UpiService.REQUEST_GET_BALANCE, jsonObject.toString())
            if (response.data != null && response.data is String) {
                val balance = response.data.toString().toDoubleOrNull()
                if (balance != null) {
                    val payUUPIBoltResponse = PayUUPIBoltResponse(
                        REQUEST_GET_BALANCE,
                        PayUResponseCodes.PAYU_SUCCESS_STATUS,
                        null, balance
                    )
                    val json = prepareJsonForCheckBalanceMerchant(payUUPIBoltResponse)
                    logSuccessResponse(UpiService.REQUEST_GET_BALANCE, json.toString())
                    postSuccessCallBack(payUUPIBoltResponse)
                    return
                }
            }

        }
        logFailureEvent(REQUEST_GET_BALANCE, errorMessage = response.toString())
        val payUUPIBoltResponse = PayUUPIBoltResponse(
            REQUEST_GET_BALANCE,
            PayUResponseCodes.PAYU_FAILED_STATUS,
            PAYU_INVALID_RESPONSE_MESSAGE
        )
        postFailureCallBack(payUUPIBoltResponse)
    }

    private fun postSuccessCallBack(payUUPIBoltResponse: PayUUPIBoltResponse) {
        callBack[PayUResponseTypes.PAYU_CALLBACK_KEY]?.onPayUSuccess(payUUPIBoltResponse)
    }

    private fun postFailureCallBack(response: PayUUPIBoltResponse) {
        callBack[PayUResponseTypes.PAYU_CALLBACK_KEY]?.onPayUFailure(response)
    }

    protected fun clearSDKData() {
        oliveUpiManager?.clearSDK()
        clearPayUSdk()
    }

    override fun isSessionValid(): Boolean {
        return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startTime) <= 150
    }

    override fun makePayment(payUUPIParams: PayUUPIParams) {
        val account = payUUPIParams.params?.accountDetail?.let { AxisTransformerUtils.getAccount(it) }
        val merchId = InternalConfig.pgDetails?.merchId
        val merchChanId = InternalConfig.pgDetails?.merchChanId
        val mcc = InternalConfig.pgDetails?.mcc
        val beneVpa = BeneVpa()
        beneVpa.nickname = ""
        beneVpa.name = initiatePayResponse?.merchantName
        beneVpa.vpa = initiatePayResponse?.merchantVpa

        axisStartTimeMap[PayUUpiConstant.PAYU_REQUEST_PAY] = System.currentTimeMillis()
        logAxisFunctionsRequest(
            REQUEST_PAY,
            payUUPIParams.params?.accountDetail?.let {
                PAYU_INIT_PAYMENT_RESPONSE + "_" + prepareInitiatePayJson(
                    it,
                    beneVpa,
                    payUUPIParams.params?.amount ?: "",
                    payUUPIParams.params?.productInfo ?: "",
                    payUUPIParams.params?.txnId ?: ""
                ).toString()
            } ?: "", payUUPIParams.params?.txnId,
            referenceId = referenceId,
            amount = payUUPIParams.params?.amount
        )
        oliveUpiManager?.initiatePay(
            account, beneVpa, initiatePayResponse?.txnAmount,
            payUUPIParams.params?.productInfo, initiatePayResponse?.merchantVpa,
            merchId, merchId, merchChanId,
            PayUUpiConstant.AXIS_TRANSACTION_TYPE_P2M,
            mcc, initiatePayResponse?.referenceId,
            null, "", PayUUpiConstant.AXIS_REF_CATEGORY,
            PayUUpiConstant.AXIS_INIT_MODE, PayUUpiConstant.AXIS_PURPOSE,
            null
        )
    }

    private fun logSuccessEvent(
        requestType: Int,
        response: String,
        txnId: String? = null
    ) {
        logAxisSuccessResponse(requestType, response, txnId)
        logSuccessResponse(requestType, response, txnId)
    }

    private fun logFailureEvent(
        requestType: Int,
        errorCode: Int? = null,
        errorMessage: String?,
        referenceId: String? = null,
        txnId: String ?= null,
        eventType: AnalyticsUtils.EventType = AnalyticsUtils.EventType.Error,
        eventSeverity: AnalyticsUtils.EventSeverity = AnalyticsUtils.EventSeverity.High,
        axisErrorCode: String? = null
    ) {
        logAxisFailureResponse(
            requestType,
            errorCode?.toString() ?: axisErrorCode ?: PayUResponseCodes.PAYU_FAILED_STATUS.toString(),
            errorMessage,
            referenceId,
            txnId,
            eventType,
            eventSeverity
        )
        logFailureResponse(
            requestType,
            errorCode ?: PayUResponseCodes.PAYU_FAILED_STATUS,
            errorMessage,
            referenceId,
            txnId,
            eventType = eventType,
            eventSeverity = eventSeverity,
            axisErrorCode = axisErrorCode
        )
    }

    private fun logFunctionRequestEvent(
        responseType: Int,
        request: String,
        txnId: String? = null,
        referenceId: String? = null,
        amount: String? = null
    ) {
        logAxisFunctionsRequest(
            responseType,
            request,
            txnId,
            referenceId = referenceId,
            amount = amount
        )
        logPayUFunctionsRequest(
            responseType,
            request,
            txnId,
            referenceId = referenceId,
            amount = amount
        )
    }

}
