package com.payu.upibolt.utils

import android.content.Context
import android.content.SharedPreferences
import com.payu.commonmodelssdk.constants.PayUUpiConstant
import com.payu.upibolt.BuildConfig

internal object SharedPrefsUtils {

    fun saveStringValue(context: Context, key: String, value: String) {
        val editor = getSharedPreference(context).edit()
        editor?.putString(key, value)
        editor?.apply()
    }

    fun saveStringValues(context: Context, map: HashMap<String, String>) {
        val editor = getSharedPreference(context).edit()
        map.keys.forEach {
            editor?.putString(it, map[it])
        }
        editor?.apply()
    }

    fun getStringValue(context: Context, key: String): String? {
        val prefs = getSharedPreference(context)
        return prefs.getString(key, null)
    }

    private fun getSharedPreference(context: Context): SharedPreferences {
        val fileName = BuildConfig.LIBRARY_PACKAGE_NAME + PayUUpiConstant.PAYU_SIM_INFO
        return context.getSharedPreferences(fileName, Context.MODE_PRIVATE)
    }

    fun clearPreference(context: Context) {
        getSharedPreference(context).edit()?.clear()?.apply()
    }
}