package com.payu.upibolt.payUAxisImpl

import android.content.Context
import android.os.Handler
import android.os.Looper
import com.payu.commonmodelssdk.constants.ApiConstant.PAYU_POST
import com.payu.commonmodelssdk.constants.PayUResponseCodes
import com.payu.commonmodelssdk.constants.PayUResponseMessages
import com.payu.commonmodelssdk.constants.PayUUpiConstant
import com.payu.commonmodelssdk.listeners.ApiBaseCallback
import com.payu.commonmodelssdk.listeners.PayUAsyncTaskResponse
import com.payu.commonmodelssdk.model.PayUNetworkData
import com.payu.upibolt.network.BaseApiTask
import com.payu.upibolt.network.HttpApiCall
import com.payu.upibolt.utils.Utils
import org.json.JSONException
import org.json.JSONObject


class AuthTokenTask(private val context: Context): BaseApiTask(context, PayUUpiConstant.PAYU_AXIS_AUTH_TOKEN) {
    override fun callApi(
        params: Any,
        isProd: Boolean,
        callback: ApiBaseCallback
    ) {
        val networkData = getNetworkData(isProd, params)

        startTime = System.currentTimeMillis()
        HttpApiCall(context).makePostAPICall(PayUUpiConstant.PAYU_AXIS_AUTH_TOKEN, PAYU_POST, networkData, object :
            PayUAsyncTaskResponse {
            override fun onSuccess(response: Any) {
                val handler = Handler(Looper.getMainLooper())
                try {
                        val jsonObject = JSONObject(response.toString())
                        if (jsonObject.get(PayUUpiConstant.PAYU_DATA) is JSONObject) {
                            val data: JSONObject =
                                jsonObject.get(PayUUpiConstant.PAYU_DATA) as JSONObject
                            if (data.has(PayUUpiConstant.PAYU_AUTH_TOKEN)) {
                                val authToken = data.getString(PayUUpiConstant.PAYU_AUTH_TOKEN)
                                if (authToken.isNullOrEmpty()) {
                                    authTokenError(authToken)
                                } else {
                                    logApiSuccessResponseData(Utils.getMaskedString(authToken) ?: "")
                                    val runnable = Runnable {
                                        callback.onApiSuccess(authToken)
                                    }
                                    handler.post(runnable)
                                }
                            }
                        } else {
                            authTokenError(jsonObject.toString())
                        }
                } catch (e: JSONException) {
                    authTokenError(e.localizedMessage)
                }
            }

            private fun authTokenError(message: String?) {
                errorCallBack(
                    PayUResponseCodes.PAYU_FAILED_STATUS,
                    message ?: PayUResponseMessages.PAYU_AUTH_TOKEN_INVALID_MESSAGE
                )
            }

            override fun onFailure(errorCode: Int, errorMessage: String) {
                errorCallBack(errorCode, errorMessage)
            }

            private fun errorCallBack(errorCode: Int, errorMessage: String) {
                logApiFailureResponseData(errorCode, errorMessage)
                val handler = Handler(Looper.getMainLooper())
                val runnable = Runnable {
                    callback.onApiError(errorCode, errorMessage)
                }
                handler.post(runnable)
            }
        })
    }

    private fun getNetworkData(
        isProd: Boolean,
        params: Any
    ): PayUNetworkData {
        val url = if (isProd)
            PayUUpiConstant.AXIS_PROD_URL
        else
            PayUUpiConstant.AXIS_UAT_URL
        return PayUNetworkData(
            url,
            postRequest = params.toString(),
            contentType = PayUUpiConstant.APPLICATION_JSON
        )
    }

}