package com.payu.upibolt.payUAxisImpl


import android.os.Build
import androidx.fragment.app.FragmentActivity
import com.olive.upi.transport.api.UpiService
import com.payu.commonmodelssdk.constants.CLConstant
import com.payu.commonmodelssdk.constants.PayUResponseCodes
import com.payu.commonmodelssdk.constants.PayUResponseMessages
import com.payu.commonmodelssdk.constants.PayUResponseTypes
import com.payu.commonmodelssdk.constants.PayUResponseTypes.CHECK_DEVICE_BINDING_STATUS
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_ACCOUNT_MOBILE_REG
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_GET_ACCOUNT_REMOVE_V3
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_GET_CHANGE_MPIN
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_GET_CUSTOMER_deregister_V3
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_GET_PROFilE_VPA_V3
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_GET_RAISE_QUERY_V3
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_GET_TRANSACTION_HISTORY_V3
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_GET_VPA_REMOVE_V3
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_GET_VPA_V3
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_LIST_BANKS
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_LIST_QUERIES_V3
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_SAVE_ACCOUNT_V3
import com.payu.commonmodelssdk.constants.PayUResponseTypes.REQUEST_SAVE_VPA_V3
import com.payu.commonmodelssdk.constants.PayUUpiConstant
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_SET_MPIN
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_BANK_ID
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_CHECK_BALANCE
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_CHECK_DEVICE_STATUS
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_DEREGISTER_ACCOUNTS
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_FETCH_ACCOUNTS_IIN
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_LINKED_ACCOUNTS
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_REMOVE_ACCOUNT
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_REQUEST_DELETE_VPA
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_REQUEST_GET_CHANGE_MPIN
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_REQUEST_GET_VPA_PROFILE
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_REQUEST_LIST_BANKS
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_REQUEST_QUERY_LIST
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_REQUEST_RAISE_QUERY
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_REQUEST_REGISTERED_VPA
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_REQUEST_SAVE_VPA
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_REQUEST_TXN_HISTORY
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_REQUEST_SET_VPA
import com.payu.commonmodelssdk.constants.PayUUpiConstant.PAYU_VPA
import com.payu.commonmodelssdk.listeners.OTPVerificationInterface
import com.payu.commonmodelssdk.listeners.PayUUPIBoltCallBack
import com.payu.commonmodelssdk.model.request.PayUUPIBoltPaymentParams
import com.payu.commonmodelssdk.model.response.PayUAccountDetail
import com.payu.commonmodelssdk.model.response.PayUUPIBoltResponse
import com.payu.upibolt.listeners.PluginInterface
import com.payu.upibolt.listeners.UpiInitiateCallback
import com.payu.upibolt.utils.InternalConfig
import com.payu.upibolt.utils.Utils
import org.json.JSONObject

/**
 * Impl class of PluginInterface and its method
 * */

internal class PayUAxisPlugin(activity: FragmentActivity) : PluginInterface,
    PayUAxisPluginManager(activity) {

    override fun hasPermissions() = hasSmsAndPhonePermissions()
    override fun clearCache() {
        callBack.clear()
        currentRequestType = null
        upiInitiateCallback = null
        InternalConfig.activeApiCalls.forEach {
            if(it?.request()?.tag() != PayUUpiConstant.PAYU_CANCEL_TXN) {
                it?.cancel()
            }
        }
    }

    override fun clearData() {
        clearCache()
        clearSDKData()
    }

    override fun checkDisputeStatus(txnId: String, callback: PayUUPIBoltCallBack) {
        callback.onPayUFailure(
            PayUUPIBoltResponse(
                PayUResponseTypes.REQUEST_CHECK_DISPUTE_STATUS,
                PayUResponseCodes.PAYU_FAILED_STATUS, PayUResponseMessages.PAYU_METHOD_NOT_SUPPORTED
            )
        )
    }

    override fun checkDeviceBinding(
        mobileNo: String,
        subscriptionId: String,
        callback: PayUUPIBoltCallBack
    ) {
        val referenceId = Utils.generateUUID()
        logPayUFunctionsRequest(
            CHECK_DEVICE_BINDING_STATUS,
            prepareCheckDeviceRequestJson(subscriptionId, mobileNo).toString(),
            referenceId = referenceId
        )
        val startTime = System.currentTimeMillis()
        val response = super.checkDeviceStatus(mobileNo, subscriptionId)
        if (response.code == PayUResponseCodes.PAYU_SUCCESS_STATUS) {
            val timeDiff = Utils.getTimeDifferenceInMilliSeconds(startTime)
            logSuccessResponse(
                PayUUpiConstant.PAYU_CHECK_DEVICE_BINDING_STATUS,
                response.message ?: CLConstant.PAYU_EVENT_SUCCESS,
                timeDiff,
                referenceId = referenceId
            )
            callback.onPayUSuccess(response)
        } else {
            if (response.code != PayUResponseCodes.PAYU_DEVICE_BINDING_FAILED) {
                val timeDiff = Utils.getTimeDifferenceInMilliSeconds(startTime)
                logFailureResponse(
                    PayUUpiConstant.PAYU_CHECK_DEVICE_BINDING_STATUS,
                    response.code,
                    response.message ?: CLConstant.PAYU_EVENT_FAILURE,
                    timeDiff,
                    referenceId = referenceId
                )
            }
            callback.onPayUFailure(response)
        }
    }


    override fun checkDeviceStatus(
        subscriptionId: String, phone: String,
        otpVerificationInterface: OTPVerificationInterface?,
        callback: PayUUPIBoltCallBack
    ) {
        ifAxisDependencyExist(PayUResponseTypes.REQUEST_SDK_HANDSHAKE, callback) {
            val startTime = System.currentTimeMillis()
            payuStartTimeMap[PAYU_CHECK_DEVICE_STATUS] = startTime
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                InternalConfig.mobile = phone
                InternalConfig.subscriptionId = subscriptionId
                initiateWrapperSDK(object : UpiInitiateCallback {
                    override fun onSDKSuccess() {
                        val response = PayUUPIBoltResponse(
                            PayUResponseTypes.REQUEST_SDK_HANDSHAKE,
                            PayUResponseCodes.PAYU_SUCCESS_STATUS,
                            null
                        )
                        val timeDiff = Utils.getTimeDifferenceInMilliSeconds(startTime)
                        logSuccessResponse(
                            PAYU_CHECK_DEVICE_STATUS,
                            response.message ?: CLConstant.PAYU_EVENT_SUCCESS,
                            timeDiff,
                            referenceId = referenceId
                        )
                        callback.onPayUSuccess(response)
                    }

                    override fun onSdKError(errorCode: Int, errorMessage: String?) {
                        val response = PayUUPIBoltResponse(
                            PayUResponseTypes.REQUEST_SDK_HANDSHAKE,
                            errorCode, errorMessage
                        )
                        val timeDiff = Utils.getTimeDifferenceInMilliSeconds(startTime)
                        logFailureResponse(
                            PAYU_CHECK_DEVICE_STATUS,
                            errorCode,
                            errorMessage ?: CLConstant.PAYU_EVENT_FAILURE,
                            timeDiff,
                            referenceId = referenceId
                        )
                        callback.onPayUFailure(response)
                    }
                })
            } else {
                val response = PayUUPIBoltResponse(
                    PayUResponseTypes.REQUEST_SDK_HANDSHAKE,
                    PayUResponseCodes.PAYU_DEVICE_NOT_SUPPORTED_CODE,
                    PayUResponseMessages.PAYU_DEVICE_NOT_SUPPORTED
                )
                val timeDiff = Utils.getTimeDifferenceInMilliSeconds(startTime)
                logFailureResponse(
                    PAYU_CHECK_DEVICE_STATUS,
                    response.code,
                    response.message ?: "",
                    timeDiff,
                    referenceId = referenceId
                )
                callback.onPayUFailure(response)
            }
        }
    }

    override fun fetchBankList(callback: PayUUPIBoltCallBack) {
        ifAxisDependencyExist(PayUResponseTypes.REQUEST_LIST_BANKS, callback) {
            logPayUFunctionsRequest(REQUEST_LIST_BANKS, "", referenceId = referenceId)
            val startTime = System.currentTimeMillis()
            payuStartTimeMap[PAYU_REQUEST_LIST_BANKS] = startTime
            validateSDKSession(
                PayUResponseTypes.REQUEST_LIST_BANKS,
                object : UpiInitiateCallback {
                    override fun onSDKSuccess() {
                        callBack[PayUResponseTypes.PAYU_CALLBACK_KEY] = callback
                        currentRequestType = PayUResponseTypes.REQUEST_LIST_BANKS
                        axisStartTimeMap[PAYU_REQUEST_LIST_BANKS] = System.currentTimeMillis()
                        oliveUpiManager?.fetchListBanks()
                    }

                    override fun onSdKError(errorCode: Int, errorMessage: String?) {
                        val timeDiff = Utils.getTimeDifferenceInMilliSeconds(startTime)
                        val response = PayUUPIBoltResponse(
                            REQUEST_LIST_BANKS,
                            errorCode, errorMessage
                        )
                        logFailureResponse(
                            PAYU_REQUEST_LIST_BANKS,
                            errorCode,
                            errorMessage ?: "",
                            timeDiff,
                            referenceId = referenceId
                        )
                        callback.onPayUFailure(response)
                    }
                }
            )
        }
    }

    override fun fetchAccountsWithIin(
        iin: String?,
        bankName: String?,
        bankCode: String?,
        vpa: String?,
        requestType: String?,
        isCCTxnEnabled: Boolean,
        bankId: String?,
        callback: PayUUPIBoltCallBack
    ) {
        ifAxisDependencyExist(PayUResponseTypes.REQUEST_FETCH_ACCOUNT_V3, callback) {
            val request = prepareJsonFromAccountsInn(
                bankName,
                bankCode,
                iin,
                vpa,
                isCCTxnEnabled,
                requestType
            )
            logPayUFunctionsRequest(
                PayUResponseTypes.REQUEST_FETCH_ACCOUNT_V3,
                request.toString(),
                referenceId = referenceId
            )
            val startTime = System.currentTimeMillis()
            payuStartTimeMap[PAYU_FETCH_ACCOUNTS_IIN] = startTime
            validateSDKSession(PayUResponseTypes.REQUEST_FETCH_ACCOUNT_V3,
                object : UpiInitiateCallback {
                    override fun onSDKSuccess() {
                        InternalConfig.bankName = bankName
                        callBack[PayUResponseTypes.PAYU_CALLBACK_KEY] = callback
                        currentRequestType = PayUResponseTypes.REQUEST_FETCH_ACCOUNT_V3
                        axisStartTimeMap[PAYU_FETCH_ACCOUNTS_IIN] = System.currentTimeMillis()
                        logAxisFunctionsRequest(
                            PayUResponseTypes.REQUEST_FETCH_ACCOUNT_V3,
                            prepareJsonFromAccountsInn(iin, isCCTxnEnabled).toString(),
                            referenceId = referenceId
                        )
                        oliveUpiManager?.FetchAccountonIIN(
                            iin,
                            if (isCCTxnEnabled) PayUUpiConstant.PAYU_ACCOUNT_TYPE_CREDIT  else ""
                        )
                    }

                    override fun onSdKError(errorCode: Int, errorMessage: String?) {
                        val response = PayUUPIBoltResponse(
                            PayUResponseTypes.REQUEST_FETCH_ACCOUNT_V3,
                            errorCode, errorMessage
                        )
                        logFailureResponse(
                            PAYU_FETCH_ACCOUNTS_IIN,
                            errorCode,
                            errorMessage ?: "",
                            Utils.getTimeDifferenceInMilliSeconds(startTime),
                            referenceId = referenceId
                        )
                        callback.onPayUFailure(response)
                    }
                }
            )
        }
    }

    override fun fetchLinkedAccounts(callback: PayUUPIBoltCallBack) {
        ifAxisDependencyExist(PayUResponseTypes.REQUEST_ALL_ACCOUNTS_V3, callback) {
            logPayUFunctionsRequest(
                PayUResponseTypes.REQUEST_ALL_ACCOUNTS_V3,
                "",
                referenceId = referenceId
            )
            val startTime = System.currentTimeMillis()
            payuStartTimeMap[PAYU_LINKED_ACCOUNTS] = startTime
            validateSDKSession(
                PayUResponseTypes.REQUEST_ALL_ACCOUNTS_V3,
                object : UpiInitiateCallback {
                    override fun onSDKSuccess() {
                        callBack[PayUResponseTypes.PAYU_CALLBACK_KEY] = callback
                        currentRequestType = PayUResponseTypes.REQUEST_ALL_ACCOUNTS_V3
                        axisStartTimeMap[PAYU_LINKED_ACCOUNTS] = System.currentTimeMillis()
                        oliveUpiManager?.fetchMyAccounts()
                    }

                    override fun onSdKError(errorCode: Int, errorMessage: String?) {
                        val response = PayUUPIBoltResponse(
                            PayUResponseTypes.REQUEST_ALL_ACCOUNTS_V3,
                            errorCode, errorMessage
                        )
                        logFailureResponse(
                            PAYU_LINKED_ACCOUNTS,
                            errorCode,
                            errorMessage ?: "",
                            Utils.getTimeDifferenceInMilliSeconds(startTime),
                            referenceId = referenceId
                        )
                        callback.onPayUFailure(response)
                    }
                })
        }
    }

    override fun checkBalance(accountDetail: PayUAccountDetail, callback: PayUUPIBoltCallBack) {
        ifAxisDependencyExist(PayUResponseTypes.REQUEST_GET_BALANCE, callback) {
            val fnCalledTime = System.currentTimeMillis()
            payuStartTimeMap[PAYU_CHECK_BALANCE] = fnCalledTime
            logPayUFunctionsRequest(
                PayUResponseTypes.REQUEST_GET_BALANCE,
                prepareJsonFromAccount(accountDetail).toString(),
                referenceId = referenceId
            )
            validateSDKSession(PayUResponseTypes.REQUEST_GET_BALANCE, object : UpiInitiateCallback {
                override fun onSDKSuccess() {
                    val account = AxisTransformerUtils.getAccount(accountDetail)
                    axisStartTimeMap[PAYU_CHECK_BALANCE] = fnCalledTime
                    if (account.mbeba == PayUUpiConstant.PAYU_VALUE_Y
                        && account.vpa.isNullOrEmpty().not()) {
                        callBack[PayUResponseTypes.PAYU_CALLBACK_KEY] = callback
                        currentRequestType = PayUResponseTypes.REQUEST_GET_BALANCE
                        logAxisFunctionsRequest(
                            PayUResponseTypes.REQUEST_GET_BALANCE,
                            prepareJsonFromAccount(account).toString(),
                            referenceId = referenceId
                        )
                        oliveUpiManager?.checkBalance(account)
                    } else {
                        val response = PayUUPIBoltResponse(
                            PayUResponseTypes.REQUEST_GET_BALANCE,
                            PayUResponseCodes.PAYU_FAILED_STATUS,
                            if (account.vpa.isNullOrEmpty())
                                PayUResponseMessages.PAYU_UPI_ID_NOT_SET
                            else
                                PayUResponseMessages.PAYU_PIN_NOT_SET
                        )
                        logAxisFailureResponse(
                            UpiService.REQUEST_GET_BALANCE,
                            response.code.toString(),
                            response.message ?: "",
                            referenceId = referenceId
                        )

                        callback.onPayUFailure(response)
                    }
                }

                override fun onSdKError(errorCode: Int, errorMessage: String?) {
                    val response = PayUUPIBoltResponse(
                        PayUResponseTypes.REQUEST_GET_BALANCE, errorCode, errorMessage
                    )
                    logFailureResponse(
                        PAYU_CHECK_BALANCE,
                        response.code,
                        response.message ?: "",
                        Utils.getTimeDifferenceInMilliSeconds(fnCalledTime),
                        referenceId = referenceId
                    )
                    callback.onPayUFailure(response)
                }

            })
        }
    }

    override fun setMPIN(
        accountDetail: PayUAccountDetail,
        cardNo: String,
        exp: String,
        callback: PayUUPIBoltCallBack
    ) {
        ifAxisDependencyExist(PayUResponseTypes.REQUEST_ACCOUNT_MOBILE_REG, callback) {
            logPayUFunctionsRequest(
                REQUEST_ACCOUNT_MOBILE_REG,
                prepareActivatePayuAccountJson(accountDetail, cardNo, exp).toString(),
                referenceId = referenceId
            )
            val fnCalledTime = System.currentTimeMillis()
            payuStartTimeMap[PAYU_SET_MPIN] = fnCalledTime
            validateSDKSession(REQUEST_ACCOUNT_MOBILE_REG, object : UpiInitiateCallback {
                override fun onSDKSuccess() {
                    val account = AxisTransformerUtils.getAccount(accountDetail)
                    callBack[PayUResponseTypes.PAYU_CALLBACK_KEY] = callback
                    currentRequestType = PayUResponseTypes.REQUEST_ACCOUNT_MOBILE_REG
                    axisStartTimeMap[PAYU_SET_MPIN] = System.currentTimeMillis()
                    val requestJson = prepareActivateAccountJson(account, cardNo, exp)
                    logAxisFunctionsRequest(
                        REQUEST_ACCOUNT_MOBILE_REG,
                        requestJson.toString(),
                        referenceId = referenceId
                    )
                    oliveUpiManager?.activateAccount(accountDetail.iin, account, cardNo, exp, false)
                }

                override fun onSdKError(errorCode: Int, errorMessage: String?) {
                    val response = PayUUPIBoltResponse(
                        REQUEST_ACCOUNT_MOBILE_REG, errorCode, errorMessage
                    )
                    logFailureResponse(
                        PAYU_SET_MPIN,
                        errorCode,
                        errorMessage ?: "",
                        Utils.getTimeDifferenceInMilliSeconds(fnCalledTime),
                        referenceId = referenceId
                    )
                    callback.onPayUFailure(response)
                }

            })
        }
    }

    override fun removeAccount(
        accountDetail: PayUAccountDetail,
        callback: PayUUPIBoltCallBack
    ) {
        ifAxisDependencyExist(PayUResponseTypes.REQUEST_GET_ACCOUNT_REMOVE_V3, callback) {
            logPayUFunctionsRequest(
                REQUEST_GET_ACCOUNT_REMOVE_V3,
                prepareJsonFromAccount(accountDetail).toString(),
                referenceId = referenceId
            )
            val fnCalledTime = System.currentTimeMillis()
            payuStartTimeMap[PAYU_REMOVE_ACCOUNT] = fnCalledTime
            validateSDKSession(
                REQUEST_GET_ACCOUNT_REMOVE_V3,
                object : UpiInitiateCallback {
                    override fun onSDKSuccess() {
                        val account = AxisTransformerUtils.getAccount(accountDetail)
                        callBack[PayUResponseTypes.PAYU_CALLBACK_KEY] = callback
                        currentRequestType = PayUResponseTypes.REQUEST_GET_ACCOUNT_REMOVE_V3
                        axisStartTimeMap[PAYU_REMOVE_ACCOUNT] = System.currentTimeMillis()
                        logAxisFunctionsRequest(
                            REQUEST_GET_ACCOUNT_REMOVE_V3,
                            prepareJsonFromAccount(account).toString(),
                            referenceId = referenceId
                        )
                        oliveUpiManager?.accountRemove(account)
                    }

                    override fun onSdKError(errorCode: Int, errorMessage: String?) {
                        val response = PayUUPIBoltResponse(
                            REQUEST_GET_ACCOUNT_REMOVE_V3, errorCode, errorMessage
                        )
                        logFailureResponse(
                            PAYU_REMOVE_ACCOUNT,
                            errorCode,
                            errorMessage ?: "",
                            Utils.getTimeDifferenceInMilliSeconds(fnCalledTime),
                            referenceId = referenceId
                        )
                        callback.onPayUFailure(response)
                    }
                }
            )
        }
    }

    override fun deregister(callback: PayUUPIBoltCallBack) {
        ifAxisDependencyExist(PayUResponseTypes.REQUEST_GET_CUSTOMER_deregister_V3, callback) {
            logPayUFunctionsRequest(
                REQUEST_GET_CUSTOMER_deregister_V3,
                "",
                referenceId = referenceId
            )
            val fnCalledTime = System.currentTimeMillis()
            payuStartTimeMap[PAYU_DEREGISTER_ACCOUNTS] = fnCalledTime
            validateSDKSession(
                REQUEST_GET_CUSTOMER_deregister_V3,
                object : UpiInitiateCallback {
                    override fun onSDKSuccess() {
                        callBack[PayUResponseTypes.PAYU_CALLBACK_KEY] = callback
                        currentRequestType = PayUResponseTypes.REQUEST_GET_CUSTOMER_deregister_V3
                        axisStartTimeMap[PAYU_DEREGISTER_ACCOUNTS] = System.currentTimeMillis()
                        oliveUpiManager?.deRegister()
                    }

                    override fun onSdKError(errorCode: Int, errorMessage: String?) {
                        val response = PayUUPIBoltResponse(
                            REQUEST_GET_CUSTOMER_deregister_V3,
                            errorCode,
                            errorMessage
                        )
                        logFailureResponse(
                            PAYU_DEREGISTER_ACCOUNTS,
                            errorCode,
                            errorMessage ?: "",
                            Utils.getTimeDifferenceInMilliSeconds(fnCalledTime),
                            referenceId = referenceId
                        )
                        callback.onPayUFailure(response)
                    }
                }
            )
        }
    }

    override fun changeMPIN(accountDetail: PayUAccountDetail, callback: PayUUPIBoltCallBack) {
        ifAxisDependencyExist(PayUResponseTypes.REQUEST_GET_CHANGE_MPIN, callback) {
            logPayUFunctionsRequest(
                REQUEST_GET_CHANGE_MPIN,
                prepareJsonFromAccount(accountDetail).toString(),
                referenceId = referenceId
            )
            val fnCalledTime = System.currentTimeMillis()
            payuStartTimeMap[PAYU_REQUEST_GET_CHANGE_MPIN] = fnCalledTime
            validateSDKSession(REQUEST_GET_CHANGE_MPIN, object : UpiInitiateCallback {
                override fun onSDKSuccess() {
                    axisStartTimeMap[PAYU_REQUEST_GET_CHANGE_MPIN] = System.currentTimeMillis()
                    if (accountDetail.mbeba == PayUUpiConstant.PAYU_VALUE_Y
                        && accountDetail.vpa.isNullOrEmpty().not()) {
                        val account = AxisTransformerUtils.getAccount(accountDetail)
                        callBack[PayUResponseTypes.PAYU_CALLBACK_KEY] = callback
                        currentRequestType = PayUResponseTypes.REQUEST_GET_CHANGE_MPIN
                        val requestJSONObject = prepareJsonFromAccount(account)
                        requestJSONObject.put(PAYU_BANK_ID, accountDetail.bankId)
                        logAxisFunctionsRequest(
                            REQUEST_GET_CHANGE_MPIN,
                            requestJSONObject.toString(),
                            referenceId = referenceId
                        )
                        oliveUpiManager?.changeMpin(accountDetail.bankId, account)
                    } else {
                        val response = PayUUPIBoltResponse(
                            REQUEST_GET_CHANGE_MPIN,
                            PayUResponseCodes.PAYU_FAILED_STATUS,
                            PayUResponseMessages.PAYU_PIN_NOT_SET
                        )
                        logAxisFailureResponse(
                            UpiService.REQUEST_GET_CHANGE_MPIN,
                            response.code.toString(),
                            response.message ?: "",
                            referenceId = referenceId
                        )
                        callback.onPayUFailure(response)
                    }
                }

                override fun onSdKError(errorCode: Int, errorMessage: String?) {
                    val response = PayUUPIBoltResponse(
                        REQUEST_GET_CHANGE_MPIN,
                        errorCode, errorMessage
                    )
                    logFailureResponse(
                        PAYU_REQUEST_GET_CHANGE_MPIN,
                        response.code,
                        response.message ?: "",
                        Utils.getTimeDifferenceInMilliSeconds(fnCalledTime),
                        referenceId = referenceId
                    )
                    callback.onPayUFailure(response)
                }

            })
        }
    }

    override fun setVPA(
        vpa: String,
        accountDetail: PayUAccountDetail,
        callback: PayUUPIBoltCallBack
    ) {
        ifAxisDependencyExist(PayUResponseTypes.REQUEST_SAVE_ACCOUNT_V3, callback) {
            val jsonObject = prepareJsonFromAccount(accountDetail)
            jsonObject.put(PAYU_VPA, Utils.getMaskedString(vpa))
            logPayUFunctionsRequest(
                PayUResponseTypes.REQUEST_SAVE_ACCOUNT_V3,
                jsonObject.toString(),
                referenceId = referenceId
            )
            val fnCalledTime = System.currentTimeMillis()
            payuStartTimeMap[PAYU_REQUEST_SET_VPA] = fnCalledTime
            validateSDKSession(REQUEST_SAVE_ACCOUNT_V3, object : UpiInitiateCallback {
                override fun onSDKSuccess() {
                    val account = AxisTransformerUtils.getAccount(accountDetail)
                    callBack[PayUResponseTypes.PAYU_CALLBACK_KEY] = callback
                    currentRequestType = PayUResponseTypes.REQUEST_SAVE_ACCOUNT_V3
                    axisStartTimeMap[PAYU_REQUEST_SET_VPA] = System.currentTimeMillis()
                    val requestJSONObject = prepareJsonFromAccount(account)
                    requestJSONObject.put(PAYU_VPA, Utils.getMaskedString(vpa))
                    logAxisFunctionsRequest(
                        PayUResponseTypes.REQUEST_SAVE_ACCOUNT_V3,
                        requestJSONObject.toString(),
                        referenceId = referenceId
                    )
                    oliveUpiManager?.updateVPA(vpa, account)
                }

                override fun onSdKError(errorCode: Int, errorMessage: String?) {
                    val response = PayUUPIBoltResponse(
                        REQUEST_SAVE_ACCOUNT_V3,
                        errorCode, errorMessage
                    )
                    logFailureResponse(
                        PAYU_REQUEST_SET_VPA,
                        response.code,
                        response.message ?: "",
                        Utils.getTimeDifferenceInMilliSeconds(fnCalledTime),
                        referenceId = referenceId
                    )
                    callback.onPayUFailure(response)
                }

            })
        }
    }

    override fun fetchVPAProfile(vpa: String, callback: PayUUPIBoltCallBack) {
        val jsonObject = JSONObject()
        jsonObject.put(PAYU_VPA, Utils.getMaskedString(vpa))
        val fnCalledTime = System.currentTimeMillis()
        logPayUFunctionsRequest(
            REQUEST_GET_PROFilE_VPA_V3,
            jsonObject.toString(),
            referenceId = referenceId
        )
        payuStartTimeMap[PAYU_REQUEST_GET_VPA_PROFILE] = fnCalledTime
        validateSDKSession(REQUEST_GET_PROFilE_VPA_V3, object : UpiInitiateCallback {
            override fun onSDKSuccess() {
                callBack[PayUResponseTypes.PAYU_CALLBACK_KEY] = callback
                currentRequestType = PayUResponseTypes.REQUEST_GET_PROFilE_VPA_V3
                axisStartTimeMap[PAYU_REQUEST_GET_VPA_PROFILE] = System.currentTimeMillis()
                oliveUpiManager?.profileVpa(vpa)
            }

            override fun onSdKError(errorCode: Int, errorMessage: String?) {
                val response = PayUUPIBoltResponse(
                    REQUEST_GET_PROFilE_VPA_V3,
                    errorCode, errorMessage
                )
                logFailureResponse(
                    PAYU_REQUEST_GET_VPA_PROFILE,
                    response.code,
                    response.message ?: "",
                    Utils.getTimeDifferenceInMilliSeconds(fnCalledTime),
                    referenceId = referenceId
                )
                callback.onPayUFailure(response)
            }

        })
    }

    override fun saveVPA(
        vpa: String,
        name: String,
        nickName: String,
        callback: PayUUPIBoltCallBack
    ) {
        logPayUFunctionsRequest(
            REQUEST_SAVE_VPA_V3,
            prepareSaveVpaJson(vpa, nickName).toString(),
            referenceId = referenceId
        )
        val fnCalledTime = System.currentTimeMillis()
        payuStartTimeMap[PAYU_REQUEST_SAVE_VPA] = fnCalledTime
        validateSDKSession(REQUEST_SAVE_VPA_V3, object : UpiInitiateCallback {
            override fun onSDKSuccess() {
                callBack[PayUResponseTypes.PAYU_CALLBACK_KEY] = callback
                currentRequestType = PayUResponseTypes.REQUEST_SAVE_VPA_V3
                axisStartTimeMap[PAYU_REQUEST_SAVE_VPA] = System.currentTimeMillis()
                oliveUpiManager?.savevpa(vpa, name, nickName)
            }

            override fun onSdKError(errorCode: Int, errorMessage: String?) {
                val response = PayUUPIBoltResponse(
                    REQUEST_SAVE_VPA_V3,
                    errorCode, errorMessage
                )
                logFailureResponse(
                    PAYU_REQUEST_SAVE_VPA,
                    response.code,
                    response.message ?: "",
                    Utils.getTimeDifferenceInMilliSeconds(fnCalledTime),
                    referenceId = referenceId
                )
                callback.onPayUFailure(response)
            }

        })
    }

    override fun deleteVPA(vpa: String, callback: PayUUPIBoltCallBack) {

        val jsonObject = JSONObject()
        jsonObject.put(PAYU_VPA, Utils.getMaskedString(vpa))
        logPayUFunctionsRequest(
            REQUEST_GET_VPA_REMOVE_V3,
            jsonObject.toString(),
            referenceId = referenceId
        )

        val fnCalledTime = System.currentTimeMillis()
        payuStartTimeMap[PAYU_REQUEST_DELETE_VPA] = fnCalledTime
        validateSDKSession(
            REQUEST_GET_VPA_REMOVE_V3,
            object : UpiInitiateCallback {
                override fun onSDKSuccess() {
                    callBack[PayUResponseTypes.PAYU_CALLBACK_KEY] = callback
                    currentRequestType = PayUResponseTypes.REQUEST_GET_VPA_REMOVE_V3
                    axisStartTimeMap[PAYU_REQUEST_DELETE_VPA] = System.currentTimeMillis()
                    oliveUpiManager?.removevpa(vpa)
                }

                override fun onSdKError(errorCode: Int, errorMessage: String?) {
                    val response = PayUUPIBoltResponse(
                        REQUEST_GET_VPA_REMOVE_V3,
                        errorCode, errorMessage
                    )
                    logFailureResponse(
                        PAYU_REQUEST_DELETE_VPA,
                        response.code,
                        response.message ?: "",
                        Utils.getTimeDifferenceInMilliSeconds(fnCalledTime),
                        referenceId = referenceId
                    )
                    callback.onPayUFailure(response)
                }

            })
    }

    override fun fetchRegisteredVPAList(callback: PayUUPIBoltCallBack) {
        logPayUFunctionsRequest(REQUEST_GET_VPA_V3, "", referenceId = referenceId)
        val fnCalledTime = System.currentTimeMillis()
        payuStartTimeMap[PAYU_REQUEST_REGISTERED_VPA] = fnCalledTime
        validateSDKSession(REQUEST_GET_VPA_V3, object : UpiInitiateCallback {
            override fun onSDKSuccess() {
                callBack[PayUResponseTypes.PAYU_CALLBACK_KEY] = callback
                currentRequestType = PayUResponseTypes.REQUEST_GET_VPA_V3
                axisStartTimeMap[PAYU_REQUEST_REGISTERED_VPA] = System.currentTimeMillis()
                oliveUpiManager?.fetchVPAList()
            }

            override fun onSdKError(errorCode: Int, errorMessage: String?) {
                val response = PayUUPIBoltResponse(
                    REQUEST_GET_VPA_V3,
                    errorCode, errorMessage
                )
                logFailureResponse(
                    PAYU_REQUEST_REGISTERED_VPA,
                    response.code,
                    response.message ?: "",
                    Utils.getTimeDifferenceInMilliSeconds(fnCalledTime),
                    referenceId = referenceId
                )
                callback.onPayUFailure(response)
            }

        })
    }

    override fun pay(
        paymentParams: PayUUPIBoltPaymentParams,
        callback: PayUUPIBoltCallBack
    ) {
        ifAxisDependencyExist(PayUResponseTypes.REQUEST_PAY, callback) {
            val fnCalledTime = System.currentTimeMillis()
            validateSDKSession(PayUResponseTypes.REQUEST_PAY, object : UpiInitiateCallback {
                override fun onSDKSuccess() {
                    currentRequestType = PayUResponseTypes.REQUEST_PAY
                    initPayment(paymentParams, callback, fnCalledTime)
                }

                override fun onSdKError(errorCode: Int, errorMessage: String?) {
                    val response = PayUUPIBoltResponse(
                        PayUResponseTypes.REQUEST_PAY,
                        errorCode, errorMessage
                    )
                    logFailureResponse(
                        PayUUpiConstant.PAYU_REQUEST_PAY,
                        response.code,
                        response.message ?: "",
                        Utils.getTimeDifferenceInMilliSeconds(fnCalledTime),
                        paymentParams.txnId,
                        referenceId = referenceId,
                        amount = paymentParams.amount
                    )
                    callback.onPayUFailure(response)
                }
            })
        }
    }

    override fun raiseQuery(
        txnId: String,
        txnRefId: String?,
        amount: Double,
        query: String,
        queryType: String?,
        callback: PayUUPIBoltCallBack
    ) {
        ifAxisDependencyExist(PayUResponseTypes.REQUEST_GET_RAISE_QUERY_V3, callback) {
            logPayUFunctionsRequest(
                REQUEST_GET_RAISE_QUERY_V3,
                prepareQueryRequestJson(txnId, txnRefId ?: "", amount, query).toString(),
                referenceId = referenceId
            )
            val fnCalledTime = System.currentTimeMillis()
            payuStartTimeMap[PAYU_REQUEST_RAISE_QUERY] = fnCalledTime
            validateSDKSession(
                REQUEST_GET_RAISE_QUERY_V3,
                object : UpiInitiateCallback {
                    override fun onSDKSuccess() {
                        callBack[PayUResponseTypes.PAYU_CALLBACK_KEY] = callback
                        currentRequestType = PayUResponseTypes.REQUEST_GET_RAISE_QUERY_V3
                        axisStartTimeMap[PAYU_REQUEST_RAISE_QUERY] = System.currentTimeMillis()
                        oliveUpiManager?.raiseQuery(txnId, txnRefId, amount, query)
                    }

                    override fun onSdKError(errorCode: Int, errorMessage: String?) {
                        val response = PayUUPIBoltResponse(
                            REQUEST_GET_RAISE_QUERY_V3,
                            errorCode, errorMessage
                        )
                        logFailureResponse(
                            PAYU_REQUEST_RAISE_QUERY,
                            response.code,
                            response.message ?: "",
                            Utils.getTimeDifferenceInMilliSeconds(fnCalledTime),
                            referenceId = referenceId
                        )
                        callback.onPayUFailure(response)
                    }
                }
            )
        }
    }

    override fun fetchQueryList(callback: PayUUPIBoltCallBack) {
        ifAxisDependencyExist(PayUResponseTypes.REQUEST_LIST_QUERIES_V3, callback) {
            logPayUFunctionsRequest(REQUEST_LIST_QUERIES_V3, "", referenceId = referenceId)
            val fnCalledTime = System.currentTimeMillis()
            payuStartTimeMap[PAYU_REQUEST_QUERY_LIST] = fnCalledTime
            validateSDKSession(REQUEST_LIST_QUERIES_V3, object : UpiInitiateCallback {
                override fun onSDKSuccess() {
                    callBack[PayUResponseTypes.PAYU_CALLBACK_KEY] = callback
                    currentRequestType = PayUResponseTypes.REQUEST_LIST_QUERIES_V3
                    axisStartTimeMap[PAYU_REQUEST_QUERY_LIST] = System.currentTimeMillis()
                    oliveUpiManager?.queryList()
                }

                override fun onSdKError(errorCode: Int, errorMessage: String?) {
                    val response = PayUUPIBoltResponse(
                        REQUEST_LIST_QUERIES_V3,
                        errorCode, errorMessage
                    )
                    logFailureResponse(
                        PAYU_REQUEST_QUERY_LIST,
                        response.code,
                        response.message ?: "",
                        Utils.getTimeDifferenceInMilliSeconds(fnCalledTime),
                        referenceId = referenceId
                    )
                    callback.onPayUFailure(response)
                }
            })
        }
    }

    override fun fetchQueryTypeList(txnRefId: String?, callback: PayUUPIBoltCallBack) {
        callback.onPayUSuccess(
            PayUUPIBoltResponse(
                PayUResponseTypes.REQUEST_QUERY_TYPE_LIST,
                PayUResponseCodes.PAYU_SUCCESS_STATUS,
                null, null
            )
        )
    }

    override fun fetchTransactionHistory(
        fromDate: String,
        toDate: String,
        callback: PayUUPIBoltCallBack
    ) {
        ifAxisDependencyExist(PayUResponseTypes.REQUEST_GET_TRANSACTION_HISTORY_V3, callback) {
            logPayUFunctionsRequest(
                REQUEST_GET_TRANSACTION_HISTORY_V3,
                txnHistoryRequestJson(fromDate, toDate).toString(),
                referenceId = referenceId
            )
            val fnCalledTime = System.currentTimeMillis()
            payuStartTimeMap[PAYU_REQUEST_TXN_HISTORY] = fnCalledTime
            validateSDKSession(
                REQUEST_GET_TRANSACTION_HISTORY_V3,
                object : UpiInitiateCallback {
                    override fun onSDKSuccess() {
                        callBack[PayUResponseTypes.PAYU_CALLBACK_KEY] = callback
                        currentRequestType = PayUResponseTypes.REQUEST_GET_TRANSACTION_HISTORY_V3
                        axisStartTimeMap[PAYU_REQUEST_TXN_HISTORY] = System.currentTimeMillis()
                        oliveUpiManager?.tranHistory(fromDate, toDate)
                    }

                    override fun onSdKError(errorCode: Int, errorMessage: String?) {
                        val response = PayUUPIBoltResponse(
                            REQUEST_GET_TRANSACTION_HISTORY_V3,
                            errorCode, errorMessage
                        )
                        logFailureResponse(
                            PAYU_REQUEST_TXN_HISTORY,
                            response.code,
                            response.message ?: "",
                            Utils.getTimeDifferenceInMilliSeconds(fnCalledTime),
                            referenceId = referenceId
                        )
                        callback.onPayUFailure(response)
                    }
                }
            )
        }
    }

    override fun addAccount(accountDetail: PayUAccountDetail, callback: PayUUPIBoltCallBack) {
        callback.onPayUFailure(
            PayUUPIBoltResponse(
                PayUResponseTypes.REQUEST_ADD_ACCOUNT,
                PayUResponseCodes.PAYU_FAILED_STATUS, PayUResponseMessages.PAYU_METHOD_NOT_SUPPORTED
            )
        )
    }
}