package com.payu.upibolt.payUHDFCImpl

import android.content.Context
import android.os.Handler
import android.os.Looper
import com.payu.commonmodelssdk.constants.PayUUpiConstant
import com.payu.commonmodelssdk.listeners.ApiBaseCallback
import com.payu.commonmodelssdk.listeners.ApiCallbacks
import com.payu.commonmodelssdk.model.PayUNetworkData
import com.payu.commonmodelssdk.model.PgDetailsRequest
import com.payu.upibolt.network.HttpApiCall
import com.payu.upibolt.utils.InternalConfig
import com.payu.upibolt.utils.UpiAuthHeaderHelper
import org.json.JSONException
import org.json.JSONObject


class HDFCAuthTokenTask(
    private val context: Context
) : ApiCallbacks {
    override fun callApi(
        params: Any,
        isProd: Boolean,
        callback: ApiBaseCallback
    ) {
        val pgDetailsReq = params as PgDetailsRequest

        if (pgDetailsReq.hash.isNullOrEmpty().not()) {
            val networkData = getNetworkData(pgDetailsReq, isProd)
            invokeTokenRequest(networkData, callback)
        } else {
            val handler = Handler(Looper.getMainLooper())
            val runnable = Runnable {
                callback.onApiError(
                    com.payu.commonmodelssdk.constants.PayUResponseCodes.HASH_NOT_RECEIVED_CODE,
                    com.payu.commonmodelssdk.constants.PayUResponseMessages.HASH_NOT_RECEIVED
                )
            }
            handler.post(runnable)
        }
    }

    private fun invokeTokenRequest(networkData: PayUNetworkData, callback: ApiBaseCallback) {
        HttpApiCall(context).makePostAPICall("", PayUUpiConstant.PAYU_GET, networkData, object :
            com.payu.commonmodelssdk.listeners.PayUAsyncTaskResponse {
            override fun onSuccess(response: Any) {
                val handler = Handler(Looper.getMainLooper())
                try {
                        val jsonObject = JSONObject(response.toString())
                        val authTokenJsonObject = jsonObject.getJSONObject(PayUUpiConstant.PAYU_RESULT)

                            val runnable = Runnable {
                                callback.onApiSuccess(authTokenJsonObject)
                            }
                            handler.post(runnable)
                } catch (e: JSONException) {
                    authTokenError()
                }
            }

            private fun authTokenError() {
                errorCallBack(
                    com.payu.commonmodelssdk.constants.PayUResponseCodes.PAYU_FAILED_STATUS,
                    com.payu.commonmodelssdk.constants.PayUResponseMessages.PAYU_AUTH_TOKEN_INVALID_MESSAGE)
            }

            override fun onFailure(errorCode: Int, errorMessage: String) {
                errorCallBack(errorCode, errorMessage)
            }

            private fun errorCallBack(errorCode: Int, errorMessage: String) {
                val handler = Handler(Looper.getMainLooper())
                val runnable = Runnable {
                    callback.onApiError(errorCode, errorMessage)
                }
                handler.post(runnable)
            }
        })
    }

    private fun getNetworkData(
        pgDetailsRequest: PgDetailsRequest,
        isProd: Boolean
    ): PayUNetworkData {
        val url = if (isProd)
          PayUUpiConstant.PAYU_AUTH_TOKEN_PROD_URL
        else
            PayUUpiConstant.PAYU_AUTH_TOKEN_TEST_URL
        val headerMap = UpiAuthHeaderHelper.getAuthHeader(
            pgDetailsRequest.hash ?: "",
            pgDetailsRequest.merchantKey
        )
        headerMap[PayUUpiConstant.DEVICE_INFO] = getDeviceInfo()
        return PayUNetworkData(
            url,
            getRequest = HashMap(),
            headerMap = headerMap,
            contentType = PayUUpiConstant.APPLICATION_JSON
        )
    }
    private fun getDeviceInfo(): String {
        return "${InternalConfig.mobile}|${InternalConfig.appId}"
    }
}