package com.payu.upibolt.payUHDFCImpl

import android.content.Context
import com.payu.commonmodelssdk.constants.PayUResponseCodes
import com.payu.commonmodelssdk.constants.PayUResponseMessages
import com.payu.commonmodelssdk.constants.PayUUpiConstant
import com.payu.commonmodelssdk.enums.UpiHashCommand
import com.payu.commonmodelssdk.listeners.ApiBaseCallback
import com.payu.commonmodelssdk.listeners.PayUHashGeneratedListener
import com.payu.commonmodelssdk.model.PgDetailsRequest
import com.payu.upibolt.models.PayUUPIBoltConfig
import com.payu.upibolt.utils.InternalConfig
import com.payu.upibolt.utils.UpiAuthHeaderHelper
import org.json.JSONObject

class PayuHDFCAuthTokenManager(
    private val context: Context,
    private val sdkInitParams: PayUUPIBoltConfig,
    private val pgDetails: PgDetailsRequest,
    private val onSuccess: (authToken: String, isRefresh: Boolean) -> Unit,
    private val onFailure: (errorCode: Int, errorMessage: String) -> Unit
) {

    init {
        val hashMap = UpiAuthHeaderHelper.getUPIHashString(
            UpiHashCommand.HDFCAuthToken, null,
            sdkInitParams.merchantKey, sdkInitParams.email
        )
        InternalConfig.payUHashGenerationListener?.generateHash(hashMap,
            object : PayUHashGeneratedListener {
                override fun onHashGenerated(map: HashMap<String, String?>) {
                    val hashName = map[PayUUpiConstant.HASH_NAME]
                    val hash = map[hashName]
                    if (!hash.isNullOrEmpty()) {
                        pgDetails.hash = hash
                        HDFCAuthTokenTask(context).callApi(
                            pgDetails,
                            sdkInitParams.isProduction,
                            object :
                                ApiBaseCallback {
                                override fun onApiSuccess(response: Any) {
                                    val jsonObject = response as JSONObject
                                    val authToken = jsonObject.optString("access_token")
                                    val authTokenExpiry = jsonObject.optLong("expires_in")
                                    if(authToken.isNullOrEmpty().not() && authTokenExpiry > 0) {
                                        val isRefresh = InternalConfig.authTokenExpiryTime > 0
                                        onSuccess.invoke(authToken, isRefresh)
                                        InternalConfig.authTokenExpiryTime =
                                            System.currentTimeMillis() + ((authTokenExpiry - 10) * 1000)
                                    } else {
                                        onFailure.invoke(
                                            PayUResponseCodes.PAYU_FAILED_STATUS,
                                            PayUResponseMessages.PAYU_AUTH_TOKEN_INVALID_MESSAGE
                                        )
                                    }
                                }

                                override fun onApiError(errorCode: Int, errorMessage: String) {
                                    onFailure.invoke(errorCode, errorMessage)
                                }
                            }
                        )
                    }
                }
            }
        )
    }
}