package com.payu.upibolt.utils

import com.payu.commonmodelssdk.enums.PluginType
import com.payu.commonmodelssdk.listeners.PayUHashGenerationListener
import com.payu.commonmodelssdk.model.PgDetails
import com.payu.upibolt.models.PayUUPIBoltConfig
import okhttp3.Call


internal object InternalConfig {
    // init params - not to be cleared in deInit
    var pgDetails: PgDetails? = null
    var payUHashGenerationListener: PayUHashGenerationListener? = null
    var appId: String? = null
    var config: PayUUPIBoltConfig? = null

    // non init params
    var bankName: String? = null
    val activeApiCalls = ArrayList<Call?>()
    var mobile : String? = null
        get() = Utils.formatMobileNumber(field ?: "")
    var subscriptionId: String? = null
    var handshakeId: String? = null
    var paymentTxnId: String? = null
    var pluginType: PluginType? = null
    var merchantKey : String ? = null
    var authTokenExpiryTime : Long = 0

    fun clearNonInitParams() {
        bankName = null
        activeApiCalls.clear()
        mobile = null
        subscriptionId = null
        handshakeId = null
        paymentTxnId = null
        authTokenExpiryTime = 0
    }

    fun clearAll() {
        clearNonInitParams()
        pgDetails = null
        payUHashGenerationListener = null
        appId = null
        config = null
        pluginType = null
    }
}