package com.payu.threedsbase.constants

import androidx.annotation.Keep

@Keep
class APIConstants {
    @Keep
    companion object {
        const val STATUS = "status"
        const val ERROR = "error"
        const val ERROR_MESSAGE = "errorMessage"
        const val BIN_INFO_API_DATA = "data"
        const val BIN_INFO_BINS_DATA = "bins_data"
        const val BIN_INFO_CARD_TYPE = "card_type"
        const val BIN_INFO_ERROR_MESSAGE = "msg"

        const val BIN_INFO_IS_ATMPIN_CARD = "is_atmpin_card"
        const val BIN_INFO_IS_DOMESTIC = "is_domestic"
        const val BIN_INFO_ISSUING_BANK = "issuing_bank"
        const val BIN_INFO_BIN = "bin"
        const val BIN_INFO_CATEGORY = "category"
        const val BIN_INFO_IS_OTP_ON_THE_FLY = "is_otp_on_the_fly"
        const val BIN_INFO_IS_SI_SUPPORTED = "is_si_supported"
        const val BIN_INFO_MESSAGE_VERSION = "messageVersion"
        const val PAYMENT_API_RESULT = "result"
        const val PAYMENT_API_POST_TO_BANK = "postToBank"
        const val PAYMENT_API_META_DATA = "metaData"
        const val PAYMENT_API_ERROR_MESSAGE = "message"
        const val STATUS_CODE = "statusCode"

        const val CAVV = "cavv"
        const val ECI = "eci"
        const val THREE_DS_TRANS_ID = "threeDSTransID"
        const val THREE_DS_VERSION = "threeDSVersion"
        const val THREE_DS_SERVER_TRANS_ID = "threeDSServerTransID"
        const val THREE_DS_TRANS_STATUS = "threeDSTransStatus"
        const val ACS_SIGNED_CONTENT = "acsSignedContent"
        const val ACS_REFERENCE_NUMBER = "acsReferenceNumber"
        const val ACS_TRANS_ID = "acsTransID"
        const val THREE_DS_TRANS_STATUS_REASON = "threeDSTransStatusReason"

        const val HASH_ERROR_CODE = "EX087"
        const val PAYMENT_SUCCESS_CODE = "E000"

        const val LOCALE = "en_us"
        const val APPLICATION_JSON = "application/json"
        const val HEADER_ACCEPT = "accept"
        const val ACCEPT_CHARSET = "Accept-Charset"
        const val ACCEPT_CHARSET_VALUE = "UTF-8"
        const val APPLICATION_FORM_URL_ENCODED = "application/x-www-form-urlencoded"
        const val HTTP_REQUEST_TYPE_GET = "GET"
        const val HTTP_REQUEST_TYPE_POST = "POST"
        const val SECURE_URL = "https://secure.payu.in/_payment"
        const val INFO_URL = "https://info.payu.in/merchant/postservice.php?form=2"
        const val UAT_SECURE_URL = "https://test.payu.in/_payment"
        const val UAT_INFO_URL = "https://apitest.payu.in/merchant/postservice.php?form=2"

        const val AUTHORIZATION_PAYMENT_URL = "https://secure.payu.in/AuthorizeTransaction.php"
        const val UAT_AUTHORIZATION_PAYMENT_URL = "https://test.payu.in/AuthorizeTransaction.php"
        const val AUTHENTICATION_PAYMENT_URL = "https://secure.payu.in/decoupled/AuthData"
        const val UAT_AUTHENTICATION_PAYMENT_URL = "https://test.payu.in/decoupled/AuthData"


        const val UAT_TERM_URL_VALUE = "https://acssimuat.payubiz.in/termUrl/DecoupledResponse"
        const val BIN_INFO_VAR7_VALUE = "2.2.0"
        const val AUTHENTICATION_INFO = "authentication_info"
        const val AUTHENTICATION_INFO_VALUE = "[]"

        const val AUTH_ONLY = "auth_only"
        const val AUTH_WITH_PAYU = "1"
        const val AUTH_OUTSIDE_PAYU = "2"
        const val TERM_URL = "termUrl"
        const val TERM_URL_VALUE = "https://acssimuat.payubiz.in/termUrl/DecoupledResponse"
        const val THREE_DS_VERSION_VALUE = "2."
        const val TXN_S2S_FLOW = "txn_s2s_flow"
        const val TXN_S2S_FLOW_VALUE = "4"

        const val CB_URL = "https://cbjs.payu.in/js/sdk_js/v3/"

        const val MERCHANT_RESPONSE_TIMEOUT_INTERVAL = 1000L
        const val OTP = "otp"
        const val FILL_OTP = "fillOTP"
        const val WIBMO_SDK_MAX_TIMEOUT = "05"


        const val BIN_INFO_VAR1_VALUE = "1"
        const val BIN_INFO_VAR5_VALUE = "1"
        const val POST_DATA = "postData"
        const val TLS_V1_2 = "TLSv1.2"
        const val TLS_V1_1 = "TLSv1.1"
        const val TLS_V1 = "TLSv1"
        const val TLS = "TLS"

        const val JS_EXTENSION = ".js"
        const val INITIAILIZE = "initialize"
        const val WEBVIEW_INTERFACE = "PayU"
        const val MERCHANT_RESPONSE = "merchantResponse"
        const val PAYU_RESPONSE = "payUResponse"
        const val CHALLENGE_SUCCESS_VALUE = "Y"
        const val FAILURE = "FAILURE"
        const val SUCCESS = "SUCCESS"
        const val REFERENCE_ID = "referenceId"
        const val ACS_TEMPLATE = "acsTemplate"
        const val TEXT_HTML = "text/html; charset=utf-8"
        const val UTF_8 = "UTF-8"
        const val SUCCESS_API_CODE = 200

        const val ACS_TXN_ID = "acsTransactionID"
        const val ACS_RENDERING_TYPE = "acsRenderingType"
        const val OTP_CHALLENGE_DATA = "challengeData"
        const val CHECK_SUBMIT_BUTTON_AVAILABILITY = "checkOTPFieldAndSubmitButtonAvailability"
        const val SUBMIT_OTP = "submitOTP"
        const val AUTO_READ = "autoRead"
        const val AUTO_SUBMIT = "autoSubmit"
        const val HAS_SUBMIT_BUTTON = "hasSubmitButton"
        const val SURL = "surl"
        const val FURL = "furl"
        const val MERCHANT_RESPONSE_TIMEOUT = "merchantResponseTimeout"

    }

}

