package com.payu.threedsbase.constants

import androidx.annotation.Keep

@Keep
class PayU3DS2ErrorConstants {
    @Keep
    companion object {
        const val SDK_RESPONSE_STATUS_CODE_0 = 0
        const val SDK_RESPONSE_STATUS_CODE_1 = 1
        const val SDK_NOT_INITIALIZED_ERROR_MESSAGE =
            "SDK not initialized, please call initialise method first"
        const val WIBMO_TRANSACTION_NOT_CREATED_ERROR_CODE = 2
        const val WIBMO_TRANSACTION_NOT_CREATED_ERROR_MESSAGE =
            "Error while creating transaction to generate device details, please try again."
        const val SDK_ALREADY_INITIALIZED_ERROR_MESSAGE = "SDK already initialised."
        const val CHALLENGE_TIMEDOUT_ERROR_CODE = 3
        const val CHALLENGE_TIMEDOUT_ERROR_MESSAGE = "Time out"
        const val CHALLENGE_PROTOCOL_ERROR_CODE = 4
        const val CHALLENGE_CANCEL_ERROR_CODE = 5
        const val CHALLENGE_RUNTIME_ERROR_CODE = 6
        const val GATEWAY_TIMEOUT_ERROR_CODE = 504
        const val SOMETHING_WENT_WRONG_ERROR_CODE = 500
        const val GATEWAY_TIMEOUT_ERROR_MESSAGE = "Gateway timeout."
        const val CARD_BIN_NULL_ERROR_MESSAGE = "Card details cannot be null or empty"
        const val MERCHANT_KEY_CANNOT_BE_NULL = "Merchant key cannot be null or empty"
        const val TXN_ID_CANNOT_BE_NULL = "Transaction id cannot be null or empty"
        const val AMOUNT_ERROR_MESSAGE = "Amount should be a Double value example 5.00"
        const val SOMETHING_WENT_WRONG_ERROR_MESSAGE = "Something went wrong, please try again"
        const val CARD_NOT_SUPPORTED_ON_3DS2 = "Card is not supported on 3DS2.0 flow"
        const val NO_INTERNET_ERROR = "No Internet"
        const val CANCEL_TRANSACTION_ERROR_MESSAGE =
            "User cancelled it, please verify with your server."

        const val BIN_INFO_API_CARD_BIN_ERROR_CODE = 101
        const val MERCHANT_KEY_ERROR_CODE = 102
        const val TXN_AMOUNT_ERROR_CODE = 103
        const val TXN_ID_ERROR_CODE = 104
        const val HASH_NULL_ERROR_CODE = 105
        const val BIN_INFO_API_CARD_NOT_SUPPORTED_ERROR_CODE = 106
        const val CARD_SCHEME_NOT_SUPPORTED_ERROR_CODE = 107
        const val HASH_ISSUE_ERROR_CODE = 108
        const val HASH_ISSUE_ERROR_MESSAGE = "Please check hash"
        const val REQUEST_BODY_CANNOT_BE_NULL = "Request body missing"
        const val REST_API_PATH_CANNOT_BE_NULL = "API endpoint path missing"
        const val USER_CANCELLED_ERROR_MESSAGE = "User cancelled the transaction"
        const val TRANSACTION_FAILED = "Transaction failed"
        const val REQUEST_ID_CANNOT_BE_NULL = "Request Id cannot be null or empty"
        const val SCHEME_NOT_RECOGNISED_ERROR_MESSAGE =
            "Scheme not recognised, please try with VISA or MASTERCARD."
        const val HASH_NULL_ERROR_MESSAGE = "Hash cannot be null"
        const val SOMETHING_WENT_WRONG = SOMETHING_WENT_WRONG_ERROR_MESSAGE
        const val HASH_TIMED_OUT = "Hash not received"
        const val CARD_SCHEME_OR_THREE_DS_VERSION_NULL =
            "Card scheme or ThreeDS version cannot be null"
        const val ERROR_WHILE_LOADING_PAGE = "Error while loading web page please try again"

        const val ACTION_TYPE_NULL = "Invalid or null action type"
        const val ACS_ACTION_PARAMS_NULL = "ACS action params cannot be null"
        const val ACS_TXN_ID_NULL = "ACS txn id cannot be null"
        const val ACS_RENDERING_TYPE_NULL = "ACS rendering type cannot be null"
        const val ACS_OTP_DATA_NULL = "OTP cannot be null"
        const val WIBMO_TRANSACTION_NULL =
            "Error while executing the action, transaction details not found. Please try again"

        /**
         * Added here instead of creating a new file because of we don't send success message and there
         * is no sense of creating a whole new file
         */
        const val OTP_RESENT_SUCCESSFULLY = "Resend OTP successful"
        const val OTP_RESEND_LIMIT_EXCEEDED = "Resend OTP limit exceeded"

        const val ACTION_TYPE_NULL_ERROR_CODE = 11
        const val ACS_ACTION_PARAMS_NULL_ERROR_CODE = 12
        const val ACS_ACTION_ERROR_CODE = 13
        const val ACS_OTP_RESEND_LIMIT_EXCEEDED = 14
        const val ACS_INVALID_OTP_SUBMIT = 15
        const val ACS_TXN_CANCELLED = 16
        const val ACS_OTP_SUBMISSION_FAILED = 17
        const val ACTION_API_TIMEOUT = 18

        const val WIBMO_ACS_ERROR_CODE_001 = "001"
        const val WIBMO_ACS_ERROR_CODE_002 = "002"
        const val WIBMO_ACS_ERROR_CODE_003 = "003"
        const val WIBMO_ACS_ERROR_CODE_004 = "004"
        const val INVALID_AMOUNT = "Invalid Amount"
        const val INVALID_MERCHANT_NAME = "Invalid Merchant Name"
        const val ACS_DATA_MISSING = "Post data and ACS Template missing"
        const val SURL_MISSING = "SURL cannot be null"
        const val FURL_MISSING = "FURL cannot be null"

    }
}