package com.payu.threedsbase.data

import android.app.Activity
import com.payu.paymentparamhelper.HashCommand
import com.payu.paymentparamhelper.PaymentParams
import com.payu.threedsbase.config.PayU3DS2BaseConfig
import com.payu.threedsbase.data.apiRequest.CardBinInfoRequest
import com.payu.threedsbase.enums.CardScheme
import com.payu.threedsbase.interfaces.listeners.FallbackPostDataListener
import com.payu.threedsbase.interfaces.listeners.PayU3DS2BaseCallback
import com.payu.threedsbase.interfaces.listeners.PayU3DS2Callback

abstract class BaseApiLayer(config: PayU3DS2BaseConfig) {


    var config: PayU3DS2BaseConfig = PayU3DS2BaseConfig()
    var paymentParams: PaymentParams = PaymentParams()

    init {
        this.config = config
    }

    abstract fun fetchBinInfo(
        cardBinInfoRequest: CardBinInfoRequest,
        callback: PayU3DS2Callback
    )

    abstract fun initiatePayment(callback: PayU3DS2Callback)
    abstract fun authorizePayment(callback: PayU3DS2Callback)
    abstract fun getBankJS(url: String)
    abstract fun isFallbackAllowed(): Boolean
    abstract fun extractDeviceDetails(
        cardData: CardData
    ): PayU3DS2Response

    abstract fun initiateChallenge(
        activity: Activity,
        challengeParameter: ChallengeParameter,
        baseCallback: PayU3DS2BaseCallback
    )

    abstract fun initialise3DSService(activity: Activity): PayU3DS2Response
    abstract fun setContext(activity: Activity)
    abstract fun updatePaymentParamsWithSDKInfo(pArqResponse: PArqResponse)
    abstract fun generateFallbackPostData(
        hashCommand: HashCommand,
        callback: PayU3DS2Callback,
        fallbackPostDataListener: FallbackPostDataListener
    )

    abstract fun clean()
    abstract fun logData(key: String, msg: String)
    abstract fun isAuthenticationOnly(): Boolean
    abstract fun authenticatePayment(callback: PayU3DS2Callback)
    abstract fun showAutoReadBottomSheet(
        activity: Activity,
        hasSubmitButton: Boolean,
        isAutoSubmit: Boolean,
        submitListener: (String?) -> Unit
    )

    abstract fun setOTP(otp: String)
    abstract fun dismissBottomSheet()

}