package com.payu.threeDS2.utils

import android.app.Activity
import com.wibmo.threeds2.sdk.BottomSheetCallBack
import com.wibmo.threeds2.sdk.cfg.UiCustomization
import com.wibmo.threeds2.sdk.impl.WibmoUiHelper
import com.wibmo.threeds2.sdk.ui.WibmoOTPBottomSheet

object BottomSheetHelper : BottomSheetCallBack {
    private var wibmoOTPBottomSheet: WibmoOTPBottomSheet? = null
    private var submitListener: ((String?) -> Unit)? = null
    private var activity: Activity? = null
    fun showBottomSheet(
        activity: Activity,
        isAutoSubmit: Boolean,
        uiCustomization: UiCustomization,
        submitListener: (String?) -> Unit
    ) {
        this.submitListener = submitListener
        this.activity = activity
        wibmoOTPBottomSheet = null
        wibmoOTPBottomSheet = WibmoUiHelper.getBottomSheet(
            activity, uiCustomization, false, isAutoSubmit, this
        )
        wibmoOTPBottomSheet?.setAutoReadEnabled(true)


    }

    /**
     * DONOT WRITE ANYTHING INSIDE THIS
     */
    override fun setOTPValue(otp: String) {

    }

    fun setOTP(otp: String) {
        wibmoOTPBottomSheet?.let { it.onOtpReceived(otp) }
    }

    override fun onSubmitClicked(otp: String) {
        submitListener?.invoke(otp)
        dismissBottomSheet()
    }

    override fun onResendClicked() {
    }

    /**
     * DONOT WRITE ANYTHING INSIDE THIS
     */
    override fun onOTPAutoRead() {
    }

    //after time to auto submit is completed i will get callback here
    override fun onOTPSubmit() {
        submitListener?.invoke("")
        dismissBottomSheet()
    }

    fun dismissBottomSheet() {
        wibmoOTPBottomSheet?.let {
            it.dismissBottomDialog()
            wibmoOTPBottomSheet = null
        }
    }
}