package com.payu.threeDS2.config

import com.payu.threedsbase.config.PayU3DS2BaseConfig
import com.payu.threedsbase.enums.PayUCurrency
import com.payu.threedsui.uiCustomisation.UICustomisation

class PayU3DS2Config : PayU3DS2BaseConfig() {
    var fallback3DS1: Boolean = false
    var uiCustomisation: UICustomisation? = null
    var authenticateOnly: Boolean = false
    var autoRead: Boolean = false
    var autoSubmit: Boolean = false
    var supportedUIMode: ArrayList<String>? = null
    internal var defaultProgressLoaderColor: String? = null
    internal var showDefaultLoader: Boolean = false

    var merchantName: String? = null
    var amount: String? = null
    var currency: PayUCurrency = PayUCurrency.INR

    var enableCustomizedOtpUIFlow: Boolean = false
    var enableTxnTimeoutTimer: Boolean = false

    var acsContentConfig: ACSContentConfig? = null
    var enableMFAViaBiometric: Boolean = false

    /**
     * if this value is passed by merchant we will show custom progress instead of full screen PayU progress
     */
    fun setDefaultProgressLoader(
        showDefaultLoader: Boolean?,
        defaultProgressLoaderColor: String? = null
    ) {
        this.showDefaultLoader = showDefaultLoader ?: false
        this.defaultProgressLoaderColor = defaultProgressLoaderColor
    }

    override fun toString(): String {
        return "PayU3DS2Config(fallback3DS1=$fallback3DS1" +
                ",authenticateOnly=$authenticateOnly, autoRead=$autoRead," +
                "autoSubmit=$autoSubmit, supportedUIMode=$supportedUIMode," +
                "defaultProgressLoaderColor=$defaultProgressLoaderColor, showDefaultLoader=$showDefaultLoader," +
                "enableCustomizedOtpUIFlow=$enableCustomizedOtpUIFlow, enableTxnTimeoutTimer=$enableTxnTimeoutTimer," +
                "merchantName=$merchantName, amount=$amount," +
                "submitButtonTitle=${acsContentConfig?.submitButtonTitle}," +
                " resendButtonTitle=${acsContentConfig?.resendButtonTitle}," +
                "otpContent=${acsContentConfig?.otpContent}, currency=$currency," +
                "resendInfoContent=${acsContentConfig?.resendInfoContent}, " +
                "maxResendInfoContent=${acsContentConfig?.maxResendInfoContent}, " +
                "enableMFAViaBiometric=$enableMFAViaBiometric)"
    }
}