package com.payu.threeDS2.constants

import androidx.annotation.Keep

@Keep
class LoggingConstants {
    @Keep
    companion object {
        const val BIN_INFO_TAG = "Bin Info API"
        const val BIN_INFO_VALIDATION_TAG = "Bin Info Validation "

        const val SECURE_TAG = "_Payment API"

        const val AUTHORIZE_PAYMENT_TAG = "Authorize Payment API"
        const val AUTHORIZE_PAYMENT_VALIDATION_TAG = "Authorize Payment Validation "

        const val AUTHENTICATE_PAYMENT_TAG = "Authenticate Payment API"

        const val LOGGING_ERROR_KEY = "Error "


        const val THREE_DS_INITIALIZATION_FAILED = "ThreeDS SDK initialisation failed "
        const val THREE_DS_INITIALIZATION_SUCCESS = "ThreeDS SDK successfully initialised"
        const val THREE_DS_INITIALIZATION_STARTED = "ThreeDS SDK initialisation Started"
        const val THREE_DS_ALREADY_INITIALIZED_RETURNED_SAME_INSTANCE =
            "Wibmo SDK already initialised, returned same instance"
        const val THREE_DS_ALREADY_INITIALIZED = "SDK already initialised "

        const val RUN_TIME_EXCEPTION = "Wibmo initialization RunTimeException "
        const val PARQ_EXCEPTION = "Exception occurred while generating pArq "
        const val THREE_DS_SDK_CHALLENGE_RESPONSE = "ThreeDS SDK Challenge Response "
        const val THREE_DS_CHALLENGE_FLOW = "Challenge Flow"
        const val THREE_DS_CHALLENGE_FLOW_INITIATED = "Challenge Flow Initiated"
        const val THREE_DS_SDK_CHALLENGE_RESPONSE_RUNTIME_ERROR = "ThreeDS SDK Challenge Response: Run time error is null"
        const val THREE_DS_SDK_CHALLENGE_RESPONSE_PROTOCOL_ERROR = "ThreeDS SDK Challenge Response: Protocol error is null "


        const val THREE_DS_EVENT_NAME = "evtName"
        const val THREE_DS_IDENTITY = "identity"
        const val THREE_DS_TYPE = "type"
        const val THREE_DS_MERCHANT_IDENTIFIER = "Merchant Identifier"
        const val THREE_DS_DEVICE = "Device"
        const val THREE_DS_DEVICE_NAME = "Device name"
        const val THREE_DS_DEVICE_VERSION = "Device version"
        const val THREE_DS_EVENT = "event"
        const val THREE_DS_ANDROID = "Android"
        const val THREE_DS_SDK_VERSION = "SDK version"
        const val THREE_DS_TXNID = "Transaction identifier"
        const val THREE_DS_EVENT_DATA = "evtData"
        const val THREE_DS_PACKAGE_CORE = "com.payu.threeDS2"
        const val THREE_DS_ACS_INITIATED = "THREEDS_ACS_INITIATED"
        const val THREE_DS_DEVICE_DETAILS_STATUS = "status"
        const val THREE_DS_DEVICE_COLLECTION ="3DS_DEVICE_COLLECTION"
        const val PLATFORM_KEY = "platform"
        const val PLATFORM_VALUE = "android"
        const val NAME_KEY = "name"
        const val NAME_VALUE = "ThreeDS"
        const val VERSION_KEY = "version"
        const val SUCCESS = "success"
        const val FAILURE = "failure"
        const val THREE_DS_IS_SEAMLESS_FLOW = "Is Seamless"
        const val THREE_DS_ACTION_ERROR = "ThreeDS SDK action error"

        //Method names RBA
        const val RBA_INIT = "configSdk"
        const val RBA_CHECK_DEVICE_STATUS = "checkRegistrationStatus"
        const val RBA_REGISTRATION = "initiateRegistration"
        const val RBA_TRANSACTION = "processTransaction"
        const val RBA_SELECTION_SCREEN = "selectionScreen"

        //Method names 3DS
        const val THREE_DS_INIT = "initialize"
        const val THREE_DS_DEVICE_DETAILS = "extractDeviceDetails"
        const val THREE_DS_INITIATE_CHALLENGE = "initiateChallenge"
        const val THREE_DS_HEADLESS_ACTION = "acsAction"

    }
}