package com.payu.threeDS2.constants

import androidx.annotation.Keep

@Keep
class PayU3DS2Constants {
    @Keep
    companion object {
        const val KEY = "key"
        const val HASH = "hash"
        const val VAR1 = "var1"
        const val VAR2 = "var2"
        const val VAR5 = "var5"
        const val VAR7 = "var7"

        const val AMOUNT = "amount"
        const val TXN_ID = "txnid"
        const val ERROR = "ERROR"

        const val EMPTY_STRING = ""
        const val COMMAND = "command"
        const val MERCHANT_RESPONSE = "merchantResponse"
        const val PAYU_RESPONSE = "payUResponse"
        const val SDK_CHALLENGE_TIMEOUT = 5

        const val THREEDS_MERCHANT_KEY = "merchant_key"
        const val THREEDS_EVENT_KEY = "event_key"
        const val THREEDS_EVENT_VALUE = "event_value"
        const val THREEDS_TIMESTAMP = "ts"
        const val THREEDS_SDK_VERSION = "sdk_version"
        const val THREEDS_TXN_ID = "txnid"
        const val THREEDS_DEVICE_DETAILS = "device_details"
        const val THREEDS_LOGGING_SDK = "logging_sdk"
        const val THREEDS_APPLICATION_VERSION = "application_version"
        const val SDK_INTEGRATION = "sdkIntegration"
        const val DATE = "Date"
        const val REFERENCE_ID = "referenceId"
        const val DD_MM_YY_HH_MM_SS_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss"
        const val PAYU_SDK_TIME = "sdkTime"
        const val OTP_SENT_DEFAULT_MESSAGE = "Successfully sent OTP to your registered mobile number"
        const val EVENT_SEVERITY = "event_severity"
        const val EVENT_TYPE = "event_type"
        const val PLATFORM = "platform"
        const val PLATFORM_VALUE = "Android"
        const val SDK_NAME = "sdk_name"
        const val SDK_NAME_VALUE = "ThreeDS SDK"

    }

}