package com.payu.threeDS2.utils

import com.payu.paymentparamhelper.PaymentParams
import com.payu.paymentparamhelper.threeDS2Params.SDKDeviceRenderOptions
import com.payu.paymentparamhelper.threeDS2Params.SDKEphemParams
import com.payu.paymentparamhelper.threeDS2Params.SDKInfo
import com.payu.threedsbase.constants.APIConstants
import com.payu.threedsbase.data.PArqResponse

class PaymentParamUtils {

    /**
     * Helper method to update payment params passed by merchant with details of SDKInfo required to
     * generate PArs values and to pass SDK platform data for kibana filtering
     */
    fun updateParamWithPArqAndSDKData(pArqResponse: PArqResponse, paymentParams: PaymentParams) {
        val sdkInfo = SDKInfo()
        sdkInfo.sdkEncData = pArqResponse.sdkEncData
        sdkInfo.sdkAppID = pArqResponse.sdkAppID
        sdkInfo.sdkReferenceNumber = pArqResponse.sdkReferenceNumber
        sdkInfo.sdkTransID = pArqResponse.sdkTransID
        sdkInfo.sdkMaxTimeout = APIConstants.WIBMO_SDK_MAX_TIMEOUT

        val sdkEphemParams = SDKEphemParams()
        sdkEphemParams.crv = pArqResponse.crv
        sdkEphemParams.kty = pArqResponse.kty
        sdkEphemParams.x = pArqResponse.x
        sdkEphemParams.y = pArqResponse.y
        sdkInfo.sdkEphemPubKey = sdkEphemParams
        val sdkDeviceRenderOptions = SDKDeviceRenderOptions()
        sdkDeviceRenderOptions.sdkInterface = "03"
        sdkDeviceRenderOptions.sdkUiType = mutableListOf("05", "01", "02", "03", "04")
        sdkInfo.sdkDeviceRenderOptions = sdkDeviceRenderOptions

        paymentParams.sdkInfo = sdkInfo
        /**
         * Updating SDK platform data to be send for kibana filtering
         */
        paymentParams.sdkPlatformData =
            LoggingUtils.getAnalyticsString(paymentParams.sdkPlatformData)
    }
}