package com.payu.threeDS2.utils

import android.content.Context
import com.payu.threeDS2.config.PayU3DS2Config
import com.payu.threeDS2.constants.PayU3DS2Constants.Companion.DD_MM_YY_HH_MM_SS_DATE_FORMAT
import com.payu.threeDS2.network.TLSSocketFactory
import com.payu.threedsbase.constants.APIConstants
import com.payu.threedsbase.constants.PayU3DS2ErrorConstants
import com.payu.threedsbase.data.PayU3DS2DeviceWarning
import com.payu.threedsbase.enums.ACSActionType
import com.payu.threedsbase.enums.DeviceSeverity
import com.payu.threedsui.uiCustomisation.BottomSheetCustomisation
import com.payu.threedsui.uiCustomisation.ButtonCustomisation
import com.payu.threedsui.uiCustomisation.FontFamilyCustomisation
import com.payu.threedsui.uiCustomisation.LabelCustomisation
import com.payu.threedsui.uiCustomisation.TextBoxCustomisation
import com.payu.threedsui.uiCustomisation.ToolbarCustomisation
import com.payu.threedsui.uiCustomisation.UICustomisation
import com.payu.threedsui.uiCustomisation.enums.ButtonTextCaseType
import com.payu.threedsui.uiCustomisation.enums.FontName
import com.payu.threedsui.uiCustomisation.tridentity.TextCustomization
import com.payu.threedsui.uiCustomisation.tridentity.BottomSheetAuthenticationPopupConfiguration
import com.payu.threedsui.uiCustomisation.tridentity.BottomSheetFailureScreenConfiguration
import com.payu.threedsui.uiCustomisation.tridentity.BottomSheetPermissionPopupConfiguration
import com.payu.threedsui.uiCustomisation.tridentity.BottomSheetRegistrationSuccessfulPopupConfiguration
import com.payu.threedsui.uiCustomisation.tridentity.BottomSheetSimBindingProcessingPopupConfiguration
import com.wibmo.threeds2.sdk.cfg.BottomSheetButtonCustomization
import com.wibmo.threeds2.sdk.cfg.BottomSheetLabelCustomization
import com.wibmo.threeds2.sdk.cfg.ButtonCustomization
import com.wibmo.threeds2.sdk.cfg.FontFamilyCustomization
import com.wibmo.threeds2.sdk.cfg.LabelCustomization
import com.wibmo.threeds2.sdk.cfg.Severity
import com.wibmo.threeds2.sdk.cfg.TextBoxCustomization
import com.wibmo.threeds2.sdk.cfg.ToolbarCustomization
import com.wibmo.threeds2.sdk.cfg.UiCustomization
import com.wibmo.threeds2.sdk.cfg.Warning
import com.wibmo.threeds2.sdk.error.InvalidInputException
import com.wibmo.threeds2.sdk.event.ActionType
import com.wibmo.tridentity.sdk.theme.ThemeConfig
import java.io.FileOutputStream
import java.io.IOException
import java.io.InputStream
import java.net.URL
import java.text.SimpleDateFormat
import java.util.Date
import java.util.zip.GZIPInputStream
import javax.net.ssl.HttpsURLConnection

object Utils {

    fun mapUICustomisationToWibmo(uiCustomisation: UICustomisation?): UiCustomization? {
        if (uiCustomisation == null)
            return null
        val wibmoUICustomisation = UiCustomization()

        mapButtonCustomisation(uiCustomisation.buttonCustomisation, wibmoUICustomisation)
        mapToolbarCustomisation(uiCustomisation.toolbarCustomisation, wibmoUICustomisation)
        mapLabelCustomisation(uiCustomisation.labelCustomisation, wibmoUICustomisation)
        mapTextboxCustomisation(uiCustomisation.textBoxCustomisation, wibmoUICustomisation)
        mapBottomSheetCustomisation(
            uiCustomisation.bottomSheetCustomisation,
            wibmoUICustomisation
        )
        mapFontFamilyCustomisation(uiCustomisation.fontFamilyCustomisation, wibmoUICustomisation)
        wibmoUICustomisation.themeType = UiCustomization.UICustomizationType.DEFAULT.name

        return wibmoUICustomisation
    }

    private fun mapTextboxCustomisation(
        textBoxCustomisation: TextBoxCustomisation?,
        wibmoUICustomisation: UiCustomization
    ) {
        if (textBoxCustomisation != null) {
            val textBoxCustomization = TextBoxCustomization()
            if (ColorValidator.validateHexColor(textBoxCustomisation.textColor))
                textBoxCustomization.textColor = textBoxCustomisation.textColor
            if (textBoxCustomisation.textFontName != null)
                textBoxCustomization.textFontName =
                    mapPayUFontToWibmoFont(textBoxCustomisation.textFontName!!).name
            if (ColorValidator.validateHexColor(textBoxCustomisation.borderColor))
                textBoxCustomization.borderColor = textBoxCustomisation.borderColor
            if (textBoxCustomisation.borderWidth != null)
                textBoxCustomization.borderWidth = textBoxCustomisation.borderWidth!!
            if (textBoxCustomisation.cornerRadius != null)
                textBoxCustomization.cornerRadius = textBoxCustomisation.cornerRadius!!
            if ((textBoxCustomisation.cornerRadius != null || ColorValidator.validateHexColor(
                    textBoxCustomisation.borderColor
                )) &&
                textBoxCustomisation.borderWidth == null
            )
                textBoxCustomization.borderWidth = 1
            if (textBoxCustomisation.textFontSize != null)
                textBoxCustomization.textFontSize = textBoxCustomisation.textFontSize!!
            wibmoUICustomisation.textBoxCustomization = textBoxCustomization
        }
    }

    private fun mapLabelCustomisation(
        labelCustomization: LabelCustomisation?,
        wibmoUICustomisation: UiCustomization
    ) {
        if (labelCustomization != null) {
            val labelCustomisation = LabelCustomization()
            if (ColorValidator.validateHexColor(labelCustomization.headingTextColor))
                labelCustomisation.headingTextColor = labelCustomization.headingTextColor
            if (labelCustomization.headingTextFontName != null)
                labelCustomisation.headingTextFontName =
                    mapPayUFontToWibmoFont(labelCustomization.headingTextFontName!!).name
            if (labelCustomization.headingTextFontSize != null)
                labelCustomisation.headingTextFontSize = labelCustomization.headingTextFontSize!!
            if (ColorValidator.validateHexColor(labelCustomization.textColor))
                labelCustomisation.textColor = labelCustomization.textColor
            if (labelCustomization.textFontName != null)
                labelCustomisation.textFontName =
                    mapPayUFontToWibmoFont(labelCustomization.textFontName!!).name
            if (labelCustomization.textFontSize != null)
                labelCustomisation.textFontSize = labelCustomization.textFontSize!!
            wibmoUICustomisation.labelCustomization = labelCustomisation
        }
    }

    private fun mapToolbarCustomisation(
        toolbarCustomisation: ToolbarCustomisation?,
        wibmoUICustomisation: UiCustomization
    ) {
        if (toolbarCustomisation != null) {
            val toolbarCustomization = ToolbarCustomization()
            if (ColorValidator.validateHexColor(toolbarCustomisation.backgroundColor))
                toolbarCustomization.backgroundColor = toolbarCustomisation.backgroundColor
            if (ColorValidator.validateHexColor(toolbarCustomisation.textColor))
                toolbarCustomization.textColor = toolbarCustomisation.textColor
            if (!toolbarCustomisation.buttonText.isNullOrEmpty())
                toolbarCustomization.buttonText = toolbarCustomisation.buttonText
            if (toolbarCustomisation.textFontName != null)
                toolbarCustomization.textFontName =
                    mapPayUFontToWibmoFont(toolbarCustomisation.textFontName!!).name
            if (toolbarCustomisation.textFontSize != null)
                toolbarCustomization.textFontSize = toolbarCustomisation.textFontSize!!
            if (!toolbarCustomisation.headerText.isNullOrEmpty())
                toolbarCustomization.headerText = toolbarCustomisation.headerText
            wibmoUICustomisation.toolbarCustomization = toolbarCustomization
        }
    }

    private fun mapButtonCustomisation(
        buttonCustomisation: ButtonCustomisation?,
        wibmoUICustomisation: UiCustomization
    ) {
        if (buttonCustomisation != null) {
            val buttonCustomization = ButtonCustomization()
            if (ColorValidator.validateHexColor(buttonCustomisation.backgroundColor))
                buttonCustomization.backgroundColor =
                    buttonCustomisation.backgroundColor
            if (buttonCustomisation.cornerRadius != null)
                buttonCustomization.cornerRadius =
                    buttonCustomisation.cornerRadius!!
            if (buttonCustomisation.textCaseType != null)
                buttonCustomization.textTransform =
                    mapPayuTextCaseToWibmo(buttonCustomisation.textCaseType!!)
            if (buttonCustomisation.textFontSize != null)
                buttonCustomization.textFontSize = buttonCustomisation.textFontSize!!
            if (ColorValidator.validateHexColor(buttonCustomisation.textFontColor))
                buttonCustomization.textColor = buttonCustomisation.textFontColor
            if (ColorValidator.validateHexColor(buttonCustomisation.resendTextFontColor))
                buttonCustomization.resendTextColor = buttonCustomisation.resendTextFontColor

            wibmoUICustomisation.setButtonCustomization(
                buttonCustomization,
                UiCustomization.ButtonType.VERIFY
            )
        }
    }

    private fun mapFontFamilyCustomisation(
        fontFamilyCustomisation: FontFamilyCustomisation?,
        wibmoUICustomisation: UiCustomization
    ) {
        if (fontFamilyCustomisation != null) {
            val fontFamilyCustomization = FontFamilyCustomization()

            if (!fontFamilyCustomisation.headerFontFamily.isNullOrEmpty())
                fontFamilyCustomization.headerFontFamilyPath =
                    fontFamilyCustomisation.headerFontFamily

            if (!fontFamilyCustomisation.subTextFontFamily.isNullOrEmpty())
                fontFamilyCustomization.textFontFamilyPath =
                    fontFamilyCustomisation.subTextFontFamily

            wibmoUICustomisation.fontFamilyCustomization = fontFamilyCustomization
        }
    }

    fun concatParams(key: String, value: String): String {
        return "$key=$value&"
    }

    fun trimAmpersand(data: String): String {
        return if (data[data.length - 1] == '&') data.substring(0, data.length - 1) else data
    }

    fun mapWibmoWarningsToDeviceWarning(warningList: List<Warning>): List<PayU3DS2DeviceWarning> {
        val warnings = mutableListOf<PayU3DS2DeviceWarning>()
        for (warning in warningList
        ) {
            warnings.add(
                PayU3DS2DeviceWarning(
                    warning.id,
                    warning.message,
                    mapWarningSeverityToDeviceSeverity(warning.severity)
                )
            )
        }

        return warnings
    }

    private fun mapWarningSeverityToDeviceSeverity(severity: Severity): DeviceSeverity {
        return when (severity) {
            Severity.LOW -> DeviceSeverity.LOW
            Severity.MEDIUM -> DeviceSeverity.MEDIUM
            Severity.HIGH -> DeviceSeverity.HIGH
        }
    }

    private fun mapPayUFontToWibmoFont(fontType: FontName): UiCustomization.FontType {
        return when (fontType) {
            FontName.ROBOTO_MEDIUM -> UiCustomization.FontType.ROBOTO_MEDIUM
            FontName.ROBOTO_REGULAR -> UiCustomization.FontType.ROBOTO_REGULAR
        }
    }

    fun getHttpsConn(strURL: String?): HttpsURLConnection? {
        return try {
            val url = URL(strURL)
            val conn = url.openConnection() as HttpsURLConnection
            conn.requestMethod = APIConstants.HTTP_REQUEST_TYPE_GET
            conn.sslSocketFactory = TLSSocketFactory()
            conn.setRequestProperty(
                APIConstants.ACCEPT_CHARSET,
                APIConstants.ACCEPT_CHARSET_VALUE
            )
            conn
        } catch (e: java.lang.Exception) {
            null
        }
    }


    fun writeFileOutputStream(
        inputStream: InputStream?,
        context: Context,
        fileName: String?,
        contextMode: Int
    ) {
        try {
            val responseInputStream = GZIPInputStream(inputStream)
            val buf = ByteArray(1024)
            var len: Int
            val outputStream: FileOutputStream = context.openFileOutput(fileName, contextMode)
            while (responseInputStream.read(buf).also { len = it } > 0) {
                outputStream.write(buf, 0, len)
            }
            responseInputStream.close()
            outputStream.close()
        } catch (e: IOException) {
        } catch (e: java.lang.Exception) {
        }
    }

    fun getCurrentDateInDDMMYYHHMMSSFormat(): String {
        val sdf = SimpleDateFormat(DD_MM_YY_HH_MM_SS_DATE_FORMAT)
        return sdf.format(Date())
    }

    private fun mapBottomSheetCustomisation(
        bottomSheetCustomisation: BottomSheetCustomisation?,
        wibmoUICustomisation: UiCustomization
    ) {
        if (bottomSheetCustomisation != null) {
            val bsBtnCustomization = BottomSheetButtonCustomization()
            if (ColorValidator.validateHexColor(bottomSheetCustomisation.buttonBackgroundColor))
                bsBtnCustomization.backgroundColor =
                    bottomSheetCustomisation.buttonBackgroundColor
            if (bottomSheetCustomisation.cornerRadius != null)
                bsBtnCustomization.cornerRadius =
                    bottomSheetCustomisation.cornerRadius!!
            if (ColorValidator.validateHexColor(bottomSheetCustomisation.textFontColor))
                bsBtnCustomization.textColor = bottomSheetCustomisation.textFontColor
            if (bottomSheetCustomisation.textFontSize != null)
                bsBtnCustomization.textFontSize = bottomSheetCustomisation.textFontSize!!
            if (bottomSheetCustomisation.textCaseType != null)
                bsBtnCustomization.textTransform =
                    mapPayuTextCaseToWibmo(bottomSheetCustomisation.textCaseType!!)
            if (ColorValidator.validateHexColor(bottomSheetCustomisation.resendTextFontColor))
                bsBtnCustomization.resendTextColor =
                    bottomSheetCustomisation.resendTextFontColor

            wibmoUICustomisation.bottomSheetButtonCustomization = bsBtnCustomization


            val bsLabelCustomization = BottomSheetLabelCustomization()
            if (bottomSheetCustomisation.labelTextFontSize != null)
                bsLabelCustomization.textFontSize = bottomSheetCustomisation.labelTextFontSize!!
            if (bottomSheetCustomisation.headingTextFontSize != null)
                bsLabelCustomization.headingTextFontSize =
                    bottomSheetCustomisation.headingTextFontSize!!
            wibmoUICustomisation.bottomSheetLabelCustomization = bsLabelCustomization

        }
    }

    private fun mapPayuTextCaseToWibmo(buttonTextCaseType: ButtonTextCaseType): String {
        return when (buttonTextCaseType) {
            ButtonTextCaseType.LOWER_CASE -> UiCustomization.ButtonTextTransformType.LOWER_CASE.name
            ButtonTextCaseType.UPPER_CASE -> UiCustomization.ButtonTextTransformType.UPPER_CASE.name
        }
    }

    fun getTimeDifferenceInMilliSeconds(apiCalledTime: Long): Long {
        return System.currentTimeMillis() - apiCalledTime
    }

    fun mapPayUActionTypeToWibmoActionType(acsActionType: ACSActionType): ActionType {
        return when (acsActionType) {
            ACSActionType.CANCEL -> ActionType.CANCEL
            ACSActionType.RESEND -> ActionType.RESEND
            ACSActionType.SUBMIT -> ActionType.SUBMIT
        }
    }

    fun mapWibmoActionTypeToPayUActionType(actionType: ActionType): ACSActionType {
        return when (actionType) {
            ActionType.CANCEL -> ACSActionType.CANCEL
            ActionType.RESEND -> ACSActionType.RESEND
            ActionType.SUBMIT -> ACSActionType.SUBMIT
        }
    }

    internal fun validateCustomACSContent(amount: String?, merchantName: String?) {
        if (amount == null || amount.toDoubleOrNull() == null || amount.toDouble() < 1)
            throw InvalidInputException(PayU3DS2ErrorConstants.INVALID_AMOUNT)
        if (merchantName?.trim().isNullOrEmpty())
            throw InvalidInputException(PayU3DS2ErrorConstants.INVALID_MERCHANT_NAME)
    }


    fun mapUIThemeTridentity(payU3DS2Config: PayU3DS2Config?): com.wibmo.tridentity.sdk.theme.ThemeConfig? {
        if (payU3DS2Config == null)
            return null
        val tridentityCustomisation = com.wibmo.tridentity.sdk.theme.ThemeConfig();
        mapUITextCustomizationTridentity(payU3DS2Config.uiCustomisation?.textCustomization, tridentityCustomisation)
        mapUICustomisationToTridentity(payU3DS2Config, tridentityCustomisation)
      return tridentityCustomisation
    }


    private fun mapUITextCustomizationTridentity(
        textCustomization: TextCustomization?,
        tridentityCustomisation: com.wibmo.tridentity.sdk.theme.ThemeConfig) {

        if (textCustomization != null) {
            bottomSheetAuthenticationPopupConfiguration(
                textCustomization.bottomSheetAuthenticationPopupConfiguration,
                tridentityCustomisation
            )
            bottomSheetFailureScreenConfiguration(
                textCustomization.bottomSheetFailureScreenConfiguration,
                tridentityCustomisation
            )
            bottomSheetPermissionPopupConfiguration(
                textCustomization.bottomSheetPermissionPopupConfiguration,
                tridentityCustomisation
            )
            bottomSheetRegistrationSuccessfulPopupConfiguration(
                textCustomization.bottomSheetRegistrationSuccessfulPopupConfiguration,
                tridentityCustomisation
            )
            bottomSheetSimBindingProcessingPopupConfiguration(
                textCustomization.bottomSheetSimBindingProcessingPopupConfiguration,
                tridentityCustomisation
            )
        }
    }

    private fun bottomSheetAuthenticationPopupConfiguration(
        bottomSheetAuthenticationPopupConfiguration: BottomSheetAuthenticationPopupConfiguration?,
        themeConfig: com.wibmo.tridentity.sdk.theme.ThemeConfig
    ) {
        if (bottomSheetAuthenticationPopupConfiguration != null) {
            val configuration = com.wibmo.tridentity.sdk.theme.BottomSheetAuthenticationPopupConfiguration()
            var hasValue = false
            if (bottomSheetAuthenticationPopupConfiguration.declineButtonText.isNullOrBlank().not()
            ) {
                configuration.declineButtonText = bottomSheetAuthenticationPopupConfiguration.declineButtonText
                hasValue = true
            }
            if (bottomSheetAuthenticationPopupConfiguration.headerTextForContents.isNullOrBlank().not()) {
                configuration.headerTextForContents = bottomSheetAuthenticationPopupConfiguration.headerTextForContents
                hasValue = true
            }
            if (bottomSheetAuthenticationPopupConfiguration.subTextForContents.isNullOrBlank().not()
            ) {
                configuration.subTextForContents = bottomSheetAuthenticationPopupConfiguration.subTextForContents
                hasValue = true
            }
            if (bottomSheetAuthenticationPopupConfiguration.swipeToPayButtonText.isNullOrBlank().not()) {
                configuration.swipeToPayButtonText = bottomSheetAuthenticationPopupConfiguration.swipeToPayButtonText
                hasValue = true
            }
            if (bottomSheetAuthenticationPopupConfiguration.topHeaderText.isNullOrBlank().not()
            ) {
                configuration.topHeaderText = bottomSheetAuthenticationPopupConfiguration.topHeaderText
                hasValue = true
            }
            if (bottomSheetAuthenticationPopupConfiguration.topSubHeaderText.isNullOrBlank().not()) {
                configuration.topSubHeaderText = bottomSheetAuthenticationPopupConfiguration.topSubHeaderText
                hasValue = true
            }
            if (themeConfig.textCustomization != null && hasValue) {
                themeConfig.textCustomization?.bottomSheetAuthenticationPopupConfiguration = configuration
            }
        }
    }

    private fun bottomSheetFailureScreenConfiguration(
        consentScreenConfiguration: BottomSheetFailureScreenConfiguration?,
        themeConfig: com.wibmo.tridentity.sdk.theme.ThemeConfig
    ) {
        if (consentScreenConfiguration != null) {
            val configuration = com.wibmo.tridentity.sdk.theme.BottomSheetFailureScreenConfiguration()
            var hasValue = false
            if (consentScreenConfiguration.buttonText.isNullOrBlank().not()
            ) {
                configuration.buttonText = consentScreenConfiguration.buttonText
                hasValue = true
            }
            if (consentScreenConfiguration.headerTextForContents.isNullOrBlank().not()
            ) {
                configuration.headerTextForContents = consentScreenConfiguration.headerTextForContents
                hasValue = true
            }
            if (consentScreenConfiguration.subTextForContents.isNullOrBlank().not()
            ) {
                configuration.subTextForContents = consentScreenConfiguration.subTextForContents
                hasValue = true
            }
            if (themeConfig.textCustomization != null && hasValue) {
                themeConfig.textCustomization?.bottomSheetFailureScreenConfiguration = configuration
            }
        }

    }

    private fun bottomSheetPermissionPopupConfiguration(
        bottomSheetPermissionPopupConfiguration: BottomSheetPermissionPopupConfiguration?,
        themeConfig: com.wibmo.tridentity.sdk.theme.ThemeConfig
    ) {
        if (bottomSheetPermissionPopupConfiguration != null) {
            val configuration = com.wibmo.tridentity.sdk.theme.BottomSheetPermissionPopupConfiguration()
            var hasValue = false
            if (bottomSheetPermissionPopupConfiguration.buttonTextForAllowPermissions.isNullOrBlank().not()
            ) {
                configuration.buttonTextForAllowPermissions = bottomSheetPermissionPopupConfiguration.buttonTextForAllowPermissions
                hasValue = true
            }

            if (bottomSheetPermissionPopupConfiguration.buttonTextForSkipPermissions.isNullOrBlank().not()
            ) {
                configuration.buttonTextForSkipPermissions = bottomSheetPermissionPopupConfiguration.buttonTextForSkipPermissions
                hasValue = true
            }
            if (bottomSheetPermissionPopupConfiguration.headerTextForContents.isNullOrBlank().not()
            ) {
                configuration.headerTextForContents = bottomSheetPermissionPopupConfiguration.headerTextForContents
                hasValue = true
            }
            if (bottomSheetPermissionPopupConfiguration.subTextForContents.isNullOrBlank().not()
            ) {
                configuration.subTextForContents = bottomSheetPermissionPopupConfiguration.subTextForContents
                hasValue = true
            }
            if (bottomSheetPermissionPopupConfiguration.topHeaderText.isNullOrBlank().not()
            ) {
                configuration.topHeaderText = bottomSheetPermissionPopupConfiguration.topHeaderText
                hasValue = true
            }
            if (bottomSheetPermissionPopupConfiguration.topSubHeaderText.isNullOrBlank().not()) {
                configuration.topSubHeaderText = bottomSheetPermissionPopupConfiguration.topSubHeaderText
                hasValue = true
            }
            if (themeConfig.textCustomization != null && hasValue) {
                themeConfig.textCustomization?.bottomSheetPermissionPopupConfiguration = configuration
            }
        }
    }

    private fun bottomSheetRegistrationSuccessfulPopupConfiguration(
        bottomSheetRegistrationSuccessfulPopupConfiguration: BottomSheetRegistrationSuccessfulPopupConfiguration?,
        themeConfig : com.wibmo.tridentity.sdk.theme.ThemeConfig
    ){
        if (bottomSheetRegistrationSuccessfulPopupConfiguration != null) {
            val configuration = com.wibmo.tridentity.sdk.theme.BottomSheetRegistrationSuccessfulPopupConfiguration()
            var hasValue = false
            if (bottomSheetRegistrationSuccessfulPopupConfiguration.buttonText.isNullOrBlank().not()
            ) {
                configuration.buttonText = bottomSheetRegistrationSuccessfulPopupConfiguration.buttonText
                hasValue = true
            }
            if (bottomSheetRegistrationSuccessfulPopupConfiguration.headerTextForContents.isNullOrBlank().not()
            ) {
                configuration.headerTextForContents = bottomSheetRegistrationSuccessfulPopupConfiguration.headerTextForContents
                hasValue = true
            }
            if (bottomSheetRegistrationSuccessfulPopupConfiguration.subTextForContents.isNullOrBlank().not()
            ) {
                configuration.subTextForContents = bottomSheetRegistrationSuccessfulPopupConfiguration.subTextForContents
                hasValue = true
            }

            if (themeConfig.textCustomization != null && hasValue) {
                themeConfig.textCustomization?.bottomSheetRegistrationSuccessfulPopupConfiguration = configuration
            }
        }
    }

    private fun bottomSheetSimBindingProcessingPopupConfiguration(
        bottomSheetSimBindingProcessingPopupConfiguration: BottomSheetSimBindingProcessingPopupConfiguration?,
        themeConfig: com.wibmo.tridentity.sdk.theme.ThemeConfig
    ) {
        if (bottomSheetSimBindingProcessingPopupConfiguration != null) {
            val configuration =
                com.wibmo.tridentity.sdk.theme.BottomSheetSimBindingProcessingPopupConfiguration()
            var hasValue = false

            if (bottomSheetSimBindingProcessingPopupConfiguration.biometricSetupText.isNullOrBlank().not()
            ) {
                configuration.biometricSetupText = bottomSheetSimBindingProcessingPopupConfiguration.biometricSetupText
                hasValue = true
            }

            if (bottomSheetSimBindingProcessingPopupConfiguration.biometricVerifiedText.isNullOrBlank().not()) {
                configuration.biometricVerifiedText =
                    bottomSheetSimBindingProcessingPopupConfiguration.biometricVerifiedText
                hasValue = true
            }
            if (bottomSheetSimBindingProcessingPopupConfiguration.headerTextForContents.isNullOrBlank().not()) {
                configuration.headerTextForContents =
                    bottomSheetSimBindingProcessingPopupConfiguration.headerTextForContents
                hasValue = true
            }

            if (bottomSheetSimBindingProcessingPopupConfiguration.numberVerificationProcessingText.isNullOrBlank().not()) {
                configuration.numberVerificationProcessingText =
                    bottomSheetSimBindingProcessingPopupConfiguration.numberVerificationProcessingText
                hasValue = true
            }
            if (bottomSheetSimBindingProcessingPopupConfiguration.numberVerifiedText.isNullOrBlank().not()) {
                configuration.numberVerifiedText = bottomSheetSimBindingProcessingPopupConfiguration.numberVerifiedText
                hasValue = true
            }

            if (bottomSheetSimBindingProcessingPopupConfiguration.simSelectionHeaderText.isNullOrBlank().not()) {
                configuration.simSelectionHeaderText =
                    bottomSheetSimBindingProcessingPopupConfiguration.simSelectionHeaderText
                hasValue = true
            }
            if (bottomSheetSimBindingProcessingPopupConfiguration.subTextForContents.isNullOrBlank().not()) {
                configuration.subTextForContents = bottomSheetSimBindingProcessingPopupConfiguration.subTextForContents
                hasValue = true
            }
            if (bottomSheetSimBindingProcessingPopupConfiguration.topHeaderText.isNullOrBlank().not()) {
                configuration.topHeaderText = bottomSheetSimBindingProcessingPopupConfiguration.topHeaderText
                hasValue = true
            }
            if (bottomSheetSimBindingProcessingPopupConfiguration.topSubHeaderText.isNullOrBlank().not()) {
                configuration.topSubHeaderText = bottomSheetSimBindingProcessingPopupConfiguration.topSubHeaderText
                hasValue = true
            }

            if (themeConfig.textCustomization != null && hasValue) {
                themeConfig.textCustomization?.bottomSheetSimBindingProcessingPopupConfiguration = configuration
            }
        }
    }


    fun mapUICustomisationToTridentity(
        payU3DS2Config: PayU3DS2Config?,
        tridentityCustomisation: com.wibmo.tridentity.sdk.theme.ThemeConfig
    ) {

        if (payU3DS2Config != null) {
            mapButtonCustomisationTridenity(
                payU3DS2Config.uiCustomisation, tridentityCustomisation)
            mapToolbarCustomisationTridenity(payU3DS2Config.uiCustomisation?.toolbarCustomisation,
                tridentityCustomisation)
            mapLabelCustomisationTridenity(payU3DS2Config.uiCustomisation,
                tridentityCustomisation)
        }
    }

    private fun mapLabelCustomisationTridenity(
        labelCustomization: UICustomisation?,
        wibmoUICustomisation: ThemeConfig
    ) {
        labelCustomizationHeadingCustomization(labelCustomization, wibmoUICustomisation)
        labelCustomizationTextCustomization(labelCustomization, wibmoUICustomisation)
    }

    private fun labelCustomizationHeadingCustomization(
        headingCustomization: UICustomisation?,
        themeConfig: ThemeConfig
    ) {

        val customization = com.wibmo.tridentity.sdk.theme.HeadingContentCustomization();
        var hasValue = false;

        if (headingCustomization?.fontFamilyCustomisation?.headerFontFamily != null) {
            customization.fontName = headingCustomization?.fontFamilyCustomisation?.headerFontFamily
            hasValue = true;
        }

        if (headingCustomization?.labelCustomisation != null) {

            if (headingCustomization?.labelCustomisation?.headingTextFontSize != null) {
                customization.fontSize =
                    headingCustomization?.labelCustomisation?.headingTextFontSize?.toFloat()
                hasValue = true;
            }
            if (headingCustomization?.labelCustomisation?.headingTextColor.isNullOrBlank().not()) {
                customization.textColor =
                    headingCustomization?.labelCustomisation?.headingTextColor
                hasValue = true;
            }
        }
        if (themeConfig.uiCustomization?.labelCustomization != null && hasValue) {
            themeConfig.uiCustomization?.labelCustomization?.headingCustomization = customization
        }
    }

    private fun labelCustomizationTextCustomization(
        textCustomization: UICustomisation?,
        themeConfig: ThemeConfig
    ) {

        val cutomization = com.wibmo.tridentity.sdk.theme.SubHeadingCustomization();
        var hasValue = false;

        if (textCustomization?.fontFamilyCustomisation?.subTextFontFamily != null) {
            cutomization.fontName = textCustomization?.fontFamilyCustomisation?.subTextFontFamily
            hasValue = true;
        }


        if (textCustomization?.labelCustomisation != null) {


            if (textCustomization?.labelCustomisation?.textFontSize != null) {
                cutomization.fontSize =
                    textCustomization?.labelCustomisation?.textFontSize?.toFloat()
                hasValue = true;
            }
            if (textCustomization?.labelCustomisation?.textColor.isNullOrBlank().not()) {
                cutomization.textColor =
                    textCustomization?.labelCustomisation?.textColor
                hasValue = true;
            }

        }
        if (themeConfig.uiCustomization?.labelCustomization != null && hasValue) {
            themeConfig.uiCustomization?.labelCustomization?.subHeadingCustomization = cutomization
        }

    }

    private fun mapToolbarCustomisationTridenity(
        toolbarCustomization: ToolbarCustomisation?,
        themeConfig: com.wibmo.tridentity.sdk.theme.ThemeConfig
    ) {
        if (toolbarCustomization != null) {
            val customisation = com.wibmo.tridentity.sdk.theme.ToolbarCustomization();
            var hasValue = false;
            if (toolbarCustomization.textColor.isNullOrBlank().not()) {
                customisation.textColor = toolbarCustomization.textColor
                hasValue = true
            }
            if (toolbarCustomization.backgroundColor.isNullOrBlank().not()) {
                customisation.backgroundColor = toolbarCustomization.backgroundColor
                hasValue = true
            }
            if (toolbarCustomization.textFontName != null) {
                customisation.fontName = toolbarCustomization.textFontName?.name
                hasValue = true
            }
            if (toolbarCustomization.textFontSize != null) {
                customisation.fontSize = toolbarCustomization.textFontSize?.toFloat()
                hasValue = true
            }
            if (themeConfig.uiCustomization != null && hasValue) {
                themeConfig.uiCustomization?.toolbarCustomization = customisation
            }
        }
    }

    private fun mapButtonCustomisationTridenity(
        uiCustomisation: UICustomisation?,
        themeConfig: ThemeConfig
    ) {
        if (uiCustomisation != null) {
            val buttonCustomisation = com.wibmo.tridentity.sdk.theme.ButtonCustomization()
            var hasValue = false;

            if(!uiCustomisation.fontFamilyCustomisation?.headerFontFamily.isNullOrBlank()){
                hasValue= true;
                buttonCustomisation.fontName = uiCustomisation.fontFamilyCustomisation?.headerFontFamily
            }

            if(uiCustomisation.buttonCustomisation?.textFontSize != null){
                hasValue = true;
                buttonCustomisation.fontSize = uiCustomisation.buttonCustomisation?.textFontSize?.toFloat()
            }

            if (uiCustomisation.buttonCustomisation?.cornerRadius != null) {
                hasValue = true;
                buttonCustomisation.buttonCornerRadius = uiCustomisation.buttonCustomisation?.cornerRadius
            }

            if (themeConfig.uiCustomization != null && hasValue) {
                themeConfig.uiCustomization?.buttonCustomization = buttonCustomisation
            }

            buttonCustomisationprimaryButtonCustomization(uiCustomisation.buttonCustomisation,themeConfig)

        }

    }

    private fun buttonCustomisationprimaryButtonCustomization(
        primaryButtonCustomization: ButtonCustomisation?,
        themeConfig: ThemeConfig
    ) {
        if (primaryButtonCustomization != null) {
            val primaryButtonCustomisation =
                com.wibmo.tridentity.sdk.theme.PrimaryButtonCustomization()
            var hasValue = false;
            if (primaryButtonCustomization.textFontColor.isNullOrBlank().not()) {
                primaryButtonCustomisation.enabledTextColor =
                    primaryButtonCustomization.textFontColor
                hasValue = true;
            }

            if (primaryButtonCustomization.backgroundColor.isNullOrBlank().not()) {
                primaryButtonCustomisation.enabledBackgroundColor =
                    primaryButtonCustomization.backgroundColor
                hasValue = true;
            }

            if (themeConfig.uiCustomization != null && hasValue) {
                themeConfig.uiCustomization?.buttonCustomization?.primaryButtonCustomization =
                    primaryButtonCustomisation
            }
        }
    }

}