package com.payu.threeDS2.utils

import android.content.Context
import android.os.Build
import com.payu.payuanalytics.analytics.factory.AnalyticsFactory
import com.payu.payuanalytics.analytics.model.AnalyticsConfig
import com.payu.payuanalytics.analytics.model.AnalyticsType
import com.payu.payuanalytics.analytics.model.ClevertapAnalytics
import com.payu.threeDS2.BuildConfig
import com.payu.threeDS2.config.InternalConfig
import com.payu.threeDS2.constants.LoggingConstants
import org.json.JSONObject

object CleverTapLoggingUtils {
    private var clevertapAnalytics: ClevertapAnalytics? = null

    fun logAnalytics(
        context: Context,
        eventName: String,
        status: String = "",
        isSeamless: Boolean? = null
    ) {

        if (clevertapAnalytics == null) {
            clevertapAnalytics =
                AnalyticsFactory(context, AnalyticsConfig().apply {
                    initiatorIdentifier = LoggingConstants.THREE_DS_PACKAGE_CORE
                    ctAccountId = BuildConfig.ctAccountId
                    ctPassCode = BuildConfig.ctPassCode
                }).getAnalyticsClass(AnalyticsType.CLEVERTAP) as ClevertapAnalytics
        }

        val eventMap = HashMap<String, Any>()
        val eventData = HashMap<String, Any>()
        val txnId = InternalConfig.requestId
        val merchantKey = InternalConfig.key
        eventMap[LoggingConstants.THREE_DS_EVENT_NAME] = eventName
        eventMap[LoggingConstants.THREE_DS_IDENTITY] = txnId.plus(merchantKey)
        eventMap[LoggingConstants.THREE_DS_TYPE] = LoggingConstants.THREE_DS_EVENT
        if (!status.isNullOrEmpty())
            eventData[LoggingConstants.THREE_DS_DEVICE_DETAILS_STATUS] = status
        merchantKey?.let {
            eventData[LoggingConstants.THREE_DS_MERCHANT_IDENTIFIER] = it
        }
        eventData[LoggingConstants.THREE_DS_DEVICE] = LoggingConstants.THREE_DS_ANDROID
        eventData[LoggingConstants.THREE_DS_DEVICE_NAME] =
            Build.MANUFACTURER.plus(" " + Build.MODEL)
        eventData[LoggingConstants.THREE_DS_DEVICE_VERSION] = Build.VERSION.RELEASE
        eventData[LoggingConstants.THREE_DS_SDK_VERSION] = BuildConfig.VERSION_NAME
        isSeamless?.let {
            eventData[LoggingConstants.THREE_DS_IS_SEAMLESS_FLOW] = it
        }
        txnId?.let {
            eventData[LoggingConstants.THREE_DS_TXNID] = it
        }

        eventMap[LoggingConstants.THREE_DS_EVENT_DATA] = eventData
        clevertapAnalytics?.log(JSONObject(eventMap as Map<*, *>?).toString())
    }

}