package com.payu.threeDS2.network

import com.payu.paymentparamhelper.HashCommand
import com.payu.paymentparamhelper.PaymentParams
import com.payu.paymentparamhelper.PaymentPostParams
import com.payu.paymentparamhelper.PayuConstants
import com.payu.paymentparamhelper.PostData
import com.payu.threeDS2.config.InternalConfig
import com.payu.threeDS2.constants.LoggingConstants.Companion.LOGGING_ERROR_KEY
import com.payu.threeDS2.constants.LoggingConstants.Companion.SECURE_TAG
import com.payu.threeDS2.constants.PayU3DS2Constants
import com.payu.threeDS2.interfaces.listeners.PayU3DS2APIService
import com.payu.threeDS2.interfaces.listeners.PayUAsyncTaskResponse
import com.payu.threeDS2.utils.HashGenerationUtils
import com.payu.threeDS2.utils.LoggingUtils
import com.payu.threedsbase.constants.APIConstants
import com.payu.threedsbase.constants.PayU3DS2ErrorConstants
import com.payu.threedsbase.constants.PayU3DS2ErrorConstants.Companion.HASH_NULL_ERROR_CODE
import com.payu.threedsbase.constants.PayU3DS2ErrorConstants.Companion.HASH_NULL_ERROR_MESSAGE
import com.payu.threedsbase.constants.PayU3DS2ErrorConstants.Companion.SDK_RESPONSE_STATUS_CODE_1
import com.payu.threedsbase.data.ErrorResponse
import com.payu.threedsbase.data.apiResponse.PArsResponse
import com.payu.threedsbase.interfaces.listeners.PayU3DS2Callback
import com.payu.threedsbase.interfaces.listeners.PayUHashGeneratedListener
import org.json.JSONObject

class InitiatePaymentAPITask(private val apiLayer: PayU3DSAPILayer) : PayU3DS2APIService {
    private var authOnlyValue = APIConstants.AUTH_WITH_PAYU
    override fun callAPI(request: Any, callback: PayU3DS2Callback) {
        generateHash(request, callback, object : PayUHashGeneratedListener {
            override fun onHashGenerated(map: HashMap<String, String>) {
                val hash = map[HashCommand.PaymentHash.hashName]
                if (hash.isNullOrEmpty()) {
                    callback.onError(HASH_NULL_ERROR_CODE, HASH_NULL_ERROR_MESSAGE)
                } else {
                    val postData = generatePostData(
                        request as PaymentParams,
                        hash
                    )
                    if ((postData as PostData).status.equals(
                            PayU3DS2Constants.ERROR,
                            ignoreCase = true
                        )
                    ) {
                        callback.onError(postData.code, postData.result)
                    } else {
                        val networkData = PayUNetworkData()
                        networkData.url =
                            if (apiLayer.config.isProduction) APIConstants.SECURE_URL else
                                APIConstants.UAT_SECURE_URL

                        if (InternalConfig.authenticateOnly)
                            authOnlyValue = APIConstants.AUTH_OUTSIDE_PAYU

                        networkData.postRequest =
                            "${postData.result}&${APIConstants.TXN_S2S_FLOW}=${APIConstants.TXN_S2S_FLOW_VALUE}&" +
                                    "${APIConstants.AUTH_ONLY}=${authOnlyValue}&" +
                                    "${APIConstants.TERM_URL}=${if (apiLayer.config.isProduction) APIConstants.TERM_URL_VALUE else APIConstants.UAT_TERM_URL_VALUE}"
                        PayU3DSAPICall().makePostAPICall(
                            APIConstants.HTTP_REQUEST_TYPE_POST,
                            networkData,
                            object : PayUAsyncTaskResponse {
                                override fun onSuccess(response: Any, executionTime: Long) {
                                    val jsonObject =
                                        JSONObject(response.toString()).optJSONObject(APIConstants.PAYMENT_API_RESULT)
                                    val postToBank =
                                        jsonObject?.optJSONObject(APIConstants.PAYMENT_API_POST_TO_BANK)
                                    if (postToBank == null) {
                                        val error =
                                            JSONObject(response.toString()).optString(APIConstants.ERROR)
                                        if (!error.isNullOrEmpty()) {
                                            LoggingUtils.logMessage(
                                                apiLayer.activity!!,
                                                SECURE_TAG,
                                                LOGGING_ERROR_KEY + PayU3DS2ErrorConstants.HASH_ISSUE_ERROR_MESSAGE,
                                                executionTime
                                            )
                                            if (error.equals(APIConstants.HASH_ERROR_CODE))
                                                callback.onError(
                                                    PayU3DS2ErrorConstants.HASH_ISSUE_ERROR_CODE,
                                                    PayU3DS2ErrorConstants.HASH_ISSUE_ERROR_MESSAGE
                                                )
                                            else {
                                                LoggingUtils.logMessage(
                                                    apiLayer.activity!!,
                                                    SECURE_TAG,
                                                    LOGGING_ERROR_KEY + JSONObject(response.toString()).optString(
                                                        APIConstants.PAYMENT_API_ERROR_MESSAGE,

                                                        ),
                                                    executionTime
                                                )
                                                callback.onError(
                                                    SDK_RESPONSE_STATUS_CODE_1,
                                                    JSONObject(response.toString()).optString(
                                                        APIConstants.PAYMENT_API_ERROR_MESSAGE
                                                    )
                                                )
                                            }
                                        } else {
                                            val metaData =
                                                JSONObject(response.toString()).optJSONObject(
                                                    APIConstants.PAYMENT_API_META_DATA
                                                )
                                            if (metaData != null) {
                                                LoggingUtils.logMessage(
                                                    apiLayer.activity!!,
                                                    SECURE_TAG,
                                                    LOGGING_ERROR_KEY + metaData.optString(
                                                        APIConstants.PAYMENT_API_ERROR_MESSAGE
                                                    ),
                                                    executionTime
                                                )

                                                callback.onError(
                                                    SDK_RESPONSE_STATUS_CODE_1,
                                                    metaData.optString(APIConstants.PAYMENT_API_ERROR_MESSAGE)
                                                )
                                            } else {
                                                LoggingUtils.logMessage(
                                                    apiLayer.activity!!,
                                                    SECURE_TAG,
                                                    LOGGING_ERROR_KEY + PayU3DS2ErrorConstants.SOMETHING_WENT_WRONG_ERROR_MESSAGE,
                                                    executionTime
                                                )
                                                callback.onError(
                                                    SDK_RESPONSE_STATUS_CODE_1,
                                                    PayU3DS2ErrorConstants.SOMETHING_WENT_WRONG_ERROR_MESSAGE
                                                )
                                            }
                                        }
                                    } else {
                                        InternalConfig.referenceId =
                                            postToBank.optString(APIConstants.REFERENCE_ID)
                                        callback.onSuccess(parseData(postToBank))
                                    }
                                }

                                override fun onFailure(
                                    errorCode: Int,
                                    errorMessage: String,
                                    executionTime: Long
                                ) {
                                    LoggingUtils.logMessage(
                                        apiLayer.activity!!,
                                        SECURE_TAG,
                                        LOGGING_ERROR_KEY + errorMessage, executionTime
                                    )
                                    callback.onError(errorCode, errorMessage)
                                }
                            }
                        )
                    }
                }
            }
        })

    }

    override fun validate(paymentParams: PaymentParams): ErrorResponse {
        return ErrorResponse()
    }

    override fun generateHash(
        param: Any,
        callback: PayU3DS2Callback,
        payUHashGeneratedListener: PayUHashGeneratedListener
    ) {
        return HashGenerationUtils.getHash(
            HashCommand.PaymentHash,
            param as PaymentParams,
            callback, payUHashGeneratedListener
        )
    }

    override fun generatePostData(request: PaymentParams, hash: String): Any? {
        request.hash = hash
        return PaymentPostParams(request, PayuConstants.CC).paymentPostParams
    }

    private fun parseData(jsonObject: JSONObject): PArsResponse {
        val parsResponse = PArsResponse()
        parsResponse.cavv = jsonObject.optString(APIConstants.CAVV)
        parsResponse.eci = jsonObject.optString(APIConstants.ECI)
        parsResponse.threeDSTransID = jsonObject.optString(APIConstants.THREE_DS_TRANS_ID)
        parsResponse.threeDSTransStatus =
            jsonObject.optString(APIConstants.THREE_DS_TRANS_STATUS)
        parsResponse.threeDSVersion = jsonObject.optString(APIConstants.THREE_DS_VERSION)
        parsResponse.threeDSTransStatusReason =
            jsonObject.optString(APIConstants.THREE_DS_TRANS_STATUS_REASON)
        parsResponse.threeDSServerTransID =
            jsonObject.optString(APIConstants.THREE_DS_SERVER_TRANS_ID)
        parsResponse.acsSignedContent = jsonObject.optString(APIConstants.ACS_SIGNED_CONTENT)
        parsResponse.acsReferenceNumber = jsonObject.optString(APIConstants.ACS_REFERENCE_NUMBER)
        parsResponse.acsTransID = jsonObject.optString(APIConstants.ACS_TRANS_ID)
        return parsResponse
    }

}