package com.payu.threeDS2.utils

import com.payu.paymentparamhelper.HashCommand
import com.payu.paymentparamhelper.PaymentParams
import com.payu.threedsbase.constants.APIConstants
import com.payu.threeDS2.constants.PayU3DS2Constants

object PostDataGeneratorUtils {
    /**
     * This method helps in generating POSTDATA which we pass to backend in API requests
     */
    internal fun generatePostData(
        command: String,
        hash: String,
        param: PaymentParams,
    ): String? {
        when (command) {
            HashCommand.BinInfoHash.hashName -> {
                val postData = StringBuilder()
                postData.append(Utils.concatParams(PayU3DS2Constants.KEY, param.key))
                postData.append(Utils.concatParams(PayU3DS2Constants.HASH, hash))
                postData.append(Utils.concatParams(PayU3DS2Constants.COMMAND, command))
                postData.append(
                    Utils.concatParams(
                        PayU3DS2Constants.VAR1,
                        APIConstants.BIN_INFO_VAR1_VALUE
                    )
                )
                if (!param.cardBin.isNullOrEmpty())
                    postData.append(Utils.concatParams(PayU3DS2Constants.VAR2, param.cardBin))
                else postData.append(Utils.concatParams(PayU3DS2Constants.VAR2, param.cardToken))
                postData.append(
                    Utils.concatParams(
                        PayU3DS2Constants.VAR7,
                        APIConstants.BIN_INFO_VAR7_VALUE
                    )
                )

                if (param.siParams != null)
                    postData.append(
                        Utils.concatParams(
                            PayU3DS2Constants.VAR5,
                            APIConstants.BIN_INFO_VAR5_VALUE
                        )
                    )

                return Utils.trimAmpersand(postData.toString())
            }
            HashCommand.AuthorizePaymentHash.hashName -> {
                val postData = StringBuilder()
                postData.append(Utils.concatParams(PayU3DS2Constants.KEY, param.key))
                postData.append(Utils.concatParams(PayU3DS2Constants.TXN_ID, param.txnId))
                postData.append(Utils.concatParams(PayU3DS2Constants.AMOUNT, param.amount))
                postData.append(Utils.concatParams(PayU3DS2Constants.HASH, hash))
                postData.append(
                    Utils.concatParams(
                        APIConstants.AUTHENTICATION_INFO,
                        APIConstants.AUTHENTICATION_INFO_VALUE
                    )
                )

                return Utils.trimAmpersand(postData.toString())
            }
        }

        return null
    }


}