package com.payu.threeDS2.utils

import android.content.Context
import com.payu.threeDS2.constants.PayU3DS2Constants.Companion.DD_MM_YY_HH_MM_SS_DATE_FORMAT
import com.payu.threeDS2.network.TLSSocketFactory
import com.payu.threedsbase.constants.APIConstants
import com.payu.threedsbase.constants.PayU3DS2ErrorConstants
import com.payu.threedsbase.data.PayU3DS2DeviceWarning
import com.payu.threedsbase.enums.ACSActionType
import com.payu.threedsbase.enums.DeviceSeverity
import com.payu.threedsui.uiCustomisation.BottomSheetCustomisation
import com.payu.threedsui.uiCustomisation.ButtonCustomisation
import com.payu.threedsui.uiCustomisation.FontFamilyCustomisation
import com.payu.threedsui.uiCustomisation.LabelCustomisation
import com.payu.threedsui.uiCustomisation.TextBoxCustomisation
import com.payu.threedsui.uiCustomisation.ToolbarCustomisation
import com.payu.threedsui.uiCustomisation.UICustomisation
import com.payu.threedsui.uiCustomisation.enums.ButtonTextCaseType
import com.payu.threedsui.uiCustomisation.enums.FontName
import com.wibmo.threeds2.sdk.cfg.BottomSheetButtonCustomization
import com.wibmo.threeds2.sdk.cfg.BottomSheetLabelCustomization
import com.wibmo.threeds2.sdk.cfg.ButtonCustomization
import com.wibmo.threeds2.sdk.cfg.FontFamilyCustomization
import com.wibmo.threeds2.sdk.cfg.LabelCustomization
import com.wibmo.threeds2.sdk.cfg.Severity
import com.wibmo.threeds2.sdk.cfg.TextBoxCustomization
import com.wibmo.threeds2.sdk.cfg.ToolbarCustomization
import com.wibmo.threeds2.sdk.cfg.UiCustomization
import com.wibmo.threeds2.sdk.cfg.Warning
import com.wibmo.threeds2.sdk.error.InvalidInputException
import com.wibmo.threeds2.sdk.event.ActionType
import java.io.FileOutputStream
import java.io.IOException
import java.io.InputStream
import java.net.URL
import java.text.SimpleDateFormat
import java.util.Date
import java.util.zip.GZIPInputStream
import javax.net.ssl.HttpsURLConnection

object Utils {

    fun mapUICustomisationToWibmo(uiCustomisation: UICustomisation?): UiCustomization? {
//        if (uiCustomisation == null)
//            return null
//        val wibmoUICustomisation = UiCustomization()
        val wibmoUICustomisation = UiCustomization()
        if (uiCustomisation == null)
            return wibmoUICustomisation

        mapButtonCustomisation(uiCustomisation.buttonCustomisation, wibmoUICustomisation)
        mapToolbarCustomisation(uiCustomisation.toolbarCustomisation, wibmoUICustomisation)
        mapLabelCustomisation(uiCustomisation.labelCustomisation, wibmoUICustomisation)
        mapTextboxCustomisation(uiCustomisation.textBoxCustomisation, wibmoUICustomisation)
        mapBottomSheetCustomisation(
            uiCustomisation.bottomSheetCustomisation,
            wibmoUICustomisation
        )
        mapFontFamilyCustomisation(uiCustomisation.fontFamilyCustomisation, wibmoUICustomisation)
        wibmoUICustomisation.themeType = UiCustomization.UICustomizationType.DEFAULT.name

        return wibmoUICustomisation
    }

    private fun mapTextboxCustomisation(
        textBoxCustomisation: TextBoxCustomisation?,
        wibmoUICustomisation: UiCustomization
    ) {
        if (textBoxCustomisation != null) {
            val textBoxCustomization = TextBoxCustomization()
            if (ColorValidator.validateHexColor(textBoxCustomisation.textColor))
                textBoxCustomization.textColor = textBoxCustomisation.textColor
            if (textBoxCustomisation.textFontName != null)
                textBoxCustomization.textFontName =
                    mapPayUFontToWibmoFont(textBoxCustomisation.textFontName!!).name
            if (ColorValidator.validateHexColor(textBoxCustomisation.borderColor))
                textBoxCustomization.borderColor = textBoxCustomisation.borderColor
            if (textBoxCustomisation.borderWidth != null)
                textBoxCustomization.borderWidth = textBoxCustomisation.borderWidth!!
            if (textBoxCustomisation.cornerRadius != null)
                textBoxCustomization.cornerRadius = textBoxCustomisation.cornerRadius!!
            if ((textBoxCustomisation.cornerRadius != null || ColorValidator.validateHexColor(
                    textBoxCustomisation.borderColor
                )) &&
                textBoxCustomisation.borderWidth == null
            )
                textBoxCustomization.borderWidth = 1
            if (textBoxCustomisation.textFontSize != null)
                textBoxCustomization.textFontSize = textBoxCustomisation.textFontSize!!
            wibmoUICustomisation.textBoxCustomization = textBoxCustomization
        }
    }

    private fun mapLabelCustomisation(
        labelCustomization: LabelCustomisation?,
        wibmoUICustomisation: UiCustomization
    ) {
        if (labelCustomization != null) {
            val labelCustomisation = LabelCustomization()
            if (ColorValidator.validateHexColor(labelCustomization.headingTextColor))
                labelCustomisation.headingTextColor = labelCustomization.headingTextColor
            if (labelCustomization.headingTextFontName != null)
                labelCustomisation.headingTextFontName =
                    mapPayUFontToWibmoFont(labelCustomization.headingTextFontName!!).name
            if (labelCustomization.headingTextFontSize != null)
                labelCustomisation.headingTextFontSize = labelCustomization.headingTextFontSize!!
            if (ColorValidator.validateHexColor(labelCustomization.textColor))
                labelCustomisation.textColor = labelCustomization.textColor
            if (labelCustomization.textFontName != null)
                labelCustomisation.textFontName =
                    mapPayUFontToWibmoFont(labelCustomization.textFontName!!).name
            if (labelCustomization.textFontSize != null)
                labelCustomisation.textFontSize = labelCustomization.textFontSize!!
            wibmoUICustomisation.labelCustomization = labelCustomisation
        }
    }

    private fun mapToolbarCustomisation(
        toolbarCustomisation: ToolbarCustomisation?,
        wibmoUICustomisation: UiCustomization
    ) {
        if (toolbarCustomisation != null) {
            val toolbarCustomization = ToolbarCustomization()
            if (ColorValidator.validateHexColor(toolbarCustomisation.backgroundColor))
                toolbarCustomization.backgroundColor = toolbarCustomisation.backgroundColor
            if (ColorValidator.validateHexColor(toolbarCustomisation.textColor))
                toolbarCustomization.textColor = toolbarCustomisation.textColor
            if (!toolbarCustomisation.buttonText.isNullOrEmpty())
                toolbarCustomization.buttonText = toolbarCustomisation.buttonText
            if (toolbarCustomisation.textFontName != null)
                toolbarCustomization.textFontName =
                    mapPayUFontToWibmoFont(toolbarCustomisation.textFontName!!).name
            if (toolbarCustomisation.textFontSize != null)
                toolbarCustomization.textFontSize = toolbarCustomisation.textFontSize!!
            if (!toolbarCustomisation.headerText.isNullOrEmpty())
                toolbarCustomization.headerText = toolbarCustomisation.headerText
            wibmoUICustomisation.toolbarCustomization = toolbarCustomization
        }
    }

    private fun mapButtonCustomisation(
        buttonCustomisation: ButtonCustomisation?,
        wibmoUICustomisation: UiCustomization
    ) {
        if (buttonCustomisation != null) {
            val buttonCustomization = ButtonCustomization()
            if (ColorValidator.validateHexColor(buttonCustomisation.backgroundColor))
                buttonCustomization.backgroundColor =
                    buttonCustomisation.backgroundColor
            if (buttonCustomisation.cornerRadius != null)
                buttonCustomization.cornerRadius =
                    buttonCustomisation.cornerRadius!!
            if (buttonCustomisation.textCaseType != null)
                buttonCustomization.textTransform =
                    mapPayuTextCaseToWibmo(buttonCustomisation.textCaseType!!)
            if (buttonCustomisation.textFontSize != null)
                buttonCustomization.textFontSize = buttonCustomisation.textFontSize!!
            if (ColorValidator.validateHexColor(buttonCustomisation.textFontColor))
                buttonCustomization.textColor = buttonCustomisation.textFontColor
            if (ColorValidator.validateHexColor(buttonCustomisation.resendTextFontColor))
                buttonCustomization.resendTextColor = buttonCustomisation.resendTextFontColor

            wibmoUICustomisation.setButtonCustomization(
                buttonCustomization,
                UiCustomization.ButtonType.VERIFY
            )
        }
    }

    private fun mapFontFamilyCustomisation(
        fontFamilyCustomisation: FontFamilyCustomisation?,
        wibmoUICustomisation: UiCustomization
    ) {
        if (fontFamilyCustomisation != null) {
            val fontFamilyCustomization = FontFamilyCustomization()

            if (!fontFamilyCustomisation.headerFontFamily.isNullOrEmpty())
                fontFamilyCustomization.headerFontFamilyPath =
                    fontFamilyCustomisation.headerFontFamily

            if (!fontFamilyCustomisation.subTextFontFamily.isNullOrEmpty())
                fontFamilyCustomization.textFontFamilyPath =
                    fontFamilyCustomisation.subTextFontFamily

            wibmoUICustomisation.fontFamilyCustomization = fontFamilyCustomization
        }
    }

    fun concatParams(key: String, value: String): String {
        return "$key=$value&"
    }

    fun trimAmpersand(data: String): String {
        return if (data[data.length - 1] == '&') data.substring(0, data.length - 1) else data
    }

    fun mapWibmoWarningsToDeviceWarning(warningList: List<Warning>): List<PayU3DS2DeviceWarning> {
        val warnings = mutableListOf<PayU3DS2DeviceWarning>()
        for (warning in warningList
        ) {
            warnings.add(
                PayU3DS2DeviceWarning(
                    warning.id,
                    warning.message,
                    mapWarningSeverityToDeviceSeverity(warning.severity)
                )
            )
        }

        return warnings
    }

    private fun mapWarningSeverityToDeviceSeverity(severity: Severity): DeviceSeverity {
        return when (severity) {
            Severity.LOW -> DeviceSeverity.LOW
            Severity.MEDIUM -> DeviceSeverity.MEDIUM
            Severity.HIGH -> DeviceSeverity.HIGH
        }
    }

    private fun mapPayUFontToWibmoFont(fontType: FontName): UiCustomization.FontType {
        return when (fontType) {
            FontName.ROBOTO_MEDIUM -> UiCustomization.FontType.ROBOTO_MEDIUM
            FontName.ROBOTO_REGULAR -> UiCustomization.FontType.ROBOTO_REGULAR
        }
    }

    fun getHttpsConn(strURL: String?): HttpsURLConnection? {
        return try {
            val url = URL(strURL)
            val conn = url.openConnection() as HttpsURLConnection
            conn.requestMethod = APIConstants.HTTP_REQUEST_TYPE_GET
            conn.sslSocketFactory = TLSSocketFactory()
            conn.setRequestProperty(
                APIConstants.ACCEPT_CHARSET,
                APIConstants.ACCEPT_CHARSET_VALUE
            )
            conn
        } catch (e: java.lang.Exception) {
            null
        }
    }


    fun writeFileOutputStream(
        inputStream: InputStream?,
        context: Context,
        fileName: String?,
        contextMode: Int
    ) {
        try {
            val responseInputStream = GZIPInputStream(inputStream)
            val buf = ByteArray(1024)
            var len: Int
            val outputStream: FileOutputStream = context.openFileOutput(fileName, contextMode)
            while (responseInputStream.read(buf).also { len = it } > 0) {
                outputStream.write(buf, 0, len)
            }
            responseInputStream.close()
            outputStream.close()
        } catch (e: IOException) {
        } catch (e: java.lang.Exception) {
        }
    }

    fun getCurrentDateInDDMMYYHHMMSSFormat(): String {
        val sdf = SimpleDateFormat(DD_MM_YY_HH_MM_SS_DATE_FORMAT)
        return sdf.format(Date())
    }

    fun mapBottomSheetCustomisationToWibmoCustomisation(
        uiCustomisation: UICustomisation
    ): UiCustomization {
        val uiCustomization = UiCustomization()
        mapBottomSheetCustomisation(
            uiCustomisation.bottomSheetCustomisation,
            uiCustomization
        )
        return uiCustomization
    }

    private fun mapBottomSheetCustomisation(
        bottomSheetCustomisation: BottomSheetCustomisation?,
        wibmoUICustomisation: UiCustomization
    ) {
        if (bottomSheetCustomisation != null) {
            val bsBtnCustomization = BottomSheetButtonCustomization()
            if (ColorValidator.validateHexColor(bottomSheetCustomisation.buttonBackgroundColor))
                bsBtnCustomization.backgroundColor =
                    bottomSheetCustomisation.buttonBackgroundColor
            if (bottomSheetCustomisation.cornerRadius != null)
                bsBtnCustomization.cornerRadius =
                    bottomSheetCustomisation.cornerRadius!!
            if (ColorValidator.validateHexColor(bottomSheetCustomisation.textFontColor))
                bsBtnCustomization.textColor = bottomSheetCustomisation.textFontColor
            if (bottomSheetCustomisation.textFontSize != null)
                bsBtnCustomization.textFontSize = bottomSheetCustomisation.textFontSize!!
            if (bottomSheetCustomisation.textCaseType != null)
                bsBtnCustomization.textTransform =
                    mapPayuTextCaseToWibmo(bottomSheetCustomisation.textCaseType!!)
            if (ColorValidator.validateHexColor(bottomSheetCustomisation.resendTextFontColor))
                bsBtnCustomization.resendTextColor =
                    bottomSheetCustomisation.resendTextFontColor

            wibmoUICustomisation.bottomSheetButtonCustomization = bsBtnCustomization


            val bsLabelCustomization = BottomSheetLabelCustomization()
            if (bottomSheetCustomisation.labelTextFontSize != null)
                bsLabelCustomization.textFontSize = bottomSheetCustomisation.labelTextFontSize!!
            if (bottomSheetCustomisation.headingTextFontSize != null)
                bsLabelCustomization.headingTextFontSize =
                    bottomSheetCustomisation.headingTextFontSize!!
            wibmoUICustomisation.bottomSheetLabelCustomization = bsLabelCustomization

        }
    }

    private fun mapPayuTextCaseToWibmo(buttonTextCaseType: ButtonTextCaseType): String {
        return when (buttonTextCaseType) {
            ButtonTextCaseType.LOWER_CASE -> UiCustomization.ButtonTextTransformType.LOWER_CASE.name
            ButtonTextCaseType.UPPER_CASE -> UiCustomization.ButtonTextTransformType.UPPER_CASE.name
        }
    }

    fun getTimeDifferenceInMilliSeconds(apiCalledTime: Long): Long {
        return System.currentTimeMillis() - apiCalledTime
    }

    fun mapPayUActionTypeToWibmoActionType(acsActionType: ACSActionType): ActionType {
        return when (acsActionType) {
            ACSActionType.CANCEL -> ActionType.CANCEL
            ACSActionType.RESEND -> ActionType.RESEND
            ACSActionType.SUBMIT -> ActionType.SUBMIT
        }
    }

    fun mapWibmoActionTypeToPayUActionType(actionType: ActionType): ACSActionType {
        return when (actionType) {
            ActionType.CANCEL -> ACSActionType.CANCEL
            ActionType.RESEND -> ACSActionType.RESEND
            ActionType.SUBMIT -> ACSActionType.SUBMIT
        }
    }

    internal fun validateCustomACSContent(amount: String?, merchantName: String?) {
        if (amount == null || amount.toDoubleOrNull() == null || amount.toDouble() < 1)
            throw InvalidInputException(PayU3DS2ErrorConstants.INVALID_AMOUNT)
        if (merchantName?.trim().isNullOrEmpty())
            throw InvalidInputException(PayU3DS2ErrorConstants.INVALID_MERCHANT_NAME)
    }

}