package com.payu.threeDS2.utils

import android.os.Handler
import android.os.Looper
import com.payu.paymentparamhelper.HashCommand
import com.payu.paymentparamhelper.HashStringHelper
import com.payu.paymentparamhelper.PaymentParams
import com.payu.threedsbase.constants.PayU3DS2ErrorConstants.Companion.HASH_TIMED_OUT
import com.payu.threedsbase.constants.PayU3DS2ErrorConstants.Companion.SDK_RESPONSE_STATUS_CODE_1
import com.payu.threedsbase.interfaces.listeners.PayU3DS2Callback
import com.payu.threedsbase.interfaces.listeners.PayUHashGeneratedListener
import java.util.*
import kotlin.collections.HashMap

object HashGenerationUtils {
    private const val hashTimeout = 10000L

    /**
     * This method helps in generating hash string which we send to merchant to generate hash and
     * return hash value after getting callback from merchant
     */
    fun getHash(
        key: String,
        commandName: HashCommand,
        callback: PayU3DS2Callback,
        payUHashGeneratedListener: PayUHashGeneratedListener
    ) {
        val hashString =
            HashStringHelper().getHashString(key, commandName)

        requestHash(callback, hashString, payUHashGeneratedListener)
    }

    /**
     * This method helps in generating hash string which we send to merchant to generate hash and
     * return hash value after getting callback from merchant
     */
    fun getHash(
        commandName: HashCommand,
        paymentParams: PaymentParams,
        callback: PayU3DS2Callback,
        payUHashGeneratedListener: PayUHashGeneratedListener
    ) {
        val hashString =
            HashStringHelper().getHashString(commandName, paymentParams)

        requestHash(callback, hashString, payUHashGeneratedListener)
    }

    /**
     * This method helps in generating hash string which we send to merchant to generate hash and
     * return hash value after getting callback from merchant
     */
    fun getHash(
        key: String,
        mihPayId: String,
        utcDate: String,
        commandName: HashCommand,
        callback: PayU3DS2Callback,
        payUHashGeneratedListener: PayUHashGeneratedListener
    ) {
        val hashString =
            HashStringHelper().getHashString(key, mihPayId, utcDate, commandName)

        requestHash(callback, hashString, payUHashGeneratedListener)
    }

    /**
     * Method to request hash from merchant and return callback after if hash
     * not received post a specific timeout.
     */
    private fun requestHash(
        callback: PayU3DS2Callback,
        hashString: HashMap<String, String>,
        payUHashGeneratedListener: PayUHashGeneratedListener
    ) {
        var isHashTimedOut = false
        var isHasGenerated = false
        val timerObj = Timer()
        val timerTaskObj: TimerTask = object : TimerTask() {
            override fun run() {
                if (!isHashTimedOut && !isHasGenerated) {
                    Handler(Looper.getMainLooper()).post {
                        callback.onError(SDK_RESPONSE_STATUS_CODE_1, HASH_TIMED_OUT)
                    }
                }
                isHashTimedOut = true
            }
        }
        timerObj.schedule(timerTaskObj, hashTimeout)

        callback.generateHash(hashString, object : PayUHashGeneratedListener {
            override fun onHashGenerated(map: HashMap<String, String>) {
                if (!isHashTimedOut)
                    payUHashGeneratedListener.onHashGenerated(map)
                isHasGenerated = true
            }
        })
    }
}