package com.payu.threeDS2.utils

import java.util.regex.Matcher
import java.util.regex.Pattern

object ColorValidator {
    private var pattern: Pattern? = null
    private var matcher: Matcher? = null

    internal fun validateHexColor(hexColorCode: String?): Boolean {
        return if (hexColorCode?.trim().isNullOrEmpty())
            false
        else {
            val hexPattern = "^#([A-Fa-f0-9]{6})$"
            pattern = Pattern.compile(hexPattern)
            matcher = pattern!!.matcher(hexColorCode)
            matcher!!.matches()
        }
    }
}