package com.payu.threeDS2.network

import com.payu.paymentparamhelper.HashCommand
import com.payu.paymentparamhelper.PaymentParams
import com.payu.threeDS2.config.InternalConfig
import com.payu.threeDS2.constants.LoggingConstants.Companion.AUTHENTICATE_PAYMENT_TAG
import com.payu.threeDS2.constants.LoggingConstants.Companion.LOGGING_ERROR_KEY
import com.payu.threeDS2.constants.PayU3DS2Constants
import com.payu.threeDS2.interfaces.listeners.PayU3DS2APIService
import com.payu.threeDS2.interfaces.listeners.PayUAsyncTaskResponse
import com.payu.threeDS2.utils.HashGenerationUtils
import com.payu.threeDS2.utils.LoggingUtils
import com.payu.threeDS2.utils.Utils
import com.payu.threedsbase.constants.APIConstants
import com.payu.threedsbase.constants.APIConstants.Companion.FAILURE
import com.payu.threedsbase.constants.APIConstants.Companion.HTTP_REQUEST_TYPE_GET
import com.payu.threedsbase.constants.PayU3DS2ErrorConstants.Companion.HASH_NULL_ERROR_CODE
import com.payu.threedsbase.constants.PayU3DS2ErrorConstants.Companion.HASH_NULL_ERROR_MESSAGE
import com.payu.threedsbase.constants.PayU3DS2ErrorConstants.Companion.SDK_RESPONSE_STATUS_CODE_1
import com.payu.threedsbase.data.ErrorResponse
import com.payu.threedsbase.enums.APICommand
import com.payu.threedsbase.interfaces.listeners.PayU3DS2Callback
import com.payu.threedsbase.interfaces.listeners.PayUHashGeneratedListener
import org.json.JSONObject


class AuthenticateTransactionAPITask(private val apiLayer: PayU3DSAPILayer) : PayU3DS2APIService {
    private var utcDate = Utils.getCurrentDateInDDMMYYHHMMSSFormat()
    override fun callAPI(request: Any, callback: PayU3DS2Callback) {
        generateHash(request, callback, object : PayUHashGeneratedListener {
            override fun onHashGenerated(map: HashMap<String, String>) {
                val hash = map[HashCommand.AuthenticatePaymentHash.hashName]
                if (hash.isNullOrEmpty()) {
                    callback.onError(HASH_NULL_ERROR_CODE, HASH_NULL_ERROR_MESSAGE)
                } else {
                    val networkData = PayUNetworkData()
                    val headerMap = HashMap<String, String>()
                    val requestMap = HashMap<String, Any>()

                    headerMap[PayU3DS2Constants.KEY] = InternalConfig.key!!
                    headerMap[PayU3DS2Constants.HASH] = hash
                    headerMap[PayU3DS2Constants.DATE] = utcDate

                    requestMap[PayU3DS2Constants.REFERENCE_ID] = request as String
                    networkData.getRequest = requestMap
                    networkData.headerMap = headerMap
                    networkData.url =
                        if (apiLayer.config.isProduction) APIConstants.AUTHENTICATION_PAYMENT_URL else
                            APIConstants.UAT_AUTHENTICATION_PAYMENT_URL
                    PayU3DSAPICall().makePostAPICall(
                        HTTP_REQUEST_TYPE_GET,
                        networkData,
                        object : PayUAsyncTaskResponse {
                            override fun onSuccess(response: Any, executionTime: Long) {
                                val resp = JSONObject(response as String)
                                if (resp.getString(APIConstants.STATUS) == FAILURE) {
                                    LoggingUtils.logMessage(
                                        apiLayer.activity!!,
                                        AUTHENTICATE_PAYMENT_TAG,
                                        resp.getString(APIConstants.ERROR_MESSAGE),
                                        executionTime
                                    )
                                    callback.onError(
                                        SDK_RESPONSE_STATUS_CODE_1,
                                        resp.getString(APIConstants.ERROR_MESSAGE)
                                    )
                                }
                                else {
                                    LoggingUtils.logMessage(
                                        apiLayer.activity!!,
                                        AUTHENTICATE_PAYMENT_TAG,
                                        "",
                                        executionTime
                                    )
                                    callback.onSuccess(response)
                                }
                            }

                            override fun onFailure(errorCode: Int, errorMessage: String, executionTime: Long) {
                                LoggingUtils.logMessage(
                                    apiLayer.activity!!,
                                    AUTHENTICATE_PAYMENT_TAG,
                                    LOGGING_ERROR_KEY + errorMessage,
                                    executionTime
                                )
                                callback.onError(errorCode, errorMessage)
                            }
                        }
                    )
                }
            }
        })

    }

    override fun validate(paymentParams: PaymentParams): ErrorResponse {
        return ErrorResponse()
    }

    override fun generateHash(
        param: Any,
        callback: PayU3DS2Callback,
        payUHashGeneratedListener: PayUHashGeneratedListener
    ) {
        return HashGenerationUtils.getHash(
            InternalConfig.key!!,
            param as String,
            utcDate,
            HashCommand.AuthenticatePaymentHash,
            callback, payUHashGeneratedListener
        )
    }

    override fun generatePostData(request: PaymentParams, hash: String, isSi: Boolean): Any? {
        return null
    }
}