package com.payu.threeDS2.network

import android.app.Activity
import android.content.Context
import com.payu.paymentparamhelper.HashCommand
import com.payu.paymentparamhelper.PaymentParams
import com.payu.paymentparamhelper.PaymentPostParams
import com.payu.paymentparamhelper.PayuConstants
import com.payu.threeDS2.config.InternalConfig
import com.payu.threeDS2.config.PayU3DS2Config
import com.payu.threeDS2.utils.BottomSheetHelper
import com.payu.threeDS2.utils.HashGenerationUtils
import com.payu.threeDS2.utils.LoggingUtils
import com.payu.threeDS2.utils.PaymentParamUtils
import com.payu.threeDS2.utils.ThreeDSHelper
import com.payu.threeDS2.utils.Utils
import com.payu.threedsbase.constants.APIConstants
import com.payu.threedsbase.data.BaseApiLayer
import com.payu.threedsbase.data.CardData
import com.payu.threedsbase.data.ChallengeParameter
import com.payu.threedsbase.data.PArqResponse
import com.payu.threedsbase.data.PayU3DS2Response
import com.payu.threedsbase.data.apiRequest.CardBinInfoRequest
import com.payu.threedsbase.interfaces.listeners.FallbackPostDataListener
import com.payu.threedsbase.interfaces.listeners.PayU3DS2BaseCallback
import com.payu.threedsbase.interfaces.listeners.PayU3DS2Callback
import com.payu.threedsbase.interfaces.listeners.PayUHashGeneratedListener
import javax.net.ssl.HttpsURLConnection


class PayU3DSAPILayer(
    private var payU3DS2Config: PayU3DS2Config
) :
    BaseApiLayer(payU3DS2Config) {
    internal var activity: Activity? = null

    constructor(
        payU3DS2Config: PayU3DS2Config,
        paymentParams: PaymentParams
    ) : this(payU3DS2Config) {
        this.payU3DS2Config = payU3DS2Config
        this.paymentParams = paymentParams
    }

    override fun fetchBinInfo(cardBinInfoRequest: CardBinInfoRequest, callback: PayU3DS2Callback) {
        GetBinInfoAPITask(this).callAPI(cardBinInfoRequest, callback)
    }

    override fun initiatePayment(callback: PayU3DS2Callback) {
        InitiatePaymentAPITask(this).callAPI(
            paymentParams, callback
        )
    }

    override fun authorizePayment(callback: PayU3DS2Callback) {
        AuthorizeTransactionAPITask(this).callAPI(
            paymentParams, callback
        )
    }

    override fun getBankJS(url: String) {
        Utils.getHttpsConn(url)?.let {
            try {
                if (it.responseCode == HttpsURLConnection.HTTP_OK) {
                    Utils.writeFileOutputStream(
                        it.inputStream,
                        activity!!,
                        APIConstants.INITIAILIZE,
                        Context.MODE_PRIVATE
                    )
                }
            } catch (e: Exception) {
            }
        }
    }

    override fun isFallbackAllowed(): Boolean {
        return this.payU3DS2Config.fallback3DS1
    }

    override fun extractDeviceDetails(cardData: CardData): PayU3DS2Response {
        return ThreeDSHelper.extractDeviceDetails(cardData)
    }

    override fun initiateChallenge(
        activity: Activity,
        challengeParameter: ChallengeParameter,
        baseCallback: PayU3DS2BaseCallback
    ) {
        ThreeDSHelper.initiateChallenge(activity, challengeParameter, baseCallback)
    }

    override fun initialise3DSService(activity: Activity): PayU3DS2Response {
        return ThreeDSHelper.initialize(activity, this.payU3DS2Config)
    }

    override fun setContext(activity: Activity) {
        this.activity = activity
    }

    override fun updatePaymentParamsWithSDKInfo(pArqResponse: PArqResponse) {
        PaymentParamUtils().updateParamWithPArqAndSDKData(pArqResponse, this.paymentParams)
    }

    override fun generateFallbackPostData(
        hashCommand: HashCommand,
        callback: PayU3DS2Callback,
        fallbackPostDataListener: FallbackPostDataListener
    ) {

        HashGenerationUtils.getHash(
            hashCommand,
            this.paymentParams,
            callback, object : PayUHashGeneratedListener {
                override fun onHashGenerated(map: HashMap<String, String>) {
                    val hash = map[hashCommand.hashName]
                    /**
                     * Adding hash to payment params to help creating post data
                     */
                    paymentParams.hash = hash
                    /**
                     * setting it null so that when generating postData it will not add sdk info which is required
                     * for 3DS2 even though it will work.
                     */
                    paymentParams.sdkInfo = null
                    /**
                     * Updating SDK platform data to be send for kibana filtering
                     */
                    paymentParams.sdkPlatformData =
                        LoggingUtils.getAnalyticsString(paymentParams.sdkPlatformData)
                    val paymentPostParams = PaymentPostParams(
                        paymentParams,
                        if (paymentParams.pg.isNullOrEmpty().not())
                            paymentParams.pg
                        else
                            PayuConstants.CC
                    ).paymentPostParams
                    fallbackPostDataListener.onFallbackPostDataGenerated(paymentPostParams.result)
                }
            }
        )
    }

    override fun clean() {
        ThreeDSHelper.clean()
    }

    override fun logData(key: String, msg: String) {
        LoggingUtils.logMessage(activity!!, key, msg)
    }

    override fun isAuthenticationOnly(): Boolean {
        return InternalConfig.authenticateOnly
    }

    override fun authenticatePayment(callback: PayU3DS2Callback) {
        AuthenticateTransactionAPITask(this).callAPI(
            InternalConfig.referenceId!!, callback
        )
    }

    override fun showAutoReadBottomSheet(
        activity: Activity, hasSubmitButton: Boolean,
        isAutoSubmit: Boolean,
        submitListener: (String?) -> Unit
    ) {
        payU3DS2Config.uiCustomisation?.let {
            val uiCustomisation =
                Utils.mapBottomSheetCustomisationToWibmoCustomisation(it)
            BottomSheetHelper.showBottomSheet(
                activity,
                isAutoSubmit && hasSubmitButton,
                uiCustomisation,
                submitListener
            )
        }
    }

    override fun setOTP(otp: String) {
        BottomSheetHelper.setOTP(otp)
    }

    override fun dismissBottomSheet() {
        BottomSheetHelper.dismissBottomSheet()
    }

}