package com.payufin.mobilemsg.network
import android.content.Context
import android.os.Handler
import android.os.Looper
import android.util.Log
import com.google.gson.JsonObject
import com.payufin.mobilemsg.configurables.Constants
import com.payufin.mobilemsg.helper.HttpHelper
import com.payufin.mobilemsg.models.AuthRequestData
import com.payufin.mobilemsg.models.AuthResponseData
import com.payufin.mobilemsg.models.SmsBodyData
import com.payufin.mobilemsg.sms.SdkCallback
import com.payufin.mobilemsg.sms.checkpoint
import okhttp3.ResponseBody
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import java.nio.charset.StandardCharsets
import java.security.MessageDigest

class SMSAPIServiceImpl(
    private val context: Context,
    private var earliestMessageDate : Long,
    private var latestMessageDate : Long,
    private val apiMsgList : List<JsonObject>,
    private val Android_id : String,
    private val apiObj : SmsBodyData,
    private val apiString: String,
    private val parent_callback: SdkCallback
):
    Callback<ResponseBody> {
//    companion object {
//        var packetNum: Int = 0
//    }

    private var retryCount = 0
    private var authRetryCount = 0
    private val maxRetries = 3
    private var flag = 1
    private val initialBackoffTime = 1000 // Initial backoff time in milliseconds


    override fun onResponse(call: Call<ResponseBody>, response: Response<ResponseBody>) {
        if (response.isSuccessful) {
            // Handle successful response
            // updates the checkpoint on successful response
            if (apiMsgList.isNotEmpty() && (earliestMessageDate.toInt() == -1 || apiMsgList.last()
                    .get("date").asLong < earliestMessageDate)
            )
                earliestMessageDate = apiMsgList.last().get("date").asLong


            // Update the last synced index with the ID of the latest message processed
            // This is done after capturing the latestMessageId before the loop
            checkpoint.setLastSyncedIndex(
                context,
                latestMessageDate,
                earliestMessageDate
            )

            //packetNum++
            //parent_callback.SMSSyncSuccess("SMS Packet $packetNum successfully uploaded")

//            if (apiMsgList.isEmpty() && apiObj.sms_permission_available == true)
//                parent_callback.smsSyncSuccess("No SMS left to be synced")
//            if (apiMsgList.isEmpty() && apiObj.sms_permission_available == false)
//                parent_callback.permissionNotAvailable("Permission Not Available")



            Log.d("readSMS", "Latest Message Checkpoint: $latestMessageDate")
            Log.d("readSMS", "Earliest Message Checkpoint: $earliestMessageDate")


            val responseBody = response.code()
            Log.d("readSMS", "Response: $responseBody")

            Log.d("readSMS", "SMS uploaded successfully!")
        } else {
            Log.d("readSMS", "response code - ${response.code()} - ${response.message()}")
            if (shouldRetry(response.code())) {
                retry(call)
                if (flag == 1 && retryCount >= maxRetries) {
                    flag = 0
//                    parent_callback.onUploadFailure(
//                        response.code(),
//                        "SMS failure for packet : ${response.errorBody()?.string()}"
//                    )
                }
            } else if (response.code() == 401) {
                auth_api_retry(call)
            } else {
                Log.d("readSMS", "Failed to upload SMS: ${response.code()} - ${response.message()}")
//                parent_callback.onUploadFailure(
//                    response.code(),
//                    "SMS failure for packet :${response.errorBody()?.string()}"
//                )
            }
        }
    }

    override fun onFailure(call: Call<ResponseBody>, t: Throwable) {
        Log.d("readSMS", "Failure in API call: ${t.cause} - ${t.message}")
        //retry(call)
//        parent_callback.onUploadFailure(
//            -1,
//            "SMS failure for packet : ${t.message}"
//        )
    }

    private fun shouldRetry(responseCode: Int): Boolean {
        return responseCode == 404 || (responseCode >= 500 && responseCode < 600) || responseCode == 403
    }

    private fun retry(call: Call<ResponseBody>) {
        if (retryCount < maxRetries) {
            retryCount++
            val backoffTime =
                initialBackoffTime * Math.pow(2.0, (retryCount - 1).toDouble()).toLong()
            Handler(Looper.getMainLooper()).postDelayed({
                call.clone().enqueue(this)
            }, backoffTime)
            Log.d("readSMS", "Retrying... Attempt: $retryCount")
        } else {
            Log.d("readSMS", "Max retries reached. No more attempts.")
        }
    }

    private fun auth_api_retry(call: Call<ResponseBody>) {
        if (authRetryCount < 1) {
            authRetryCount++
            // call the auth api to get the new token
            val (client_email, access_key) = checkpoint.getClientDetails(context)
            val authRequestData = AuthRequestData(client_email, access_key)

            SmsAPI.retrofitService.clientAuth(authRequestData)
                .enqueue(object : Callback<AuthResponseData> {
                    override fun onResponse(
                        call: Call<AuthResponseData>,
                        response: Response<AuthResponseData>
                    ) {
                        if (response.isSuccessful) {
                            val AuthToken = "Bearer " + response.body()?.access
                            Log.d("readSMS", "AuthToken : $AuthToken")

                            val upload_timestamp = System.currentTimeMillis().toString()


                            val httpHelper = HttpHelper()
                            val checkSum = httpHelper.bytesToHexString(
                                MessageDigest.getInstance("MD5").digest(
                                    (Constants.HEADER_TYPE.HEADER_API_VERSION_VALUE + AuthToken + apiString +
                                            upload_timestamp).toByteArray(
                                        StandardCharsets.UTF_8
                                    )
                                )
                            )

                            var newCall = SmsAPI.retrofitService.uploadSMS(
                                Android_id,
                                upload_timestamp,
                                checkSum,
                                AuthToken,
                                apiObj
                            )
                            newCall.enqueue(this@SMSAPIServiceImpl)

                        } else {
                            Log.d("readSMS", "client id : $client_email")
                            Log.d("readSMS", "Error in API call: ${response.code()}")

                        }

                    }

                    override fun onFailure(call: Call<AuthResponseData>, t: Throwable) {
                        Log.d("readSMS", "Auth API Failure : ${t.message}")

                    }
                })

        }
        // call the upload sms api with the new token for the failed packet
        else {
            Log.d("readSMS", "Max retries reached. No more attempts.")
        }
    }
}
