package com.payufin.mobilemsg.network

import android.content.Context
import com.payufin.mobilemsg.configurables.Constants
import com.payufin.mobilemsg.configurables.SdkConfig
import okhttp3.OkHttpClient
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import java.util.concurrent.TimeUnit


object SmsAPI {

    private val okHttpClient: OkHttpClient = OkHttpClient.Builder()
        .connectTimeout(20, TimeUnit.SECONDS)
        .readTimeout(20, TimeUnit.SECONDS)
        .writeTimeout(20, TimeUnit.SECONDS)
        .build()


    private val retrofit = Retrofit.Builder()
        .addConverterFactory(GsonConverterFactory.create())
        .baseUrl(Constants.EndPoints.BASE_URL)
        .client(okHttpClient)
        .build()


    val retrofitService: SmsAPIService by lazy {
        retrofit.create(SmsAPIService::class.java)
    }

    private var mSmsDataSource: SmsDataSource? = null
    fun getSmsDataSourceInstance(config: SdkConfig, context: Context): SmsDataSource {
        if (mSmsDataSource == null) {
            mSmsDataSource = SmsDataSource( retrofit.create(SmsAPIService::class.java), config, context )
        }
        return mSmsDataSource!!
    }
}