package com.payufin.mobilemsg.network

import com.payufin.mobilemsg.configurables.Constants
import com.payufin.mobilemsg.models.AuthRequestData
import com.payufin.mobilemsg.models.AuthResponseData
import com.payufin.mobilemsg.models.SmsBodyData
import okhttp3.ResponseBody
import retrofit2.Call
import retrofit2.http.Body
import retrofit2.http.Header
import retrofit2.http.Headers
import retrofit2.http.POST


interface SmsAPIService{

    @Headers("${Constants.HEADER_TYPE.HEADER_CONTENT_TYPE}: ${Constants.HEADER_TYPE.HEADER_CONTENT_TYPE_JSON}",
        "${Constants.HEADER_TYPE.HEADER_API_VERSION}: ${Constants.HEADER_TYPE.HEADER_API_VERSION_VALUE}",
        //"${constants.HEADER_TYPE.HEADER_AUTHORIZATION}: ${constants.HEADER_TYPE.HEADER_API_AUTH_TOKEN}"
    )
    @POST(Constants.EndPoints.UPLOAD_SMS_API_ENDPOINT)
    fun uploadSMS(
        @Header(Constants.HEADER_TYPE.HEADER_ANDROID_ID) androidId: String,
        @Header(Constants.HEADER_TYPE.HEADER_API_UPLOAD_TIME) uploadTimestamp: String,
        @Header(Constants.HEADER_TYPE.HEADER_API_CHECKSUM) checksum : String,
        @Header(Constants.HEADER_TYPE.HEADER_AUTHORIZATION) authToken : String?,
        @Body smsBodyData : SmsBodyData
    ) : Call<ResponseBody>

    @POST(Constants.EndPoints.AUTH_API_ENDPOINT)
    fun clientAuth(
        @Body authRequestData : AuthRequestData
    ): Call<AuthResponseData>
}
