package com.payufin.mobilemsg.network

import android.content.Context
import com.orhanobut.logger.Logger
import com.payufin.mobilemsg.configurables.SdkConfig
import com.payufin.mobilemsg.helper.Callback
import com.payufin.mobilemsg.models.AuthRequestData
import com.payufin.mobilemsg.models.AuthResponseData
import com.payufin.mobilemsg.models.SmsBodyData
import com.payufin.mobilemsg.models.SmsUploadRequestData
import com.payufin.mobilemsg.sms.checkpoint
import okhttp3.ResponseBody

class SmsRepository(
    private val context: Context,
    private val smsDataSource: SmsDataSource,
    val config: SdkConfig ) {

    companion object {
        private val retryCounter = mutableMapOf<String, Int>()
    }

    suspend fun getAuthToken(authRequestDataRequest: AuthRequestData, callback: Callback<Boolean> ) {
        smsDataSource.getAuthToken( authRequestDataRequest, object : Callback<AuthResponseData>{
            override suspend fun onSuccess(t: AuthResponseData) {
                handleSuccessAuthResponse( t, callback )
            }


            override suspend fun onFailure(message: String?, code: Int) {
                handleFailureAuthResponse( message, code, callback )
            }

        } )

    }

    suspend fun uploadSms( smsUploadRequestData: SmsUploadRequestData,
                            callback: Callback<ResponseBody> ){
        //val smsUploadRequestData = smsUploadRequest

        smsDataSource.uploadSms( smsUploadRequestData, object : Callback<ResponseBody>{
            override suspend fun onSuccess(t: ResponseBody) {
                handleSuccessUploadSmsResponse(t, smsUploadRequestData.smsBodyData, callback )
            }

            override suspend fun onFailure(message: String?, code: Int) {
                handleFailureUploadSmsResponse( message, code, smsUploadRequestData, callback )
            }

        } )
    }


    suspend fun handleSuccessAuthResponse(response: AuthResponseData, callback: Callback<Boolean> ) {
        Logger.d("readSMSSDK : SmsRepository: Success in API call - %s", response)
        val authToken = "Bearer " + response.access
        Logger.d("readSMSSDK : SmsRepository AuthToken - %s", authToken)

        // TODO: save auth token in memory or SP
        checkpoint.setAuthToken(context, authToken)
        callback.onSuccess( true )
    }

    suspend fun handleFailureAuthResponse(message: String?, code: Int, callback: Callback<Boolean> ) {
        Logger.d("readSMSSDK : SmsRepository Error in API call - %s", code)
        callback.onFailure( message, code )
    }

    suspend fun handleSuccessUploadSmsResponse( response: ResponseBody
                                               , apiObj: SmsBodyData
                                                , callback: Callback<ResponseBody> ) {
        var (lastSyncedLatestTimestamp, lastSyncedEarliestTimestamp) = checkpoint.getLastSyncedIndex(context)
        Logger.d("readSMSSDK : Last Synced Latest Message Checkpoint Epoch Timestamp - %s", lastSyncedLatestTimestamp)
        Logger.d("readSMSSDK : Last Synced Earliest Message Checkpoint Epoch Timestamp - %s", lastSyncedEarliestTimestamp)


        val apiMsgList = apiObj.messages

        if(apiMsgList.isNotEmpty() && (lastSyncedEarliestTimestamp.toInt() == -1 || apiMsgList.last().get("date").asLong < lastSyncedEarliestTimestamp))
            lastSyncedEarliestTimestamp = apiMsgList.last().get("date").asLong

        if(apiMsgList.isNotEmpty() && (lastSyncedLatestTimestamp.toInt() == -1 || apiMsgList.first().get("date").asLong > lastSyncedLatestTimestamp))
            lastSyncedLatestTimestamp = apiMsgList.first().get("date").asLong

        checkpoint.setLastSyncedIndex(
            context,
            lastSyncedLatestTimestamp,
            lastSyncedEarliestTimestamp
        )


        //val responseBody = response.code()
        Logger.d("readSMSSDK : Response - %s", response)

        Logger.d("readSMSSDK : SMS uploaded successfully!")



        callback.onSuccess( response )
    }

    suspend fun handleFailureUploadSmsResponse( message: String?
                                               , code: Int
                                               , smsUploadRequestData: SmsUploadRequestData
                                                , callback: Callback<ResponseBody> ) {



        // TODO: check this
        callback.onFailure( message, code)

        }

}


