package com.payufin.mobilemsg.sms

import android.content.Context
import android.os.Handler
import android.os.Looper
import android.util.Log
import com.payufin.mobilemsg.models.AuthRequestData
import com.payufin.mobilemsg.models.AuthResponseData
import com.payufin.mobilemsg.network.SmsAPI
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.SupervisorJob
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response

/*
This is the entrypoint for SDK
The SDK initialized by the parent app will call the Auth API to authenticate the client
    On successful authentication - SMS permission needs to be checked
    On failure - return signal to parent app that the authentication has failed

 */
class APIAuth(main_context: Context, client_id: String, access_id: String, private val callback: SdkCallback) {

    private val context = main_context
    private val client_email = client_id
    private val access_key = access_id
    private var callbackMessage: String = ""
    private var retryCount = 0
    private val maxRetries = 3
    private var flag = 1
    private val initialBackoffTime = 1000 // Initial backoff time in milliseconds
    val coroutineScope = CoroutineScope(Dispatchers.IO + SupervisorJob())

    init {

            AuthenticateAPI()
    }


    
    fun AuthenticateAPI(): String {

        checkpoint.setClientDetails(context, client_email, access_key)
        val authRequestData = AuthRequestData(client_email, access_key)

        Log.d("readSMS", "client id : $client_email")
        Log.d("readSMS", "access_key : $access_key")


        // call the Auth API
        SmsAPI.retrofitService.clientAuth(authRequestData)
            .enqueue(object : Callback<AuthResponseData>{
                override fun onResponse(
                    call: Call<AuthResponseData>,
                    response: Response<AuthResponseData>
                ) {
                    if(response.isSuccessful){
                        val AuthToken = "Bearer " + response.body()?.access
                        Log.d("readSMS", "AuthToken : $AuthToken")
                        //readSMS(context, AuthToken, callback)
                    }
                    else{
                        Log.d("readSMS", "client id : $client_email")
                        Log.d("readSMS", "Error in API call: ${response.code()}")
                        if (shouldRetry(response.code())) {
                            retry(call)
                            if(flag == 1 && retryCount >= maxRetries)
                            {
                                flag = 0
                                //callback.onAuthFailure(response.code(), "${response.errorBody()?.string()}")
                            }
                        }
                        else {
                            Log.d("readSMS", "Failed to upload SMS: ${response.code()} - ${response.message()}")
                            //callback.onAuthFailure(response.code(), "${response.errorBody()?.string()}")
                        }

                    }

                }

                override fun onFailure(call: Call<AuthResponseData>, t: Throwable) {
                    Log.d("readSMS", "Auth API Failure : ${t.message}")
//                    retry(call)
//                    if(retryCount >= maxRetries)
                    //callback.onAuthFailure(-1, "${t.message}")


                }

                private fun shouldRetry(responseCode: Int): Boolean {
                    return responseCode == 404 || (responseCode >= 500 && responseCode < 600)
                }

                private fun retry(call: Call<AuthResponseData>) {
                    if (retryCount < maxRetries) {
                        retryCount++
                        val backoffTime = initialBackoffTime * Math.pow(2.0, (retryCount - 1).toDouble()).toLong()
                        Handler(Looper.getMainLooper()).postDelayed({
                            call.clone().enqueue(this)
                        }, backoffTime)
                        Log.d("readSMS", "Retrying... Attempt: $retryCount")
                    } else {
                        Log.d("readSMS", "Max retries reached. No more attempts.")

                    }
                }


            }
            )

        return ""
    }
}

