package com.payufin.mobilemsg.sms

import android.content.Context

object checkpoint {
    private const val CHECKPOINT_VAR = "sms_checkpoint"
    private const val LAST_SYNCED_LATEST_INDEX = "last_synced_latest_index"
    private const val LAST_SYNCED_EARLIEST_INDEX = "last_synced_earliest_index"
    private const val CLIENT_ID = "client_id"
    private const val ACCESS_KEY = "access_key"
    private const val AUTH_TOKEN = "auth_token"

    fun getLastSyncedIndex(context: Context): Pair<Long,Long> {
        val sharedPreferences = context.getSharedPreferences(CHECKPOINT_VAR, Context.MODE_PRIVATE)
        val latestIndex =  sharedPreferences.getLong(LAST_SYNCED_LATEST_INDEX, -1) // Default to -1 if not found
        val earliestIndex = sharedPreferences.getLong(LAST_SYNCED_EARLIEST_INDEX, -1) // Default to -1 if not found

        return Pair(latestIndex, earliestIndex)
    }

    fun setLastSyncedIndex(context: Context, latestIndex: Long, earliestIndex: Long) {
        val sharedPreferences = context.getSharedPreferences(CHECKPOINT_VAR, Context.MODE_PRIVATE)
        with(sharedPreferences.edit()) {
            putLong(LAST_SYNCED_LATEST_INDEX, latestIndex)
            putLong(LAST_SYNCED_EARLIEST_INDEX, earliestIndex)
            apply()
        }
    }

    fun getClientDetails(context: Context): Pair<String?, String?> {
        val sharedPreferences = context.getSharedPreferences(CHECKPOINT_VAR, Context.MODE_PRIVATE)
        val clientId = sharedPreferences.getString(CLIENT_ID, "")
        val accessKey = sharedPreferences.getString(ACCESS_KEY, "")

        return Pair(clientId, accessKey)
    }

    fun setClientDetails(context: Context, clientId: String, accessKey: String) {
        val sharedPreferences = context.getSharedPreferences(CHECKPOINT_VAR, Context.MODE_PRIVATE)
        with(sharedPreferences.edit()) {
            putString(CLIENT_ID, clientId)
            putString(ACCESS_KEY, accessKey)
            apply()
        }
    }

    fun getAuthToken(context: Context): String? {
        val sharedPreferences = context.getSharedPreferences(CHECKPOINT_VAR, Context.MODE_PRIVATE)
        val authToken = sharedPreferences.getString(AUTH_TOKEN, "")

        return authToken
    }

    fun setAuthToken(context: Context, authToken: String) {
        val sharedPreferences = context.getSharedPreferences(CHECKPOINT_VAR, Context.MODE_PRIVATE)
        with(sharedPreferences.edit()) {
            putString(AUTH_TOKEN, authToken)
            apply()
        }
    }
}
