package com.payufin.mobilemsg.sms

import android.content.Context
import com.google.gson.JsonObject
import com.orhanobut.logger.Logger
import com.payufin.mobilemsg.configurables.Constants
import com.payufin.mobilemsg.helper.HttpHelper
import com.payufin.mobilemsg.helper.Utils
import com.payufin.mobilemsg.models.SmsBodyData
import com.payufin.mobilemsg.models.SmsUploadRequestData
import java.nio.charset.StandardCharsets
import java.security.MessageDigest

class UploadSms{

    suspend fun getSmsUploadRequest(
                                androidId : String,
                                smsList: List<JsonObject>,
                                smsPermissionAvailable: Boolean,
                                context: Context): SmsUploadRequestData {

        Logger.d("readSMSSDK : Sms List size is - %s", smsList.size)

        // fetch auth token
        val authToken = checkpoint.getAuthToken(context)

        val apiMsgList = smsList.toList()
        // smsList.clear()

        val uploadTimestamp = System.currentTimeMillis().toString()

        var smsDataFound = true
        if(apiMsgList.isEmpty())
            smsDataFound = false

        val apiObj = SmsBodyData(android_id = androidId, smsPermissionAvailable, smsDataFound, messages = apiMsgList)
        // val apiString = gson.toJson(apiObj)
        val apiString = Utils.toJson(apiObj)


        // generating hash for each sms packet
        val httpHelper = HttpHelper()
        val checkSum = httpHelper.bytesToHexString(
            MessageDigest.getInstance("MD5").digest(
                (Constants.HEADER_TYPE.HEADER_API_VERSION_VALUE + authToken + apiString +
                        uploadTimestamp).toByteArray(
                    StandardCharsets.UTF_8
                )
            )
        )



        Logger.d("readSMSSDK : Checksum value - %s", checkSum)
        Logger.d("readSMSSDK : Hitting API")


        val smsUploadRequestData = SmsUploadRequestData(uploadTimestamp, checkSum, authToken, apiObj)
//        val smsUploadRequest    = SmsUploadRequest( smsUploadRequestData, androidId, smsList,
//                                                authToken, smsPermissionAvailable, apiMsgList, apiObj)

        return smsUploadRequestData
    }


}
